/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCActionTableModelInterface;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;

public class PropertiesHandlers {
    public static final String PROPERTY_NAME = "propertyName";
    public static final String PROPERTY_VALUE = "propertyValue";
    public static final String PROPERTY_WEIGHT = "weight";
    public static final String PROPERTY_DEFAULT_VALUE = "defaultValue";
    public static final String PROPERTY_ORIGINAL_OVERRIDE_VALUE = "originalOverrideValue";

    private CCActionTableModelInterface getModel(HandlerContext handlerCtx) {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("propertiesModel");
        if (model == null) {
            throw new FrameworkException("PropertiesHandler.getModel: Parameter 'propertiesModel' not specified");
        }
        return model;
    }

    private void loadModel(CCActionTableModelInterface model, AttributeList attrs, Object excludes) throws ModelControlException {
        Attribute attr;
        int rowNo;
        RequestContext ctx = RequestManager.getRequestContext();
        if (attrs == null) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        if (Util.isLoggableFINER()) {
            for (rowNo = 0; rowNo < attrs.size(); ++rowNo) {
                attr = (Attribute)attrs.get(rowNo);
                buf.append("properties table : name = " + attr.getName() + " , value = " + attr.getValue() + "\n");
            }
            Util.logFINER(buf.toString());
        }
        model.beforeFirst();
        for (rowNo = 0; rowNo < attrs.size(); ++rowNo) {
            attr = (Attribute)attrs.get(rowNo);
            if (this.shouldExclude(attr.getName(), excludes)) continue;
            model.appendRow();
            model.setValue(PROPERTY_NAME, (Object)attr.getName());
            model.setValue(PROPERTY_VALUE, attr.getValue());
            model.setRowSelected(false);
        }
    }

    private void loadModel(CCActionTableModelInterface model, Properties props, Object excludes) throws ModelControlException {
        if (props == null) {
            return;
        }
        ((DefaultModel)model).clear();
        model.beforeFirst();
        Enumeration<?> ee = props.propertyNames();
        while (ee.hasMoreElements()) {
            String name = (String)ee.nextElement();
            if (this.shouldExclude(name, excludes)) continue;
            model.appendRow();
            model.setValue(PROPERTY_NAME, (Object)name);
            model.setValue(PROPERTY_VALUE, (Object)props.getProperty(name));
            model.setRowSelected(false);
            if (!Util.isLoggableFINER()) continue;
            Util.logFINER("properties table : " + name + ":" + props.getProperty(name));
        }
    }

    private boolean shouldExclude(String name, Object excludes) {
        List list = (List)excludes;
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).equals(name)) continue;
            return true;
        }
        return false;
    }

    private void loadModel(CCActionTableModelInterface model, Properties configProps, Properties targetProps, boolean instPropsOnly) throws ModelControlException {
        if (configProps == null) {
            return;
        }
        model.beforeFirst();
        Enumeration<?> ee = configProps.propertyNames();
        if (!instPropsOnly) {
            while (ee.hasMoreElements()) {
                String name = (String)ee.nextElement();
                model.appendRow();
                model.setValue(PROPERTY_NAME, (Object)name);
                model.setValue(PROPERTY_DEFAULT_VALUE, (Object)configProps.getProperty(name));
                if (targetProps != null) {
                    model.setValue(PROPERTY_VALUE, (Object)targetProps.getProperty(name, ""));
                    model.setValue(PROPERTY_ORIGINAL_OVERRIDE_VALUE, (Object)targetProps.getProperty(name, ""));
                } else {
                    model.setValue(PROPERTY_VALUE, (Object)"");
                    model.setValue(PROPERTY_ORIGINAL_OVERRIDE_VALUE, (Object)"");
                }
                model.setRowSelected(false);
                if (!Util.isLoggableFINER()) continue;
                String msg = "properties table : " + name + ":" + configProps.getProperty(name);
                if (targetProps != null) {
                    msg = msg + ":" + targetProps.getProperty(name, "");
                }
                Util.logFINER(msg);
            }
        } else {
            ee = targetProps.propertyNames();
            while (ee.hasMoreElements()) {
                String name = (String)ee.nextElement();
                String value = configProps.getProperty(name, null);
                if (value != null) continue;
                model.appendRow();
                model.setValue(PROPERTY_NAME, (Object)name);
                model.setValue(PROPERTY_VALUE, (Object)targetProps.getProperty(name, ""));
                model.setValue(PROPERTY_ORIGINAL_OVERRIDE_VALUE, (Object)targetProps.getProperty(name, ""));
            }
        }
    }

    public void loadProperties(RequestContext ctx, HandlerContext handlerCtx) {
        try {
            CCActionTableModelInterface model = this.getModel(handlerCtx);
            ((DefaultModel)model).clear();
            Object obj = handlerCtx.getInputValue("properties");
            Object excludes = handlerCtx.getInputValue("excludes");
            if (obj instanceof AttributeList) {
                this.loadModel(model, (AttributeList)obj, excludes);
            } else {
                this.loadModel(model, (Properties)obj, excludes);
            }
        }
        catch (Exception ex) {
            throw new FrameworkException("loadProperties: Loading error. ", (Throwable)ex);
        }
    }

    public void loadSystemProperties(RequestContext ctx, HandlerContext handlerCtx) {
        try {
            CCActionTableModelInterface model = this.getModel(handlerCtx);
            String objectName = (String)handlerCtx.getInputValue("objectName");
            String methodName = (String)handlerCtx.getInputValue("methodName");
            String configName = (String)handlerCtx.getInputValue("configName");
            String targetName = (String)handlerCtx.getInputValue("targetName");
            Boolean inherit = (Boolean)handlerCtx.getInputValue("inherit");
            Boolean instPropsOnly = (Boolean)handlerCtx.getInputValue("instPropsOnly");
            if (objectName == null || methodName == null || configName == null) {
                throw new FrameworkException("Missing input parameter to loadSystemProperties()");
            }
            String[] types = new String[]{"java.lang.String", "boolean"};
            Object[] params = new Object[]{configName, inherit};
            Properties configProps = (Properties)MBeanUtil.invoke(objectName, methodName, params, types);
            Properties targetProps = null;
            if (targetName != null) {
                params = new Object[]{targetName, inherit};
                targetProps = (Properties)MBeanUtil.invoke(objectName, methodName, params, types);
            }
            this.loadModel(model, configProps, targetProps, instPropsOnly);
        }
        catch (Exception ex) {
            throw new FrameworkException("loadSystemProperties: Loading error. ", (Throwable)ex);
        }
    }

    public void saveProperties(RequestContext ctx, HandlerContext handlerCtx) throws ModelControlException {
        Object objectName = handlerCtx.getInputValue("objectName");
        if (objectName == null) {
            throw new FrameworkException("objectName not specified in saveProperties.");
        }
        String setMethodName = (String)handlerCtx.getInputValue("setMethodName");
        if (setMethodName == null) {
            setMethodName = "setProperty";
        }
        CCActionTableModelInterface model = this.getModel(handlerCtx);
        model.beforeFirst();
        AttributeList originalProperties = (AttributeList)handlerCtx.getInputValue("originalProperties");
        AttributeList attrs = new AttributeList();
        while (model.next()) {
            String name = (String)model.getValue(PROPERTY_NAME);
            String value = (String)model.getValue(PROPERTY_VALUE);
            if (Util.isEmpty(name) || Util.isEmpty(value)) continue;
            attrs.add(new Attribute(name, value));
        }
        String[] type = new String[]{"javax.management.Attribute"};
        if (originalProperties != null) {
            for (int i = 0; i < originalProperties.size(); ++i) {
                Attribute originalProperty = (Attribute)originalProperties.get(i);
                boolean found = false;
                for (int j = 0; j < attrs.size(); ++j) {
                    Attribute attr = (Attribute)attrs.get(j);
                    if (!attr.getName().equals(originalProperty.getName())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                Attribute propertyToClear = new Attribute(originalProperty.getName(), null);
                Object[] params = new Object[]{propertyToClear};
                MBeanUtil.invoke(objectName.toString(), setMethodName, params, type);
            }
        }
        for (int i = 0; i < attrs.size(); ++i) {
            Attribute attr = (Attribute)attrs.get(i);
            Object[] params = new Object[]{attr};
            MBeanUtil.invoke(objectName.toString(), setMethodName, params, type);
        }
    }

    public void saveSystemProperties(RequestContext ctx, HandlerContext handlerCtx) throws ModelControlException {
        String deleteMethodName;
        Object objectName = handlerCtx.getInputValue("objectName");
        if (objectName == null) {
            throw new FrameworkException("objectName not specified in saveSystemProperties.");
        }
        String target = (String)handlerCtx.getInputValue("target");
        if (target == null) {
            throw new FrameworkException("target not specified in saveSystemProperties.");
        }
        String createMethodName = (String)handlerCtx.getInputValue("createMethodName");
        if (createMethodName == null) {
            createMethodName = "createSystemProperties";
        }
        if ((deleteMethodName = (String)handlerCtx.getInputValue("deleteMethodName")) == null) {
            deleteMethodName = "deleteSystemProperty";
        }
        CCActionTableModelInterface model = this.getModel(handlerCtx);
        model.beforeFirst();
        Properties originalProperties = (Properties)handlerCtx.getInputValue("originalProperties");
        Properties propertiesToCreate = new Properties();
        while (model.next()) {
            String name = (String)model.getValue(PROPERTY_NAME);
            if (name == null || name.trim().equals("")) continue;
            String value = (String)model.getValue(PROPERTY_VALUE);
            propertiesToCreate.setProperty(name, value);
        }
        String[] types = null;
        if (originalProperties != null) {
            Enumeration<?> deleteProps = originalProperties.propertyNames();
            types = new String[]{"java.lang.String", "java.lang.String"};
            while (deleteProps.hasMoreElements()) {
                String name = (String)deleteProps.nextElement();
                Object[] params = new Object[]{name, target};
                MBeanUtil.invoke(objectName.toString(), deleteMethodName, params, types);
            }
        }
        types = new String[]{"java.util.Properties", "java.lang.String"};
        Object[] params = new Object[]{propertiesToCreate, target};
        MBeanUtil.invoke(objectName.toString(), createMethodName, params, types);
    }

    public void deleteInstOnlyProps(RequestContext ctx, HandlerContext handlerCtx) throws ModelControlException {
        String deleteMethodName = (String)handlerCtx.getInputValue("deleteMethodName");
        if (deleteMethodName == null) {
            deleteMethodName = "deleteSystemProperty";
        }
        String objectName = (String)handlerCtx.getInputValue("objectName");
        String methodName = (String)handlerCtx.getInputValue("methodName");
        String configName = (String)handlerCtx.getInputValue("configName");
        String targetName = (String)handlerCtx.getInputValue("targetName");
        Boolean inherit = (Boolean)handlerCtx.getInputValue("inherit");
        if (objectName == null || methodName == null || configName == null || targetName == null) {
            throw new FrameworkException("Missing input parameter to deleteInstOnlyProps()");
        }
        String[] types = new String[]{"java.lang.String", "boolean"};
        Object[] params = new Object[]{configName, inherit};
        Properties configProps = (Properties)MBeanUtil.invoke(objectName, methodName, params, types);
        Properties targetProps = null;
        params = new Object[]{targetName, inherit};
        targetProps = (Properties)MBeanUtil.invoke(objectName, methodName, params, types);
        types = new String[]{"java.lang.String", "java.lang.String"};
        Enumeration<?> ee = targetProps.propertyNames();
        while (ee.hasMoreElements()) {
            String name = (String)ee.nextElement();
            String value = configProps.getProperty(name, null);
            if (value != null) continue;
            params = new Object[]{name, targetName};
            MBeanUtil.invoke(objectName, deleteMethodName, params, types);
        }
    }

    public void saveSystemPropertiesValues(RequestContext ctx, HandlerContext handlerCtx) throws ModelControlException {
        String deleteMethodName;
        Object objectName = handlerCtx.getInputValue("objectName");
        if (objectName == null) {
            throw new FrameworkException("objectName not specified in saveSystemProperties.");
        }
        String target = (String)handlerCtx.getInputValue("target");
        if (target == null) {
            throw new FrameworkException("target not specified in saveSystemProperties.");
        }
        String createMethodName = (String)handlerCtx.getInputValue("createMethodName");
        if (createMethodName == null) {
            createMethodName = "createSystemProperties";
        }
        if ((deleteMethodName = (String)handlerCtx.getInputValue("deleteMethodName")) == null) {
            deleteMethodName = "deleteSystemProperty";
        }
        CCActionTableModelInterface model = this.getModel(handlerCtx);
        model.beforeFirst();
        String[] deleteTypes = new String[]{"java.lang.String", "java.lang.String"};
        Properties propertiesToCreate = new Properties();
        while (model.next()) {
            String name = (String)model.getValue(PROPERTY_NAME);
            String originalValue = (String)model.getValue(PROPERTY_ORIGINAL_OVERRIDE_VALUE);
            String newValue = (String)model.getValue(PROPERTY_VALUE);
            if (name == null || name.trim().length() == 0 || originalValue.trim().equals(newValue.trim())) continue;
            if (originalValue.trim().length() != 0 && newValue.trim().length() == 0) {
                Object[] params = new Object[]{name, target};
                try {
                    MBeanUtil.invoke(objectName.toString(), deleteMethodName, params, deleteTypes);
                }
                catch (Exception ex) {
                    System.out.println("error while trying to delete a system property!!");
                }
            }
            if (newValue.trim().length() == 0) continue;
            propertiesToCreate.setProperty(name, newValue);
        }
        if (propertiesToCreate.size() > 0) {
            String[] types = new String[]{"java.util.Properties", "java.lang.String"};
            Object[] params = new Object[]{propertiesToCreate, target};
            try {
                MBeanUtil.invoke(objectName.toString(), createMethodName, params, types);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public void deleteProperties(RequestContext ctx, HandlerContext handlerCtx) throws ModelControlException {
        CCActionTableModelInterface model = this.getModel(handlerCtx);
        AttributeList attrs = new AttributeList();
        model.setRowSelectionType("multiple");
        model.beforeFirst();
        while (model.next()) {
            if (model.isRowSelected()) continue;
            String name = (String)model.getValue(PROPERTY_NAME);
            String value = (String)model.getValue(PROPERTY_VALUE);
            attrs.add(new Attribute(name, value));
        }
        ((DefaultModel)model).clear();
        model.beforeFirst();
        for (int i = 0; i < attrs.size(); ++i) {
            model.appendRow();
            Attribute attr = (Attribute)attrs.get(i);
            model.setValue(PROPERTY_NAME, (Object)attr.getName());
            model.setValue(PROPERTY_VALUE, attr.getValue());
            model.setRowSelected(false);
        }
    }

    public void clearProperties(RequestContext ctx, HandlerContext handlerCtx) throws ModelControlException {
        CCActionTableModelInterface model = this.getModel(handlerCtx);
        ((DefaultModel)model).clear();
        model.beforeFirst();
    }

    public void addProperty(RequestContext ctx, HandlerContext handlerCtx) throws ModelControlException {
        CCActionTableModelInterface model = this.getModel(handlerCtx);
        model.setRowSelectionType("multiple");
        model.appendRow();
        model.setValue(PROPERTY_VALUE, (Object)"");
        model.setValue(PROPERTY_NAME, (Object)"");
        model.sort();
        model.beforeFirst();
    }

    public void getPropertiesObjectFromTable(RequestContext ctx, HandlerContext handlerCtx) throws ModelControlException {
        Boolean ignoreEmptyValues = (Boolean)handlerCtx.getInputValue("ignoreEmptyValues");
        String propValue = (String)handlerCtx.getInputValue("propValue");
        CCActionTableModelInterface model = this.getModel(handlerCtx);
        model.beforeFirst();
        CCActionTableModel cct = (CCActionTableModel)model;
        Properties properties = new Properties();
        while (model.next()) {
            String name = (String)model.getValue(PROPERTY_NAME);
            String value = propValue != null ? (String)model.getValue(propValue) : (String)model.getValue(PROPERTY_VALUE);
            if (Util.isEmpty(name) || Util.isEmpty(value) && ignoreEmptyValues != null && ignoreEmptyValues.booleanValue()) continue;
            properties.setProperty(name, value);
        }
        handlerCtx.setOutputValue("properties", (Object)properties);
    }

    public void sortModel(RequestContext ctx, HandlerContext handlerCtx) throws ModelControlException {
        CCActionTableModelInterface model = this.getModel(handlerCtx);
        if (model != null) {
            model.sort();
        }
    }

    public void addTableRow(RequestContext ctx, HandlerContext handlerCtx) throws ModelControlException {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("model");
        model.setRowSelectionType("multiple");
        model.appendRow();
        model.beforeFirst();
    }
}

