/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.util;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.config.MBeanConfigInstanceNotFoundException;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import java.util.ArrayList;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class MBeanUtil {
    private static MBeanServerConnection remoteConnection = null;

    public static Object invoke(String objectName, String operationName, Object[] params, String[] signature) {
        try {
            return MBeanUtil.invoke(new ObjectName(objectName), operationName, params, signature);
        }
        catch (Exception ex) {
            if (Util.isLoggableFINE()) {
                NonSyncStringBuffer buf = new NonSyncStringBuffer();
                buf.append(ex.getMessage());
                buf.append("MBUtil.invoke failed:\n");
                buf.append("    OBJECT NAME: " + objectName + "\n");
                buf.append("    OPERATION NAME: " + operationName + "\n");
                Util.logFINE(buf.toString());
            }
            throw new FrameworkException((Throwable)ex);
        }
    }

    public static AttributeList getAttributes(String objectName, String[] attributeNames) {
        try {
            return MBeanUtil.getMBeanServer().getAttributes(new ObjectName(objectName), attributeNames);
        }
        catch (Exception ex) {
            throw new FrameworkException((Throwable)ex);
        }
    }

    public static Object getAttribute(ObjectName objectName, String attributeName) {
        try {
            return MBeanUtil.getMBeanServer().getAttribute(objectName, attributeName);
        }
        catch (Exception ex) {
            if (Util.isLoggableFINE()) {
                NonSyncStringBuffer buf = new NonSyncStringBuffer();
                buf.append(ex.getMessage());
                buf.append("Attribute not found on the given Object:\n");
                buf.append("    OBJECT NAME: " + objectName + "\n");
                buf.append("    ATTRIBUTE NAME: " + attributeName + "\n");
                Util.logFINE(buf.toString());
            }
            throw new FrameworkException((Throwable)ex);
        }
    }

    public static Object getAttribute(String objectName, String attributeName) {
        try {
            return MBeanUtil.getMBeanServer().getAttribute(new ObjectName(objectName), attributeName);
        }
        catch (Exception ex) {
            if (Util.isLoggableFINE()) {
                NonSyncStringBuffer buf = new NonSyncStringBuffer();
                buf.append(ex.getMessage());
                buf.append("Attribute not found on the given Object:\n");
                buf.append("    OBJECT NAME: " + objectName + "\n");
                buf.append("    ATTRIBUTE NAME: " + attributeName + "\n");
                Util.logFINE(buf.toString());
            }
            throw new FrameworkException((Throwable)ex);
        }
    }

    public static void setAttribute(String objectName, Attribute attributeName) {
        try {
            MBeanUtil.setAttribute(new ObjectName(objectName), attributeName);
        }
        catch (Exception ex) {
            throw new FrameworkException((Throwable)ex);
        }
    }

    public static void setAttribute(ObjectName objectName, Attribute attributeName) {
        try {
            MBeanUtil.getMBeanServer().setAttribute(objectName, attributeName);
        }
        catch (Exception ex) {
            throw new FrameworkException((Throwable)ex);
        }
    }

    public static AttributeList setAttributes(String objectName, AttributeList attributes) {
        try {
            return MBeanUtil.getMBeanServer().setAttributes(new ObjectName(objectName), attributes);
        }
        catch (Exception ex) {
            throw new FrameworkException((Throwable)ex);
        }
    }

    public static Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) {
        if (Util.isLoggableFINE()) {
            int i;
            NonSyncStringBuffer buf = new NonSyncStringBuffer();
            buf.append("***** Calling MBean Server *****\n");
            buf.append("objectName = " + objectName + "\n");
            buf.append("operationName = " + operationName + "\n");
            if (params != null) {
                for (i = 0; i < params.length; ++i) {
                    buf.append("params[" + i + "] = " + params[i]);
                }
            }
            if (signature != null) {
                for (i = 0; i < signature.length; ++i) {
                    buf.append("types[" + i + "] = " + signature[i]);
                }
            }
            buf.append("params = " + params);
            buf.append("signature = " + signature);
            Util.logFINE(buf.toString());
        }
        try {
            return MBeanUtil.getMBeanServer().invoke(objectName, operationName, params, signature);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof MBeanConfigInstanceNotFoundException) {
                return null;
            }
            throw new FrameworkException((Throwable)ex);
        }
    }

    public static boolean isValidMBean(String objectName) {
        boolean valid = false;
        try {
            Set<ObjectInstance> beans = MBeanUtil.getMBeanServer().queryMBeans(new ObjectName(objectName), null);
            if (beans.size() > 0) {
                valid = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valid;
    }

    public static MBeanServerConnection getMBeanServer() {
        return MBeanServerFactory.getMBeanServer();
    }

    public static Object[] getParamsAndTypes(ArrayList paramsList, ArrayList typesList) {
        int i;
        String[] types = null;
        Object[] params = null;
        if (paramsList == null) {
            return new Object[]{null, null};
        }
        if (typesList == null) {
            types = new String[paramsList.size()];
            for (int i2 = 0; i2 < types.length; ++i2) {
                types[i2] = "java.lang.String";
            }
            if (paramsList != null) {
                params = paramsList.toArray();
            }
            return new Object[]{params, types};
        }
        for (i = 0; i < typesList.size(); ++i) {
            Object type = typesList.get(i);
            Object param = paramsList.get(i);
            if (!(type instanceof ArrayList)) continue;
            ArrayList typeArrayList = (ArrayList)type;
            String[] typesArray = typeArrayList.toArray(new String[typeArrayList.size()]);
            typesList.remove(i);
            for (int j = 0; j < typesArray.length; ++j) {
                typesList.add(i + j, typesArray[j]);
            }
            if (param == null) continue;
            ArrayList paramArrayList = (ArrayList)param;
            Object[] paramsArray = paramArrayList.toArray();
            paramsList.remove(i);
            for (int j = 0; j < paramsArray.length; ++j) {
                paramsList.add(i + j, paramsArray[j]);
            }
        }
        types = typesList.toArray(new String[typesList.size()]);
        params = paramsList.toArray();
        for (i = 0; i < types.length; ++i) {
            if (types[i].equals("boolean") || types[i].equals("java.lang.Boolean")) {
                params[i] = new Boolean(params[i].toString());
                continue;
            }
            if (!types[i].equals("java.lang.Integer")) continue;
            params[i] = new Integer(params[i].toString());
        }
        return new Object[]{params, types};
    }

    public static Object[] getParams(ArrayList params, String[] types) {
        if (params == null) {
            return null;
        }
        if (types == null) {
            return null;
        }
        return params.toArray();
    }

    public static void main(String[] _args) {
        ArrayList<String> typesList = new ArrayList<String>();
        ArrayList<Object> paramsList = new ArrayList<Object>();
        typesList.add("java.lang.String");
        paramsList.add(null);
        Object paramArray = null;
        Object typesArray = null;
        Object[] paramsAndTypes = MBeanUtil.getParamsAndTypes(paramsList, typesList);
        System.out.println(paramsAndTypes[0]);
    }
}

