/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient.jws.boot;

import com.sun.enterprise.appclient.jws.boot.ClassPathManager15;
import com.sun.enterprise.appclient.jws.boot.ClassPathManager16;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;

public abstract class ClassPathManager {
    private static ClassPathManager mgr = null;
    private ClassLoader jnlpClassLoader = null;

    public static ClassPathManager getClassPathManager() {
        if (mgr == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            mgr = loader instanceof URLClassLoader ? new ClassPathManager16(loader) : new ClassPathManager15(loader);
        }
        return mgr;
    }

    protected ClassPathManager(ClassLoader loader) {
        this.jnlpClassLoader = loader;
    }

    public URI locateClass(String className) throws IllegalAccessException, InvocationTargetException, MalformedURLException, URISyntaxException {
        String resourceName = this.classNameToResourceName(className);
        URL classURL = this.locateResource(resourceName);
        File f = this.findContainingJar(classURL);
        return f.toURI();
    }

    public abstract ClassLoader getParentClassLoader();

    public abstract File findContainingJar(URL var1) throws IllegalArgumentException, URISyntaxException, MalformedURLException, IllegalAccessException, InvocationTargetException;

    protected ClassLoader getJNLPClassLoader() {
        return this.jnlpClassLoader;
    }

    protected String classNameToResourceName(String className) {
        return className.replace(".", "/") + ".class";
    }

    protected URL locateResource(String resourceName) {
        URL resourceURL = this.getClass().getClassLoader().getResource(resourceName);
        return resourceURL;
    }

    public URL[] locateDownloadedJars() throws ClassNotFoundException, URISyntaxException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, MalformedURLException {
        String probeClassNames = System.getProperty("com.sun.aas.jar.probe.class.names", "com.sun.enterprise.appclient.jws.boot.JWSACCMain,com.sun.enterprise.appclient.Main,com.sun.jdo.api.persistence.enhancer.ByteCodeEnhancer,com.sun.enterprise.admin.servermgmt.DomainConfig,com.sun.enterprise.deployment.client.DeploymentClientUtils,javax.ejb.EJB,com.sun.appserv.management.ext.logging.LogAnalyzer,com.sun.mail.iap.Argument,com.sun.activation.viewers.ImageViewer,com.sun.codemodel.ClassType,org.apache.derby.client.ClientDataSourceFactory,persistence.antlr.ActionElement,org.netbeans.modules.dbschema.ColumnElement,com.sun.jms.spi.xa.JMSXAConnection,com.sun.jndi.fscontext.FSContext");
        String[] classNames = probeClassNames.split(",");
        URL[] urls = new URL[classNames.length];
        int nextURL = 0;
        for (String className : classNames) {
            URI jarFileURI = this.locateClass(className);
            URL url = jarFileURI.toURL();
            urls[nextURL++] = url;
        }
        return urls;
    }
}

