/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.jmx.remote.streams;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class JMXChunkedInputStream
extends InputStream {
    private InputStream in = null;
    private byte[] buffer = null;
    private int remainderInBuf = 0;
    private int remainderInChannel = 0;
    private int idx = 0;
    private boolean EOF = false;

    public JMXChunkedInputStream(InputStream in) {
        this.in = in;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int available() {
        return this.remainderInBuf;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int readLimit) {
    }

    public void reset() throws IOException {
        throw new IOException("markSupported = false");
    }

    private void readObject() throws IOException {
        try {
            DataInputStream dI = new DataInputStream(this.in);
            int len = 0;
            if (this.remainderInChannel > 0) {
                len = this.remainderInChannel;
            } else {
                this.remainderInChannel = len = dI.readInt();
                if (len <= 0) {
                    this.setEOF();
                    return;
                }
            }
            this.buffer = new byte[len];
            this.remainderInBuf = dI.read(this.buffer, 0, len);
            if (this.remainderInBuf == -1) {
                this.setEOF();
                return;
            }
            this.remainderInChannel -= this.remainderInBuf;
            this.idx = 0;
        }
        catch (IOException ioe) {
            if (ioe instanceof EOFException || ioe.getMessage().indexOf("EOF") != -1) {
                this.setEOF();
                return;
            }
            throw ioe;
        }
    }

    private void setEOF() {
        this.EOF = true;
        this.buffer = null;
        this.remainderInBuf = 0;
        this.idx = 0;
    }

    public int read() throws IOException {
        if (this.EOF) {
            return -1;
        }
        int ret = -1;
        if (this.remainderInBuf == 0) {
            this.readObject();
        }
        if (this.EOF) {
            return -1;
        }
        ret = this.buffer[this.idx++];
        --this.remainderInBuf;
        return ret;
    }

    public int read(byte[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException("byte array is null");
        }
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.EOF) {
            return -1;
        }
        if (b == null) {
            throw new NullPointerException("byte array is null");
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("offset=" + off + ", len=" + len + ", (off+len)=" + (off + len) + ", b.length=" + b.length + ", (off+len)>b.length=" + (off + len > b.length));
        }
        if (len == 0) {
            return 0;
        }
        if (this.remainderInBuf == 0) {
            this.readObject();
        }
        if (this.EOF) {
            return -1;
        }
        int len1 = len > this.remainderInBuf ? this.remainderInBuf : len;
        System.arraycopy(this.buffer, this.idx, b, off, len1);
        this.idx += len1;
        this.remainderInBuf -= len1;
        return len1;
    }

    public long skip(int n) throws IOException {
        if (this.EOF) {
            return 0L;
        }
        if (n <= 0) {
            return 0L;
        }
        if (this.remainderInBuf >= n) {
            this.idx += n;
            this.remainderInBuf -= n;
            return n;
        }
        int skipped = this.remainderInBuf;
        n -= skipped;
        this.remainderInBuf = 0;
        this.idx = 0;
        this.readObject();
        if (this.EOF) {
            return skipped;
        }
        this.idx += n;
        this.remainderInBuf -= n;
        return skipped += n;
    }
}

