/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.RepositoryManager;
import com.sun.enterprise.admin.servermgmt.SMFService;
import com.sun.enterprise.admin.servermgmt.SMFServiceHandler;
import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.util.SystemPropertyConstants;
import java.io.File;
import java.util.Date;

public class CreateServiceCommand
extends S1ASCommand {
    private static final String TYPE = "type";
    private static final String NAME = "name";
    private static final String SERVICE_PROPERTIES = "serviceproperties";
    private static final String VALID_TYPES = "das|node-agent";
    private static final String DAS_TYPE = "das";

    public boolean validateOptions() throws CommandValidationException {
        String passwordFile = this.getOption("passwordfile");
        if (!new File(passwordFile).exists()) {
            String msg = this.getLocalizedString("FileDoesNotExist", new Object[]{passwordFile});
            throw new CommandValidationException(msg);
        }
        String typedirOperand = (String)this.getOperands().get(0);
        File typeDir = new File(typedirOperand);
        String type = this.getOption(TYPE);
        if (!type.matches(VALID_TYPES)) {
            throw new CommandValidationException(this.getLocalizedString("InvalideServiceType"));
        }
        if (!(typeDir.exists() && typeDir.canWrite() && typeDir.isDirectory())) {
            String msg = this.getLocalizedString("InvalidDirectory", new Object[]{typeDir});
            throw new CommandValidationException(msg);
        }
        return true;
    }

    protected void validateType() throws CommandException {
        String typedirOperand = (String)this.getOperands().get(0);
        File typeDir = new File(typedirOperand);
        String type = this.getOption(TYPE);
        if (type.equals(DAS_TYPE)) {
            String domainName = typeDir.getName();
            String domainRoot = typeDir.getParent();
            try {
                DomainConfig dc = new DomainConfig(domainName, domainRoot);
                RepositoryManager rm = new RepositoryManager();
                rm.checkRepository((RepositoryConfig)dc, true);
            }
            catch (RepositoryException re) {
                throw new CommandException(re.getLocalizedMessage());
            }
        } else {
            this.validateNodeAgent(typeDir);
        }
    }

    protected void validateNodeAgent(File typeDir) throws CommandException {
        throw new CommandException(this.getLocalizedString("TypeNotSupported"));
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        this.validateType();
        String passwordFile = this.getOption("passwordfile");
        String type = this.getOption(TYPE);
        String typeDir = (String)this.getOperands().get(0);
        SMFServiceHandler sh = new SMFServiceHandler();
        SMFService service = new SMFService();
        service.setDate(new Date().toString());
        StringBuilder ap = new StringBuilder();
        service.setName(this.getName(typeDir, ap));
        service.setLocation(ap.toString());
        service.setType(type.equals(DAS_TYPE) ? SMFService.AppserverServiceType.Domain : SMFService.AppserverServiceType.NodeAgent);
        service.setFQSN();
        service.setOSUser();
        service.setAsadminPath(SystemPropertyConstants.getAsAdminScriptLocation());
        service.setPasswordFilePath(passwordFile);
        service.setServiceProperties(this.getOption(SERVICE_PROPERTIES));
        service.isConfigValid();
        sh.setTrace(CLILogger.isDebug());
        sh.createService(service.tokensAndValues());
        this.printSuccess(service);
        CLILogger.getInstance().printMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
    }

    private String getName(String typeDir, StringBuilder absolutePath) throws CommandException {
        String path = "";
        try {
            File f = new File(typeDir);
            String name = f.getName();
            absolutePath.append(f.getAbsolutePath());
            String nameFromOption = this.getOption(NAME);
            if (nameFromOption != null) {
                name = nameFromOption;
            }
            CLILogger.getInstance().printDebugMessage("service name = " + name);
            return name;
        }
        catch (Exception e) {
            throw new CommandException(e.getLocalizedMessage());
        }
    }

    private void printSuccess(SMFService smf) {
        Object[] params = new String[]{smf.getName(), smf.getType().toString(), smf.getLocation(), smf.getManifestFilePath()};
        String msg = this.getLocalizedString("SMFServiceCreated", params);
        CLILogger.getInstance().printMessage(msg);
    }
}

