/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.cli.commands.S1ASCommand;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.util.OS;
import java.io.File;

public abstract class DatabaseCommand
extends S1ASCommand {
    private static final String DB_HOST = "dbhost";
    private static final String DB_PORT = "dbport";
    protected String dbHost;
    protected String dbPort;
    protected String dbLocation;
    protected String sJavaHome;
    protected String sInstallRoot;
    protected String sClasspath;
    protected String sDatabaseClasspath;

    protected void prepareProcessExecutor() throws Exception {
        this.dbHost = this.getOption(DB_HOST);
        this.dbPort = this.getOption(DB_PORT);
        this.checkIfPortIsValid(this.dbPort);
        this.dbLocation = System.getProperty("com.sun.aas.derbyRoot");
        this.sJavaHome = System.getProperty("com.sun.aas.javaRoot");
        this.sInstallRoot = System.getProperty("com.sun.aas.installRoot");
        this.sClasspath = this.sInstallRoot + File.separator + "lib" + File.separator + "appserv-rt.jar" + File.pathSeparator + this.sInstallRoot + File.separator + "lib" + File.separator + "admin-cli.jar";
        this.sDatabaseClasspath = this.dbLocation + File.separator + "lib" + File.separator + "derby.jar" + File.pathSeparator + this.dbLocation + File.separator + "lib" + File.separator + "derbytools.jar" + File.pathSeparator + this.dbLocation + File.separator + "lib" + File.separator + "derbynet.jar" + File.pathSeparator + this.dbLocation + File.separator + "lib" + File.separator + "derbyclient.jar";
    }

    private void checkIfPortIsValid(String port) throws CommandValidationException {
        try {
            Integer.parseInt(port);
        }
        catch (Exception e) {
            throw new CommandValidationException(this.getLocalizedString("InvalidPortNumber", new Object[]{port}));
        }
    }

    protected String[] pingDatabaseCmd(boolean bRedirect) throws Exception {
        if (OS.isDarwin()) {
            return new String[]{this.sJavaHome + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-Dderby.storage.fileSyncTransactionLog=True", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.cli.commands.DerbyControl", "ping", this.dbHost, this.dbPort, new Boolean(bRedirect).toString()};
        }
        return new String[]{this.sJavaHome + File.separator + "bin" + File.separator + "java", "-Djava.library.path=" + this.sInstallRoot + File.separator + "lib", "-cp", this.sClasspath + File.pathSeparator + this.sDatabaseClasspath, "com.sun.enterprise.cli.commands.DerbyControl", "ping", this.dbHost, this.dbPort, new Boolean(bRedirect).toString()};
    }
}

