/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.commands;

import com.sun.enterprise.admin.common.JMXFileTransfer;
import com.sun.enterprise.cli.commands.BaseLifeCycleCommand;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.InputsAndOutputs;
import com.sun.enterprise.diagnostics.DiagnosticAgent;
import com.sun.enterprise.diagnostics.DiagnosticException;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateReportCommand
extends BaseLifeCycleCommand {
    private static final String LOG_START_DATE_OPTION = "logstartdate";
    private static final String LOG_END_DATE_OPTION = "logenddate";
    private static final String LOCAL_OPTION = "local";
    private static final String OUTPUT_FILE_OPTION = "outputfile";
    private static final String FILE_OPTION = "file";
    private static final String BUGIDS_OPTION = "bugids";
    private static final String TARGET_DIR_OPTION = "targetdir";
    private static final String TARGET = "target";
    private final String CONF_ATTR_MSG = this.getLocalizedString("ConfidentialAttrMsg");
    private final String INSTRUCTIONS = this.getLocalizedString("ConfidentialAttrInstructions");
    private final String PROMPT_STRING = this.getLocalizedString("PromptToContinue");
    private static final String YES_STRING = "y";
    private static final String NO_STRING = "n";
    private String sOutputFile;

    @Override
    public boolean validateOptions() throws CommandValidationException {
        if (!super.validateOptions()) {
            return false;
        }
        if (this.getBooleanOption(LOCAL_OPTION) && this.getOption(TARGET_DIR_OPTION) == null) {
            throw new CommandValidationException(this.getLocalizedString("OptionRequiredInLocalMode", new Object[]{TARGET_DIR_OPTION}));
        }
        if (this.getOption(LOG_END_DATE_OPTION) != null && this.getOption(LOG_START_DATE_OPTION) == null) {
            throw new CommandValidationException(this.getLocalizedString("OptionRequiredWithOption", new Object[]{LOG_START_DATE_OPTION, LOG_END_DATE_OPTION}));
        }
        this.sOutputFile = this.getOption(OUTPUT_FILE_OPTION);
        return true;
    }

    @Override
    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        try {
            if (!(this.isDateValid(this.getOption(LOG_START_DATE_OPTION)) && this.isDateValid(this.getOption(LOG_END_DATE_OPTION)) && this.compareDates(this.getOption(LOG_START_DATE_OPTION), this.getOption(LOG_END_DATE_OPTION)) && this.isFileValid(this.getOption(FILE_OPTION)) && this.isOutputFileValid(this.sOutputFile) && this.isDirectoryValid(this.getOption(TARGET_DIR_OPTION)))) {
                return;
            }
            if (this.getBooleanOption(LOCAL_OPTION)) {
                this.executeCommandLocalMode();
            } else {
                this.executeCommandRemoteMode();
            }
            CLILogger.getInstance().printDetailMessage(this.getLocalizedString("CommandSuccessful", new Object[]{this.name}));
        }
        catch (Exception e) {
            if (e.getLocalizedMessage() != null) {
                this.displayExceptionMessage(e);
            }
            throw new CommandException(this.getLocalizedString("CommandUnSuccessful", new Object[]{this.name}), e);
        }
    }

    private void executeCommandRemoteMode() throws Exception {
        String objectName = this.getObjectName();
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getHost(), this.getPort(), this.getUser(), this.getPassword());
        List confidentialAttrs = (List)mbsc.getAttribute(new ObjectName(objectName), "ConfidentialProperties");
        this.printAttributes(confidentialAttrs);
        String input = this.printPromptToContinue();
        if (!input.equalsIgnoreCase(YES_STRING)) {
            CLILogger.getInstance().printDebugMessage("exiting");
            return;
        }
        CLILogger.getInstance().printDebugMessage("continue");
        String operationName = this.getOperationName();
        Object[] params = new Object[]{this.createCLIOptionsMap()};
        String[] types = this.getTypesInfo();
        String sServerLocation = (String)mbsc.invoke(new ObjectName(objectName), operationName, params, types);
        this.getDiagnosticReport(mbsc, sServerLocation, new File(this.sOutputFile).getParent(), new File(this.sOutputFile).getName());
    }

    private void getDiagnosticReport(MBeanServerConnection mbsc, String sFileDownload, String sDownloadPath, String sFileName) throws CommandException {
        try {
            String fileName = new JMXFileTransfer(mbsc).downloadFile(sFileDownload, sDownloadPath, sFileName);
            CLILogger.getInstance().printDebugMessage("downloaded from  : " + sFileDownload + " to : " + sDownloadPath);
        }
        catch (Exception e) {
            Throwable t;
            for (t = e.getCause(); t != null && t.getCause() != null; t = t.getCause()) {
            }
            if (t == null) {
                t = e;
            }
            throw new CommandException(t.getLocalizedMessage(), t);
        }
    }

    private void checkDiagnosticFile(String sDownloadPath) throws Exception {
        File dlDir = new File(sDownloadPath);
        if (!dlDir.exists()) {
            dlDir.mkdirs();
        }
        if (!(dlDir.exists() && dlDir.canWrite() && dlDir.isDirectory())) {
            throw new CommandValidationException(this.getLocalizedString("InvalidDirectory", new Object[]{sDownloadPath}));
        }
    }

    private void executeCommandLocalMode() throws CommandException {
        DiagnosticAgent agent = this.getFeatureFactory().getDiagnosticAgent();
        List<String> confidentialAttrs = this.getConfidentialAttributes(this.getOption(TARGET_DIR_OPTION), (String)this.operands.firstElement(), agent);
        this.printAttributes(confidentialAttrs);
        String input = this.printPromptToContinue();
        if (!input.equalsIgnoreCase(YES_STRING)) {
            CLILogger.getInstance().printDebugMessage("exiting");
            return;
        }
        CLILogger.getInstance().printDebugMessage("continue");
        String reportFile = this.generateReport(this.createCLIOptionsMap(), agent);
        CLILogger.getInstance().printMessage(this.getLocalizedString("ReportFile", new Object[]{reportFile}));
    }

    private boolean isDateValid(String dateStr) throws CommandException {
        if (dateStr == null) {
            return true;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
            Date date = df.parse(dateStr);
            return true;
        }
        catch (ParseException pe) {
            throw new CommandException(this.getLocalizedString("InvalidDate", new Object[]{dateStr}));
        }
    }

    private boolean compareDates(String startDateStr, String endDateStr) throws CommandException {
        if (startDateStr == null || endDateStr == null) {
            return true;
        }
        try {
            SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
            Date startDate = df.parse(startDateStr);
            Date endDate = df.parse(endDateStr);
            if (startDate.compareTo(endDate) > 0) {
                throw new CommandException(this.getLocalizedString("InvalidDateBeforeDate"));
            }
        }
        catch (ParseException pe) {
            throw new CommandException(this.getLocalizedString("InvalidDateError"));
        }
        return true;
    }

    private boolean isFileValid(String fileStr) throws CommandException {
        if (fileStr == null) {
            return true;
        }
        File file = this.checkForFileExistence(null, fileStr);
        if (file == null) {
            throw new CommandException(this.getLocalizedString("FileDoesNotExist", new Object[]{fileStr}));
        }
        return true;
    }

    private boolean isDirectoryValid(String directory) throws CommandException {
        if (directory == null) {
            return true;
        }
        File file = new File(directory);
        if (!file.isDirectory() || !file.canRead()) {
            throw new CommandException(this.getLocalizedString("InvalidDirectory", new Object[]{directory}));
        }
        return true;
    }

    private boolean isOutputFileValid(String sFile) throws Exception {
        if (sFile == null) {
            return false;
        }
        File file = new File(sFile);
        String sFileName = file.getName();
        if (file.getParent() != null) {
            this.checkDiagnosticFile(file.getParent());
        }
        if (!sFileName.endsWith(".jar")) {
            throw new CommandException(this.getLocalizedString("InvalidOutputFile"));
        }
        return true;
    }

    private String generateReport(Map clioptions, DiagnosticAgent agent) throws CommandException {
        try {
            return agent.generateReport(clioptions);
        }
        catch (DiagnosticException de) {
            de.printStackTrace();
            throw new CommandException(de.getMessage());
        }
    }

    private List<String> getConfidentialAttributes(String targetDir, String targetName, DiagnosticAgent agent) throws CommandException {
        try {
            return agent.getConfidentialProperties(targetDir + File.separator + targetName);
        }
        catch (DiagnosticException e) {
            throw new CommandException(e.getMessage());
        }
    }

    private Map createCLIOptionsMap() {
        HashMap<String, Object> cliOptions = new HashMap<String, Object>();
        String target = (String)this.operands.firstElement();
        CLILogger.getInstance().printDebugMessage(" Target : " + target);
        cliOptions.put(LOCAL_OPTION, this.getOption(LOCAL_OPTION));
        cliOptions.put(TARGET, target);
        if (this.getOption(LOG_START_DATE_OPTION) != null) {
            cliOptions.put(LOG_START_DATE_OPTION, new Date(this.getOption(LOG_START_DATE_OPTION)));
        }
        if (this.getOption(LOG_END_DATE_OPTION) != null) {
            cliOptions.put(LOG_END_DATE_OPTION, new Date(this.getOption(LOG_END_DATE_OPTION)));
        }
        if (this.getOption(FILE_OPTION) != null) {
            cliOptions.put(FILE_OPTION, this.getOption(FILE_OPTION));
        }
        if (this.sOutputFile != null && this.getBooleanOption(LOCAL_OPTION)) {
            cliOptions.put(OUTPUT_FILE_OPTION, this.sOutputFile);
        }
        cliOptions.put(TARGET_DIR_OPTION, this.getOption(TARGET_DIR_OPTION));
        if (this.getOption(BUGIDS_OPTION) != null) {
            cliOptions.put(BUGIDS_OPTION, this.getOption(BUGIDS_OPTION));
        }
        return cliOptions;
    }

    private void printAttributes(List<String> attrs) {
        if (attrs != null) {
            CLILogger.getInstance().printMessage(this.CONF_ATTR_MSG);
            Iterator<String> iterator = attrs.iterator();
            while (iterator.hasNext()) {
                CLILogger.getInstance().printMessage(iterator.next());
            }
        }
    }

    private String printPromptToContinue() throws CommandException {
        try {
            String line = null;
            while (!this.isValidInput(line)) {
                CLILogger.getInstance().printMessage(this.INSTRUCTIONS);
                InputsAndOutputs.getInstance().getUserOutput().print(this.PROMPT_STRING);
                line = InputsAndOutputs.getInstance().getUserInput().getLine().trim();
            }
            return line;
        }
        catch (IOException ioe) {
            throw new CommandException(this.getLocalizedString("CouldNotPrintOrRead"), ioe);
        }
    }

    private boolean isValidInput(String line) {
        if (line == null) {
            return false;
        }
        return line != null && !line.trim().equals("") && line.length() >= 1 && (line.equalsIgnoreCase(YES_STRING) || line.equalsIgnoreCase(NO_STRING));
    }
}

