/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.codegen;

import com.sun.corba.ee.spi.orbutil.generic.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Identifier {
    private Identifier() {
    }

    public static boolean isValidIdentifier(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        for (int ctr = 1; ctr < name.length(); ++ctr) {
            if (Character.isJavaIdentifierPart(name.charAt(ctr))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidFullIdentifier(String name) {
        String[] arr;
        if (name == null || name.length() == 0) {
            return false;
        }
        if (name.charAt(name.length() - 1) == '.') {
            return false;
        }
        for (String str : arr = name.split("\\.")) {
            if (Identifier.isValidIdentifier(str)) continue;
            return false;
        }
        return true;
    }

    public static String makeFQN(String pkg, String ident) {
        if (pkg != null && !pkg.equals("")) {
            return pkg + '.' + ident;
        }
        return ident;
    }

    public static Pair<String, String> splitFQN(String fqn) {
        int count = fqn.lastIndexOf(46);
        String pkg = count < 0 ? "" : fqn.substring(0, count);
        String cls = fqn.substring(count + 1);
        return new Pair<String, String>(pkg, cls);
    }
}

