/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.orbutil.newtimer;

import com.sun.corba.ee.spi.orbutil.newtimer.Controllable;
import com.sun.corba.ee.spi.orbutil.newtimer.NamedBase;
import com.sun.corba.ee.spi.orbutil.newtimer.Statistics;
import com.sun.corba.ee.spi.orbutil.newtimer.StatisticsAccumulator;
import com.sun.corba.ee.spi.orbutil.newtimer.StatsEventHandler;
import com.sun.corba.ee.spi.orbutil.newtimer.Timer;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerEvent;
import com.sun.corba.ee.spi.orbutil.newtimer.TimerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsEventHandlerImpl
extends NamedBase
implements StatsEventHandler {
    static final String UNITS = "nanoseconds";
    private int size;
    private ArrayList<StatisticsAccumulator> saList;
    private Object saListLock;
    private ThreadLocal<ArrayList<Stack<TimerEvent>>> tlsteList;
    private Map<Thread, ArrayList<Stack<TimerEvent>>> allTlMap;
    private Object allTlMapLock;

    StatsEventHandlerImpl(TimerFactory factory, String name) {
        super(factory, name);
        this.size = factory.numberOfIds();
        this.saList = new ArrayList(this.size);
        this.saListLock = new Object();
        this.tlsteList = new ThreadLocal<ArrayList<Stack<TimerEvent>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ArrayList<Stack<TimerEvent>> initialValue() {
                ArrayList<Stack<TimerEvent>> result = new ArrayList<Stack<TimerEvent>>(StatsEventHandlerImpl.this.size);
                Object object = StatsEventHandlerImpl.this.allTlMapLock;
                synchronized (object) {
                    StatsEventHandlerImpl.this.allTlMap.put(Thread.currentThread(), result);
                }
                return result;
            }
        };
        this.allTlMap = new WeakHashMap<Thread, ArrayList<Stack<TimerEvent>>>();
        this.allTlMapLock = new Object();
    }

    private void ensureCapacity(int id) {
        int size;
        this.saList.ensureCapacity(id + 1);
        this.tlsteList.get().ensureCapacity(id + 1);
        for (int ctr = size = this.saList.size(); ctr <= id; ++ctr) {
            this.saList.add(new StatisticsAccumulator(UNITS));
            this.tlsteList.get().add(new Stack());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stack<TimerEvent> getSteElement(int id) {
        Object object = this.saListLock;
        synchronized (object) {
            this.ensureCapacity(id);
            return this.tlsteList.get().get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatisticsAccumulator getAccElement(int id) {
        Object object = this.saListLock;
        synchronized (object) {
            this.ensureCapacity(id);
            return this.saList.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.saListLock;
        synchronized (object) {
            for (StatisticsAccumulator statisticsAccumulator : this.saList) {
                statisticsAccumulator.clearState();
            }
        }
        object = this.allTlMapLock;
        synchronized (object) {
            for (ArrayList arrayList : this.allTlMap.values()) {
                for (int ctr = 0; ctr < arrayList.size(); ++ctr) {
                    arrayList.set(ctr, null);
                }
                arrayList.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(TimerEvent event) {
        Timer timer = event.timer();
        int id = timer.id();
        Stack<TimerEvent> ste = this.getSteElement(id);
        if (event.type() == TimerEvent.TimerEventType.ENTER) {
            ste.push(event);
        } else if (!ste.empty()) {
            TimerEvent enter = ste.pop();
            long duration = event.time() - enter.time();
            Object object = this.saListLock;
            synchronized (object) {
                StatisticsAccumulator acc = this.getAccElement(id);
                acc.sample(duration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Timer, Statistics> stats() {
        Object object = this.saListLock;
        synchronized (object) {
            HashMap<Timer, Statistics> result = new HashMap<Timer, Statistics>();
            for (int ctr = 0; ctr < this.saList.size(); ++ctr) {
                Controllable con = this.factory().getControllable(ctr);
                if (!(con instanceof Timer)) continue;
                Timer timer = (Timer)Timer.class.cast(con);
                StatisticsAccumulator sa = this.saList.get(ctr);
                result.put(timer, sa.getStats());
            }
            return result;
        }
    }
}

