/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.dottedname;

import com.sun.enterprise.admin.dottedname.DottedNameLogger;
import com.sun.enterprise.admin.dottedname.DottedNameServerInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

public class DottedNameServerInfoCache
implements DottedNameServerInfo {
    final DottedNameServerInfo mSrc;
    Set mConfigNames;
    Set mServerNames;
    HashMap mServerToConfig;
    HashMap mConfigToServers;

    public DottedNameServerInfoCache(DottedNameServerInfo src) {
        this.mSrc = src;
        this.mConfigNames = Collections.EMPTY_SET;
        this.mServerNames = Collections.EMPTY_SET;
        this.mServerToConfig = this.mConfigToServers = new HashMap();
    }

    public synchronized Set getConfigNames() throws DottedNameServerInfo.UnavailableException {
        return this.mConfigNames;
    }

    public synchronized Set getServerNames() throws DottedNameServerInfo.UnavailableException {
        return this.mServerNames;
    }

    public synchronized String getConfigNameForServer(String serverName) throws DottedNameServerInfo.UnavailableException {
        return (String)this.mServerToConfig.get(serverName);
    }

    public synchronized String[] getServerNamesForConfig(String configName) throws DottedNameServerInfo.UnavailableException {
        return (String[])this.mConfigToServers.get(configName);
    }

    void _refresh() throws DottedNameServerInfo.UnavailableException {
        this.mConfigNames = this.mSrc.getConfigNames();
        this.mServerNames = this.mSrc.getServerNames();
        for (String serverName : this.mServerNames) {
            String configName = this.mSrc.getConfigNameForServer(serverName);
            if (configName == null) continue;
            this.mServerToConfig.put(serverName, configName);
        }
        for (String configName : this.mConfigNames) {
            String[] serverNames = this.mSrc.getServerNamesForConfig(configName);
            if (serverNames == null) continue;
            this.mConfigToServers.put(configName, serverNames);
        }
    }

    public synchronized void refresh() {
        try {
            this._refresh();
        }
        catch (DottedNameServerInfo.UnavailableException e) {
            DottedNameLogger.logException(e);
        }
    }
}

