/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.event;

import com.sun.enterprise.admin.event.AdminEvent;
import com.sun.enterprise.admin.event.AdminEventListener;
import com.sun.enterprise.admin.event.AdminEventMulticaster;
import com.sun.enterprise.admin.event.AdminEventResult;
import com.sun.enterprise.admin.event.ElementChangeEvent;
import java.lang.reflect.Method;
import java.util.List;

public class BaseAdminEventHandler {
    private AdminEvent _event;
    private static String ACTION_UPDATE_METHOD = "handleUpdate";
    private static String ACTION_DELETE_METHOD = "handleDelete";
    private static String ACTION_CREATE_METHOD = "handleCreate";
    private static String GENERIC_PROCESS_EVENT_METHOD = "processEvent";

    public BaseAdminEventHandler(AdminEvent event) {
        this._event = event;
    }

    public int processEvent() {
        List list = AdminEventMulticaster.getInstance().getListeners(this._event.getType());
        if (list != null && !list.isEmpty()) {
            for (AdminEventListener listener : list) {
                this.invokeAdminEventListener(listener, this._event);
            }
        }
        return list != null ? list.size() : 0;
    }

    private void invokeNotification(AdminEventListener ae, String methodName, AdminEvent e) throws Exception {
        this.invokeNotification(ae, methodName, e, e.getClass());
    }

    private void invokeNotification(AdminEventListener ae, String methodName, AdminEvent e, Class eventParamClass) throws Exception {
        Method meth = null;
        meth = ae.getClass().getMethod(methodName, eventParamClass);
        try {
            meth.invoke((Object)ae, e);
        }
        catch (Exception ex) {
            Throwable t = ex.getCause();
            if (t != null) {
                throw (Exception)t;
            }
            throw ex;
        }
    }

    private void invokeAdminEventListener(AdminEventListener listener, AdminEvent e) {
        AdminEventMulticaster aem = AdminEventMulticaster.getInstance();
        AdminEventResult result = AdminEventResult.getAdminEventResult(e);
        try {
            this.invokeNotification(listener, GENERIC_PROCESS_EVENT_METHOD, e);
            return;
        }
        catch (Throwable t) {
            if (!(t instanceof NoSuchMethodException)) {
                aem.handleListenerError(e, t, result);
            }
            try {
                this.invokeNotification(listener, GENERIC_PROCESS_EVENT_METHOD, e, AdminEvent.class);
                return;
            }
            catch (Throwable t2) {
                block11: {
                    if (!(t2 instanceof NoSuchMethodException)) {
                        aem.handleListenerError(e, t2, result);
                    }
                    try {
                        ElementChangeEvent event = (ElementChangeEvent)e;
                        int code = event.getActionType();
                        if (code == 1) {
                            this.invokeNotification(listener, ACTION_CREATE_METHOD, e);
                            break block11;
                        }
                        if (code == 3) {
                            this.invokeNotification(listener, ACTION_UPDATE_METHOD, e);
                            break block11;
                        }
                        if (code == 2) {
                            this.invokeNotification(listener, ACTION_DELETE_METHOD, e);
                            break block11;
                        }
                        throw new RuntimeException("not valid error code");
                    }
                    catch (Throwable t3) {
                        aem.handleListenerError(e, t3, result);
                    }
                }
                return;
            }
        }
    }
}

