/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.mbeans.custom.loading;

import com.sun.enterprise.admin.mbeans.custom.CMBStrings;
import com.sun.enterprise.admin.mbeans.custom.ObjectNameSelectionAlgorithm;
import com.sun.enterprise.admin.mbeans.custom.loading.MBeanAttributeSetter;
import com.sun.enterprise.admin.mbeans.custom.loading.MBeanClassLoader;
import com.sun.enterprise.admin.server.core.CustomMBeanRegistration;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.Mbean;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CustomMBeanRegistrationImpl
implements CustomMBeanRegistration {
    private final MBeanServer mbs;
    private ClassLoader cl;
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");

    public CustomMBeanRegistrationImpl(MBeanServer mbs) throws IllegalArgumentException {
        this.mbs = mbs;
        this.cl = new MBeanClassLoader();
    }

    @Override
    public void registerMBeans(List<Mbean> mbeans, boolean continueReg) throws RuntimeException {
        if (mbeans == null) {
            throw new IllegalArgumentException(CMBStrings.get("InternalError", "registerMBeans() received a null mbeans argument"));
        }
        for (Mbean mbean : mbeans) {
            try {
                this.registerMBean(mbean);
            }
            catch (Throwable t) {
                if (continueReg) {
                    logger.info(CMBStrings.get("cmb.registerError", mbean.getName()));
                    continue;
                }
                throw new RuntimeException(t);
            }
        }
    }

    @Override
    public void registerMBeans(List<Mbean> mbeans) throws RuntimeException {
        this.registerMBeans(mbeans, true);
    }

    @Override
    public void setClassLoader(ClassLoader cl) throws IllegalArgumentException {
        if (cl == null) {
            throw new IllegalArgumentException(CMBStrings.get("InternalError", "setClassLoader() received a null argument"));
        }
        this.cl = cl;
    }

    @Override
    public ObjectName registerMBean(Mbean mbean) throws RuntimeException {
        if (mbean == null) {
            throw new IllegalArgumentException(CMBStrings.get("InternalError", "registerMBean() received a null argument"));
        }
        ObjectName ron = null;
        try {
            logger.fine(CMBStrings.get("cmb.loadingMBean1", mbean.getName()));
            ObjectName mon = CustomMBeanRegistrationImpl.getCascadingAwareObjectName(mbean);
            logger.fine(CMBStrings.get("cmb.loadingMBean2", mon.toString()));
            Class mc = this.loadIt(mbean.getImplClassName());
            Object mo = this.newIt(mc);
            ron = this.registerIt(mo, mon);
            if (!ObjectNameSelectionAlgorithm.implementsMBeanRegistrationInterface(mbean.getImplClassName()) && !mon.equals(ron)) {
                throw new RuntimeException(CMBStrings.get("objNameMismatch", mon, ron));
            }
            this.initIt(mbean, ron);
            if (!mbean.isEnabled()) {
                this.unregisterIt(mbean, ron);
            }
            return ron;
        }
        catch (ClassNotFoundException cnfe) {
            logger.info(CMBStrings.get("cmb.loadingMBean3", mbean.getImplClassName(), this.cl.getClass().getName()));
            throw new RuntimeException(cnfe);
        }
        catch (NoClassDefFoundError ncdfe) {
            logger.info(CMBStrings.get("cmb.loadingMBean4", mbean.getImplClassName(), this.cl.getClass().getName()));
            throw new RuntimeException(ncdfe);
        }
        catch (InstantiationException ie) {
            logger.info(CMBStrings.get("cmb.loadingMBean5", mbean.getImplClassName()));
            throw new RuntimeException(ie);
        }
        catch (IllegalAccessException iae) {
            logger.info(CMBStrings.get("cmb.loadingMBean6", mbean.getImplClassName()));
            throw new RuntimeException(iae);
        }
        catch (ExceptionInInitializerError eie) {
            logger.info(CMBStrings.get("cmb.loadingMBean7", mbean.getImplClassName()));
            throw new RuntimeException(eie);
        }
        catch (Throwable e) {
            if (ron != null) {
                this.unregisterIt(mbean, ron);
            }
            throw new RuntimeException(e);
        }
    }

    public static ObjectName getCascadingAwareObjectName(Mbean mbean) throws RuntimeException {
        try {
            ObjectName configON = new ObjectName(mbean.getObjectName());
            return CustomMBeanRegistrationImpl.getCascadingAwareObjectName(configON);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectName getCascadingAwareObjectName(ObjectName configON) throws RuntimeException {
        try {
            String serverNameKey = "server";
            String serverNameVal = System.getProperty("com.sun.aas.instanceName");
            Hashtable<String, String> properties = configON.getKeyPropertyList();
            properties.put("server", serverNameVal);
            ObjectName ron = new ObjectName(configON.getDomain(), properties);
            return ron;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ObjectName getCascadingUnawareObjectName(ObjectName cascadeON) throws RuntimeException {
        try {
            if (cascadeON == null) {
                throw new IllegalArgumentException(CMBStrings.get("InternalError", "getCascadingUnawareObjectName() received a null argument"));
            }
            ObjectName ron = cascadeON;
            String serverNameKey = "server";
            Hashtable<String, String> properties = cascadeON.getKeyPropertyList();
            if (properties.containsKey("server")) {
                Hashtable<String, String> np = new Hashtable<String, String>(properties);
                np.remove("server");
                ron = new ObjectName(cascadeON.getDomain(), np);
            }
            return ron;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Class loadIt(String classname) throws ClassNotFoundException, NoClassDefFoundError {
        Class<?> c = this.cl.loadClass(classname);
        logger.fine(CMBStrings.get("cmb.loadingMBean8", c.getName(), this.cl.getClass().getName(), c.getClassLoader().getClass().getName()));
        return c;
    }

    private Object newIt(Class c) throws IllegalAccessException, InstantiationException, ExceptionInInitializerError {
        return c.newInstance();
    }

    private ObjectName registerIt(Object mo, ObjectName on) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, RuntimeOperationsException {
        if (mo == null) {
            throw new RuntimeException(CMBStrings.get("objNameNull"));
        }
        ObjectInstance oi = this.mbs.registerMBean(mo, on);
        return oi.getObjectName();
    }

    private void initIt(Mbean mbc, ObjectName on) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        ElementProperty[] ats;
        MBeanAttributeSetter mas = new MBeanAttributeSetter(this.mbs, on);
        for (ElementProperty p : ats = mbc.getElementProperty()) {
            mas.setIt(p.getName(), p.getValue());
            logger.fine(CMBStrings.get("cmb.initMBean", p.getName(), mbc.getName()));
        }
    }

    private void unregisterIt(Mbean m, ObjectName ron) {
        try {
            if (this.mbs.isRegistered(ron)) {
                this.mbs.unregisterMBean(ron);
            }
        }
        catch (Throwable e) {
            logger.warning(CMBStrings.get("cmb.unloadMBeanError", m.getName()));
        }
    }
}

