/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.meta.naming;

import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import javax.management.MalformedObjectNameException;

public class NameParser {
    private String mString = null;
    private Vector mNameParts = new Vector();

    public void parseIt(String parseString) throws MalformedObjectNameException {
        this.mString = parseString;
        this.parseStringForNameParts();
        this.parseNameParts();
        if (!this.isWildcardCharValid()) {
            String msg = "admin.common.invalid_wild-card_char_placement";
            throw new MalformedObjectNameException(msg);
        }
    }

    public Iterator getParts() {
        return this.mNameParts.iterator();
    }

    private String removeEscapes(String str) {
        int idx;
        while ((idx = str.indexOf(92)) >= 0) {
            if (idx == 0) {
                str = str.substring(1);
                continue;
            }
            str = str.substring(0, idx) + str.substring(idx + 1);
        }
        return str;
    }

    private void parseStringForNameParts() throws MalformedObjectNameException {
        int counter;
        int begin = counter = 0;
        String nameString = null;
        while (counter < this.mString.length()) {
            char parseChar = this.mString.charAt(counter);
            if (this.isValidChar(parseChar)) {
                boolean gotDelimiter = this.isDelimiterChar(this.mString, counter);
                if (gotDelimiter) {
                    nameString = this.mString.substring(begin, counter);
                    begin = counter + 1;
                    this.mNameParts.addElement(this.removeEscapes(nameString));
                }
            } else {
                String msg = "invalidchar";
                throw new MalformedObjectNameException(msg);
            }
            ++counter;
        }
        nameString = this.mString.substring(begin);
        this.mNameParts.addElement(this.removeEscapes(nameString));
    }

    private void parseNameParts() throws MalformedObjectNameException {
        Iterator partsIter = this.getParts();
        boolean canReduce = false;
        while (partsIter.hasNext()) {
            String aNamePartString = (String)partsIter.next();
            canReduce = this.reduceNamePart(aNamePartString);
            if (canReduce) continue;
            String msg = "invalidname" + this.mString;
            throw new MalformedObjectNameException(msg);
        }
    }

    private boolean isWildcardCharValid() {
        boolean isWildcardCharValid = true;
        String starString = new String(new char[]{'*'});
        for (int i = 0; i < this.mNameParts.size(); ++i) {
            String aPart = (String)this.mNameParts.elementAt(i);
            if (aPart.indexOf(42) == -1 || aPart.equals(starString)) continue;
            isWildcardCharValid = false;
            break;
        }
        return isWildcardCharValid;
    }

    private boolean isValidChar(char aChar) {
        return Character.isLetter(aChar) || Character.isDigit(aChar) || this.isPermissibleChar(aChar) || this.isSpecialChar(aChar);
    }

    private boolean isPermissibleChar(char aChar) {
        boolean isPermissibleChar = false;
        if (aChar == '[' || aChar == ']' || aChar == '.' || aChar == '\\' || aChar == '*') {
            isPermissibleChar = true;
        }
        return isPermissibleChar;
    }

    private boolean isSpecialChar(char aChar) {
        return "-_/".indexOf(aChar) != -1;
    }

    private boolean isNonZeroDigit(char aChar) {
        return "123456789".indexOf(aChar) != -1;
    }

    private boolean reduceNamePart(String npString) {
        boolean canReduce = true;
        if (this.isSubscriptPresent(npString)) {
            canReduce = this.isSubscriptValid(npString);
        }
        if (canReduce) {
            String subscriptLessString = this.removeSubscript(npString);
            canReduce = this.isSubscriptLessStringValid(subscriptLessString);
        }
        return canReduce;
    }

    private boolean isDelimiterChar(String aString, int position) {
        boolean isDelim = false;
        if (aString.charAt(position) == '.' && (position == 0 || aString.charAt(position - 1) != '\\')) {
            isDelim = true;
        }
        return isDelim;
    }

    private boolean isValidIndexString(String index) {
        boolean isValidIndex = true;
        if (index != null && index.length() > 0) {
            try {
                int intValue = Integer.parseInt(index);
                if (intValue == 0 && index.length() != 1 || intValue > 0 && index.charAt(0) == '0' || intValue < 0) {
                    isValidIndex = false;
                }
            }
            catch (NumberFormatException e) {
                isValidIndex = false;
            }
        } else {
            isValidIndex = false;
        }
        return isValidIndex;
    }

    private boolean isSubscriptPresent(String npString) {
        boolean subscriptPresent = false;
        if (npString.indexOf(91) != -1 || npString.indexOf(93) != -1) {
            subscriptPresent = true;
        }
        return subscriptPresent;
    }

    private boolean isSubscriptValid(String npString) {
        boolean subscriptValid = true;
        boolean subscriptOrdered = this.isSubscriptOrdered(npString);
        if (subscriptOrdered) {
            boolean lastCharIsRightSquareBracket;
            int rightPos;
            int leftPos = npString.indexOf(91);
            String indexString = npString.substring(leftPos + 1, rightPos = npString.lastIndexOf(93));
            if (!this.isValidIndexString(indexString)) {
                subscriptValid = false;
            }
            boolean bl = lastCharIsRightSquareBracket = npString.charAt(npString.length() - 1) == ']';
            if (!lastCharIsRightSquareBracket) {
                subscriptValid = false;
            }
        } else {
            subscriptValid = false;
        }
        return subscriptValid;
    }

    private boolean isSubscriptOrdered(String npString) {
        boolean subscriptOrdered = true;
        Stack<Character> charStack = new Stack<Character>();
        if (this.isSubscriptPresent(npString)) {
            for (int index = 0; index < npString.length(); ++index) {
                char ch = npString.charAt(index);
                if (ch == '[') {
                    charStack.push(new Character(ch));
                    continue;
                }
                if (ch != ']') continue;
                if (!charStack.empty()) {
                    Character poppedChar = (Character)charStack.pop();
                    if (poppedChar.charValue() == '[') continue;
                    subscriptOrdered = false;
                    break;
                }
                subscriptOrdered = false;
                break;
            }
            if (!charStack.empty()) {
                subscriptOrdered = false;
            }
        } else {
            subscriptOrdered = false;
        }
        return subscriptOrdered;
    }

    private String removeSubscript(String npString) {
        String subscriptLessString = null;
        int leftIndex = npString.indexOf(91);
        if (npString != null || npString.length() > 0) {
            subscriptLessString = leftIndex != -1 ? npString.substring(0, leftIndex) : npString;
        }
        return subscriptLessString;
    }

    private boolean isSubscriptLessStringValid(String npString) {
        boolean remStringValid = false;
        if (npString != null && npString.length() > 0) {
            boolean noMoreStars;
            boolean onlyDelimiterEscaped = this.isOnlyDelimiterEscaped(npString);
            boolean containsEscape = npString.indexOf(92) != -1;
            boolean isEscapeValid = !containsEscape || containsEscape && onlyDelimiterEscaped;
            boolean bl = noMoreStars = npString.indexOf("**") == -1;
            if (isEscapeValid && noMoreStars) {
                remStringValid = true;
            }
        }
        return remStringValid;
    }

    private boolean isOnlyDelimiterEscaped(String npString) {
        boolean onlyDelimiterEscaped = true;
        if (npString != null && npString.length() > 0) {
            int strlength = npString.length();
            for (int index = 0; index < strlength; ++index) {
                int nextIndex;
                char ch = npString.charAt(index);
                if (ch != '\\' || (nextIndex = index + 1) < strlength && npString.charAt(nextIndex) == '.') continue;
                onlyDelimiterEscaped = false;
                break;
            }
        } else {
            onlyDelimiterEscaped = false;
        }
        return onlyDelimiterEscaped;
    }
}

