/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.selfmanagement.event;

import com.sun.appserv.management.event.StatisticMonitorNotification;
import com.sun.enterprise.admin.selfmanagement.event.GaugeStatisticMonitorMBean;
import com.sun.enterprise.admin.selfmanagement.event.StatisticMonitor;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaugeStatisticMonitor
extends StatisticMonitor
implements GaugeStatisticMonitorMBean {
    private Number highThreshold = INTEGER_ZERO;
    private Number lowThreshold = INTEGER_ZERO;
    private boolean notifyHigh = false;
    private boolean notifyLow = false;
    private boolean differenceMode = false;
    private Number[] previousScanGauge = new Number[16];
    private int[] status = new int[16];
    private StatisticMonitor.NumericalType[] type = new StatisticMonitor.NumericalType[16];
    private boolean[] derivedGaugeValid = new boolean[16];
    private static final String[] types = new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.error.threshold", "jmx.monitor.gauge.high", "jmx.monitor.gauge.low"};
    private static final MBeanNotificationInfo[] notifsInfo = new MBeanNotificationInfo[]{new MBeanNotificationInfo(types, "com.sun.appserv.management.event.StatisticMonitorNotification", "Notifications sent by the GaugeStatisticMonitor MBean")};
    private static final int RISING = 0;
    private static final int FALLING = 1;
    private static final int RISING_OR_FALLING = 2;
    protected static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.selfmanagement");

    @Override
    public synchronized void start() {
        for (int i = 0; i < this.elementCount; ++i) {
            this.status[i] = 2;
            this.previousScanGauge[i] = null;
        }
        this.doStart();
    }

    @Override
    public synchronized void stop() {
        this.doStop();
    }

    @Override
    public synchronized Number getDerivedGauge(ObjectName object) {
        return (Number)super.getDerivedGauge(object);
    }

    @Override
    public synchronized long getDerivedGaugeTimeStamp(ObjectName object) {
        return super.getDerivedGaugeTimeStamp(object);
    }

    @Override
    @Deprecated
    public synchronized Number getDerivedGauge() {
        return (Number)this.derivedGauge[0];
    }

    @Override
    @Deprecated
    public synchronized long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp[0];
    }

    @Override
    public synchronized Number getHighThreshold() {
        return this.highThreshold;
    }

    @Override
    public synchronized Number getLowThreshold() {
        return this.lowThreshold;
    }

    @Override
    public synchronized void setThresholds(Number highValue, Number lowValue) throws IllegalArgumentException {
        if (highValue == null || lowValue == null) {
            throw new IllegalArgumentException("Null threshold value");
        }
        if (highValue.getClass() != lowValue.getClass()) {
            throw new IllegalArgumentException("Different type threshold values");
        }
        if (this.isFirstStrictlyGreaterThanLast(lowValue, highValue, highValue.getClass().getName())) {
            throw new IllegalArgumentException("High threshold less than low threshold");
        }
        this.highThreshold = highValue;
        this.lowThreshold = lowValue;
        for (int i = 0; i < this.elementCount; ++i) {
            this.resetAlreadyNotified(i, 16);
            this.status[i] = 2;
        }
    }

    @Override
    public synchronized boolean getNotifyHigh() {
        return this.notifyHigh;
    }

    @Override
    public synchronized void setNotifyHigh(boolean value) {
        this.notifyHigh = value;
    }

    @Override
    public synchronized boolean getNotifyLow() {
        return this.notifyLow;
    }

    @Override
    public synchronized void setNotifyLow(boolean value) {
        this.notifyLow = value;
    }

    @Override
    public synchronized boolean getDifferenceMode() {
        return this.differenceMode;
    }

    @Override
    public synchronized void setDifferenceMode(boolean value) {
        this.differenceMode = value;
        for (int i = 0; i < this.elementCount; ++i) {
            this.status[i] = 2;
            this.previousScanGauge[i] = null;
        }
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return notifsInfo;
    }

    private synchronized boolean updateDerivedGauge(Object scanGauge, int index) {
        boolean is_derived_gauge_valid;
        if (this.differenceMode) {
            if (this.previousScanGauge[index] != null) {
                this.setDerivedGaugeWithDifference((Number)scanGauge, index);
                is_derived_gauge_valid = true;
            } else {
                is_derived_gauge_valid = false;
            }
            this.previousScanGauge[index] = (Number)scanGauge;
        } else {
            this.derivedGauge[index] = (Number)scanGauge;
            is_derived_gauge_valid = true;
        }
        return is_derived_gauge_valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatisticMonitorNotification updateNotifications(int index) {
        StatisticMonitorNotification n = null;
        GaugeStatisticMonitor gaugeStatisticMonitor = this;
        synchronized (gaugeStatisticMonitor) {
            if (this.status[index] == 2) {
                if (this.isFirstGreaterThanLast((Number)this.derivedGauge[index], this.highThreshold, this.type[index])) {
                    if (this.notifyHigh) {
                        n = new StatisticMonitorNotification("jmx.monitor.gauge.high", this, 0L, 0L, "", null, null, null, this.highThreshold);
                    }
                    this.status[index] = 1;
                } else if (this.isFirstGreaterThanLast(this.lowThreshold, (Number)this.derivedGauge[index], this.type[index])) {
                    if (this.notifyLow) {
                        n = new StatisticMonitorNotification("jmx.monitor.gauge.low", this, 0L, 0L, "", null, null, null, this.lowThreshold);
                    }
                    this.status[index] = 0;
                }
            } else if (this.status[index] == 0) {
                if (this.isFirstGreaterThanLast((Number)this.derivedGauge[index], this.highThreshold, this.type[index])) {
                    if (this.notifyHigh) {
                        n = new StatisticMonitorNotification("jmx.monitor.gauge.high", this, 0L, 0L, "", null, null, null, this.highThreshold);
                    }
                    this.status[index] = 1;
                }
            } else if (this.status[index] == 1 && this.isFirstGreaterThanLast(this.lowThreshold, (Number)this.derivedGauge[index], this.type[index])) {
                if (this.notifyLow) {
                    n = new StatisticMonitorNotification("jmx.monitor.gauge.low", this, 0L, 0L, "", null, null, null, this.lowThreshold);
                }
                this.status[index] = 0;
            }
        }
        return n;
    }

    private synchronized void setDerivedGaugeWithDifference(Number scanGauge, int index) {
        Number der;
        Number prev = this.previousScanGauge[index];
        switch (this.type[index]) {
            case INTEGER: {
                der = new Integer((Integer)scanGauge - (Integer)prev);
                break;
            }
            case BYTE: {
                der = new Byte((byte)((Byte)scanGauge - (Byte)prev));
                break;
            }
            case SHORT: {
                der = new Short((short)((Short)scanGauge - (Short)prev));
                break;
            }
            case LONG: {
                der = new Long((Long)scanGauge - (Long)prev);
                break;
            }
            case FLOAT: {
                der = new Float(((Float)scanGauge).floatValue() - ((Float)prev).floatValue());
                break;
            }
            case DOUBLE: {
                der = new Double((Double)scanGauge - (Double)prev);
                break;
            }
            default: {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "The threshold type is invalid");
                }
                return;
            }
        }
        this.derivedGauge[index] = der;
    }

    private boolean isFirstGreaterThanLast(Number greater, Number less, StatisticMonitor.NumericalType type) {
        switch (type) {
            case INTEGER: 
            case BYTE: 
            case SHORT: 
            case LONG: {
                return greater.longValue() >= less.longValue();
            }
            case FLOAT: 
            case DOUBLE: {
                return greater.doubleValue() >= less.doubleValue();
            }
        }
        if (_logger.isLoggable(Level.WARNING)) {
            _logger.log(Level.WARNING, "The threshold type is invalid");
        }
        return false;
    }

    private boolean isFirstStrictlyGreaterThanLast(Number greater, Number less, String className) {
        if (className.equals("java.lang.Integer") || className.equals("java.lang.Byte") || className.equals("java.lang.Short") || className.equals("java.lang.Long")) {
            return greater.longValue() > less.longValue();
        }
        if (className.equals("java.lang.Float") || className.equals("java.lang.Double")) {
            return greater.doubleValue() > less.doubleValue();
        }
        if (_logger.isLoggable(Level.WARNING)) {
            _logger.log(Level.WARNING, "The threshold type is invalid");
        }
        return false;
    }

    @Override
    boolean isComparableTypeValid(ObjectName object, String attribute, Comparable<?> value) {
        int index = this.indexOf(object);
        if (value instanceof Integer) {
            this.type[index] = StatisticMonitor.NumericalType.INTEGER;
        } else if (value instanceof Byte) {
            this.type[index] = StatisticMonitor.NumericalType.BYTE;
        } else if (value instanceof Short) {
            this.type[index] = StatisticMonitor.NumericalType.SHORT;
        } else if (value instanceof Long) {
            this.type[index] = StatisticMonitor.NumericalType.LONG;
        } else if (value instanceof Float) {
            this.type[index] = StatisticMonitor.NumericalType.FLOAT;
        } else if (value instanceof Double) {
            this.type[index] = StatisticMonitor.NumericalType.DOUBLE;
        } else {
            return false;
        }
        return true;
    }

    @Override
    Comparable<?> getDerivedGaugeFromComparable(ObjectName object, String attribute, Comparable<?> value) {
        int index = this.indexOf(object);
        this.derivedGaugeValid[index] = this.updateDerivedGauge(value, index);
        return (Comparable)this.derivedGauge[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void onErrorNotification(StatisticMonitorNotification notification) {
        int index = this.indexOf(notification.getObservedObject());
        GaugeStatisticMonitor gaugeStatisticMonitor = this;
        synchronized (gaugeStatisticMonitor) {
            this.status[index] = 2;
            this.previousScanGauge[index] = null;
        }
    }

    @Override
    StatisticMonitorNotification buildAlarmNotification(ObjectName object, String attribute, Comparable<?> value) {
        int index = this.indexOf(object);
        StatisticMonitorNotification alarm = null;
        if (this.derivedGaugeValid[index]) {
            alarm = this.updateNotifications(index);
        }
        return alarm;
    }

    @Override
    synchronized boolean isThresholdTypeValid(ObjectName object, String attribute, Comparable<?> value) {
        int index = this.indexOf(object);
        Class<? extends Number> c = GaugeStatisticMonitor.classForType(this.type[index]);
        return GaugeStatisticMonitor.isValidForType(this.highThreshold, c) && GaugeStatisticMonitor.isValidForType(this.lowThreshold, c);
    }

    @Override
    synchronized void insertSpecificElementAt(int index) {
        if (this.elementCount >= this.previousScanGauge.length) {
            this.previousScanGauge = this.expandArray(this.previousScanGauge);
            this.status = this.expandArray(this.status);
            this.type = this.expandArray(this.type);
            this.derivedGaugeValid = this.expandArray(this.derivedGaugeValid);
        }
        this.previousScanGauge[index] = null;
        this.status[index] = 2;
        this.type[index] = StatisticMonitor.NumericalType.INTEGER;
        this.derivedGaugeValid[index] = false;
    }

    @Override
    synchronized void removeSpecificElementAt(int index) {
        this.removeElementAt(this.previousScanGauge, index);
        this.removeElementAt(this.status, index);
        this.removeElementAt((Object[])this.type, index);
        this.removeElementAt(this.derivedGaugeValid, index);
    }
}

