/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.selfmanagement.event;

import com.sun.enterprise.admin.selfmanagement.event.CounterStatisticMonitor;
import com.sun.enterprise.admin.selfmanagement.event.Event;
import com.sun.enterprise.admin.selfmanagement.event.EventAbstractFactory;
import com.sun.enterprise.admin.selfmanagement.event.EventBuilder;
import com.sun.enterprise.admin.selfmanagement.event.GaugeStatisticMonitor;
import com.sun.enterprise.admin.selfmanagement.event.ManagementRulesMBeanHelper;
import com.sun.enterprise.admin.selfmanagement.event.MonitorEvent;
import com.sun.enterprise.admin.selfmanagement.event.StatisticMonitor;
import com.sun.enterprise.admin.selfmanagement.event.StringStatisticMonitor;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.server.ApplicationServer;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.monitor.CounterMonitor;
import javax.management.monitor.GaugeMonitor;
import javax.management.monitor.Monitor;
import javax.management.monitor.StringMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorEventFactory
extends EventAbstractFactory {
    private static MonitorEventFactory instance = new MonitorEventFactory();
    private Long seqno = 0L;
    private static String instanceName = ApplicationServer.getServerContext().getInstanceName();

    private MonitorEventFactory() {
        EventBuilder.getInstance().addEventFactory("monitor", this);
    }

    @Override
    public Event instrumentEvent(ElementProperty[] properties, String description) {
        NotificationBroadcasterSupport monitor;
        Float jdkVersion;
        if (properties == null) {
            throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "null properties", "monitor"));
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        for (int i = 0; i < properties.length; ++i) {
            table.put(properties[i].getName().toLowerCase(), properties[i].getValue());
        }
        boolean isMustang = false;
        boolean isComplexType = false;
        String monitorType = (String)table.get("monitortype");
        monitorType = monitorType == null ? "countermonitor" : monitorType.toLowerCase();
        String observedAttribute = (String)table.get("observedattribute");
        if (observedAttribute == null) {
            throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "observedattribute", "monitor"));
        }
        if (observedAttribute.indexOf(46) != -1) {
            isComplexType = true;
        }
        if ((jdkVersion = new Float(System.getProperty("java.specification.version"))) != null) {
            if ((double)jdkVersion.floatValue() >= 1.5) {
                isMustang = true;
            }
        } else {
            Float javaVersion = new Float(System.getProperty("java.version"));
            if ((double)javaVersion.floatValue() >= 1.5) {
                isMustang = true;
            }
        }
        if (isMustang && isComplexType) {
            monitor = null;
            if (monitorType.equals("countermonitor")) {
                monitor = this.createCounterStatisticMonitor(table);
            } else if (monitorType.equals("gaugemonitor")) {
                monitor = this.createGaugeStatisticMonitor(table);
            } else if (monitorType.equals("stringmonitor")) {
                monitor = this.createStringStatisticMonitor(table);
            }
            if (monitor == null) {
                _logger.log(Level.WARNING, "smgt.internal_error");
                return null;
            }
            try {
                String sourceMbeanObjName = null;
                String sourceMbeanName = null;
                if (table.containsKey("observedobject")) {
                    sourceMbeanObjName = table.get("observedobject");
                } else if (table.containsKey("observedmbean")) {
                    sourceMbeanName = table.get("observedmbean");
                }
                if (sourceMbeanName == null && sourceMbeanObjName == null) {
                    throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "observedobject", "monitor"));
                }
                String sourceMbean = null;
                if (sourceMbeanObjName != null) {
                    Pattern pat = Pattern.compile("\\$\\{instance.name\\}");
                    Matcher m = pat.matcher(sourceMbeanObjName);
                    sourceMbean = m.find() ? m.replaceAll(instanceName) : sourceMbeanObjName;
                } else if (sourceMbeanName != null) {
                    sourceMbean = ManagementRulesMBeanHelper.getObjName(sourceMbeanName);
                }
                ObjectName objName = new ObjectName(sourceMbean);
                ((StatisticMonitor)monitor).addObservedObject(objName);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "observedobject", "monitor"), ex);
            }
            ((StatisticMonitor)monitor).setObservedAttribute(observedAttribute);
            String granularityPeriod = table.get("granularityperiod");
            if (granularityPeriod != null) {
                try {
                    long gPeriod = Long.parseLong(granularityPeriod);
                    ((StatisticMonitor)monitor).setGranularityPeriod(gPeriod);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "granularityperiod", "monitor"), ex);
                }
            }
            ObjectName objName = null;
            try {
                table.put("version", this.getNewVersionString());
                Hashtable t = (Hashtable)table.clone();
                if (t.containsKey("observedmbean")) {
                    t.remove("observedmbean");
                } else if (t.containsKey("observedobject")) {
                    t.remove("observedobject");
                }
                objName = new ObjectName("com.sun.appserver.selfmanagement", t);
            }
            catch (Exception ex) {
                _logger.log(Level.WARNING, "smgt.internal_error", ex);
            }
            return new MonitorEvent((StatisticMonitor)monitor, objName, description);
        }
        monitor = null;
        if (monitorType.equals("countermonitor")) {
            monitor = this.createCounterMonitor(table);
        } else if (monitorType.equals("gaugemonitor")) {
            monitor = this.createGaugeMonitor(table);
        } else if (monitorType.equals("stringmonitor")) {
            monitor = this.createStringMonitor(table);
        }
        if (monitor == null) {
            _logger.log(Level.WARNING, "smgt.internal_error");
            return null;
        }
        try {
            String sourceMbeanObjName = null;
            String sourceMbeanName = null;
            if (table.containsKey("observedobject")) {
                sourceMbeanObjName = table.get("observedobject");
            } else if (table.containsKey("observedmbean")) {
                sourceMbeanName = table.get("observedmbean");
            }
            if (sourceMbeanName == null && sourceMbeanObjName == null) {
                throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "observedobject", "monitor"));
            }
            String sourceMbean = null;
            if (sourceMbeanObjName != null) {
                Pattern pat = Pattern.compile("\\$\\{instance.name\\}");
                Matcher m = pat.matcher(sourceMbeanObjName);
                sourceMbean = m.find() ? m.replaceAll(instanceName) : sourceMbeanObjName;
            } else if (sourceMbeanName != null) {
                sourceMbean = ManagementRulesMBeanHelper.getObjName(sourceMbeanName);
            }
            ObjectName objName = new ObjectName(sourceMbean);
            ((Monitor)monitor).addObservedObject(objName);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "observedobject", "monitor"), ex);
        }
        ((Monitor)monitor).setObservedAttribute(observedAttribute);
        String granularityPeriod = table.get("granularityperiod");
        if (granularityPeriod != null) {
            try {
                long gPeriod = Long.parseLong(granularityPeriod);
                ((Monitor)monitor).setGranularityPeriod(gPeriod);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "granularityperiod", "monitor"), ex);
            }
        }
        ObjectName objName = null;
        try {
            table.put("version", this.getNewVersionString());
            Hashtable t = (Hashtable)table.clone();
            if (t.containsKey("observedmbean")) {
                t.remove("observedmbean");
            } else if (t.containsKey("observedobject")) {
                t.remove("observedobject");
            }
            objName = new ObjectName("com.sun.appserver.selfmanagement", t);
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "smgt.internal_error", ex);
        }
        return new MonitorEvent((Monitor)monitor, objName, description);
    }

    private Monitor createCounterMonitor(Hashtable<String, String> table) {
        String numberType;
        CounterMonitor monitor = null;
        try {
            monitor = (CounterMonitor)this.getMBeanServer().instantiate("javax.management.monitor.CounterMonitor");
        }
        catch (Exception rex) {
            _logger.log(Level.WARNING, "smgt.internal_error", rex);
        }
        String strDiffMode = table.get("differencemode");
        if (strDiffMode != null) {
            try {
                boolean diffMode = Boolean.parseBoolean(strDiffMode);
                monitor.setDifferenceMode(diffMode);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "differencemode", "monitor"), ex);
            }
        }
        if ((numberType = table.get("numbertype")) == null) {
            numberType = "long";
        }
        String initTheshold = table.get("initthreshold");
        String strOffset = table.get("offset");
        String strModulus = table.get("modulus");
        Number threshold = null;
        Number offset = null;
        Number modulus = null;
        if (initTheshold == null) {
            throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "initthreshold", "monitor"));
        }
        try {
            if (numberType.equals("long")) {
                threshold = Long.parseLong(initTheshold);
                offset = strOffset != null ? Long.valueOf(Long.parseLong(strOffset)) : Long.valueOf(0L);
                modulus = strModulus != null ? Long.valueOf(Long.parseLong(strModulus)) : Long.valueOf(0L);
            } else if (numberType.equals("int")) {
                threshold = Integer.parseInt(initTheshold);
                offset = strOffset != null ? Integer.valueOf(Integer.parseInt(strOffset)) : Integer.valueOf(0);
                modulus = strModulus != null ? Integer.valueOf(Integer.parseInt(strModulus)) : Integer.valueOf(0);
            } else if (numberType.equals("short")) {
                threshold = Short.parseShort(initTheshold);
                offset = strOffset != null ? (Number)Short.parseShort(strOffset) : (Number)0;
                modulus = strModulus != null ? (Number)Short.parseShort(strModulus) : (Number)0;
            } else if (numberType.equals("byte")) {
                threshold = Byte.parseByte(initTheshold);
                offset = strOffset != null ? (Number)Byte.parseByte(strOffset) : (Number)0;
                modulus = strModulus != null ? (Number)Byte.parseByte(strModulus) : (Number)0;
            }
            monitor.setInitThreshold(threshold);
            if (offset != null) {
                monitor.setOffset(offset);
            }
            if (modulus != null) {
                monitor.setModulus(modulus);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "initthreshold", "monitor"), ex);
        }
        if (!monitor.getNotify()) {
            monitor.setNotify(true);
        }
        return monitor;
    }

    private StatisticMonitor createCounterStatisticMonitor(Hashtable<String, String> table) {
        String numberType;
        CounterStatisticMonitor monitor = null;
        try {
            monitor = (CounterStatisticMonitor)this.getMBeanServer().instantiate("com.sun.enterprise.admin.selfmanagement.event.CounterStatisticMonitor");
        }
        catch (Exception rex) {
            _logger.log(Level.WARNING, "smgt.internal_error", rex);
        }
        String strDiffMode = table.get("differencemode");
        if (strDiffMode != null) {
            try {
                boolean diffMode = Boolean.parseBoolean(strDiffMode);
                monitor.setDifferenceMode(diffMode);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "differencemode", "monitor"), ex);
            }
        }
        if ((numberType = table.get("numbertype")) == null) {
            numberType = "long";
        }
        String initTheshold = table.get("initthreshold");
        String strOffset = table.get("offset");
        String strModulus = table.get("modulus");
        Number threshold = null;
        Number offset = null;
        Number modulus = null;
        if (initTheshold == null) {
            throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "initthreshold", "monitor"));
        }
        try {
            if (numberType.equals("long")) {
                threshold = Long.parseLong(initTheshold);
                offset = strOffset != null ? Long.valueOf(Long.parseLong(strOffset)) : Long.valueOf(0L);
                modulus = strModulus != null ? Long.valueOf(Long.parseLong(strModulus)) : Long.valueOf(0L);
            } else if (numberType.equals("int")) {
                threshold = Integer.parseInt(initTheshold);
                offset = strOffset != null ? Integer.valueOf(Integer.parseInt(strOffset)) : Integer.valueOf(0);
                modulus = strModulus != null ? Integer.valueOf(Integer.parseInt(strModulus)) : Integer.valueOf(0);
            } else if (numberType.equals("short")) {
                threshold = Short.parseShort(initTheshold);
                offset = strOffset != null ? (Number)Short.parseShort(strOffset) : (Number)0;
                modulus = strModulus != null ? (Number)Short.parseShort(strModulus) : (Number)0;
            } else if (numberType.equals("byte")) {
                threshold = Byte.parseByte(initTheshold);
                offset = strOffset != null ? (Number)Byte.parseByte(strOffset) : (Number)0;
                modulus = strModulus != null ? (Number)Byte.parseByte(strModulus) : (Number)0;
            }
            monitor.setInitThreshold(threshold);
            if (offset != null) {
                monitor.setOffset(offset);
            }
            if (modulus != null) {
                monitor.setModulus(modulus);
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "initthreshold", "monitor"), ex);
        }
        if (!monitor.getNotify()) {
            monitor.setNotify(true);
        }
        return monitor;
    }

    private Monitor createGaugeMonitor(Hashtable<String, String> table) {
        String numberType;
        GaugeMonitor monitor = null;
        try {
            monitor = (GaugeMonitor)this.getMBeanServer().instantiate("javax.management.monitor.GaugeMonitor");
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "sgmt.internal_error", ex);
        }
        String strDiffMode = table.get("differencemode");
        if (strDiffMode != null) {
            try {
                boolean diffMode = Boolean.parseBoolean(strDiffMode);
                monitor.setDifferenceMode(diffMode);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "differencemode", "monitor"), ex);
            }
        }
        if ((numberType = table.get("numbertype")) == null) {
            numberType = "long";
        }
        String lowTheshold = table.get("lowthreshold");
        String highTheshold = table.get("highthreshold");
        if (lowTheshold == null || highTheshold == null) {
            throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "lowthreshold or highthreshold", "monitor"));
        }
        Number lThreshold = null;
        Number hThreshold = null;
        try {
            if (numberType.equals("long")) {
                lThreshold = Long.parseLong(lowTheshold);
                hThreshold = Long.parseLong(highTheshold);
            } else if (numberType.equals("int")) {
                lThreshold = Integer.parseInt(lowTheshold);
                hThreshold = Integer.parseInt(highTheshold);
            } else if (numberType.equals("short")) {
                lThreshold = Short.parseShort(lowTheshold);
                hThreshold = Short.parseShort(highTheshold);
            } else if (numberType.equals("double")) {
                lThreshold = Double.parseDouble(lowTheshold);
                hThreshold = Double.parseDouble(highTheshold);
            } else if (numberType.equals("float")) {
                lThreshold = Float.valueOf(Float.parseFloat(lowTheshold));
                hThreshold = Float.valueOf(Float.parseFloat(highTheshold));
            } else if (numberType.equals("byte")) {
                lThreshold = Byte.parseByte(lowTheshold);
                hThreshold = Byte.parseByte(highTheshold);
            }
            monitor.setThresholds(hThreshold, lThreshold);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "lowthreshold or highthreshold", "monitor"), ex);
        }
        if (!monitor.getNotifyHigh()) {
            monitor.setNotifyHigh(true);
        }
        if (!monitor.getNotifyLow()) {
            monitor.setNotifyLow(true);
        }
        return monitor;
    }

    private StatisticMonitor createGaugeStatisticMonitor(Hashtable<String, String> table) {
        String numberType;
        GaugeStatisticMonitor monitor = null;
        try {
            monitor = (GaugeStatisticMonitor)this.getMBeanServer().instantiate("com.sun.enterprise.admin.selfmanagement.event.GaugeStatisticMonitor");
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "sgmt.internal_error", ex);
        }
        String strDiffMode = table.get("differencemode");
        if (strDiffMode != null) {
            try {
                boolean diffMode = Boolean.parseBoolean(strDiffMode);
                monitor.setDifferenceMode(diffMode);
            }
            catch (Exception ex) {
                throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "differencemode", "monitor"), ex);
            }
        }
        if ((numberType = table.get("numbertype")) == null) {
            numberType = "long";
        }
        String lowTheshold = table.get("lowthreshold");
        String highTheshold = table.get("highthreshold");
        if (lowTheshold == null || highTheshold == null) {
            throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "lowthreshold or highthreshold", "monitor"));
        }
        Number lThreshold = null;
        Number hThreshold = null;
        try {
            if (numberType.equals("long")) {
                lThreshold = Long.parseLong(lowTheshold);
                hThreshold = Long.parseLong(highTheshold);
            } else if (numberType.equals("int")) {
                lThreshold = Integer.parseInt(lowTheshold);
                hThreshold = Integer.parseInt(highTheshold);
            } else if (numberType.equals("short")) {
                lThreshold = Short.parseShort(lowTheshold);
                hThreshold = Short.parseShort(highTheshold);
            } else if (numberType.equals("double")) {
                lThreshold = Double.parseDouble(lowTheshold);
                hThreshold = Double.parseDouble(highTheshold);
            } else if (numberType.equals("float")) {
                lThreshold = Float.valueOf(Float.parseFloat(lowTheshold));
                hThreshold = Float.valueOf(Float.parseFloat(highTheshold));
            } else if (numberType.equals("byte")) {
                lThreshold = Byte.parseByte(lowTheshold);
                hThreshold = Byte.parseByte(highTheshold);
            }
            monitor.setThresholds(hThreshold, lThreshold);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "lowthreshold or highthreshold", "monitor"), ex);
        }
        if (!monitor.getNotifyHigh()) {
            monitor.setNotifyHigh(true);
        }
        if (!monitor.getNotifyLow()) {
            monitor.setNotifyLow(true);
        }
        return monitor;
    }

    private Monitor createStringMonitor(Hashtable<String, String> table) {
        StringMonitor monitor = null;
        try {
            monitor = (StringMonitor)this.getMBeanServer().instantiate("javax.management.monitor.StringMonitor");
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "sgmt.internal_error", ex);
        }
        String strToCompare = table.get("stringtocompare");
        String strNotify = table.get("stringnotify");
        if (strToCompare == null) {
            throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "stringtocompare", "monitor"));
        }
        monitor.setStringToCompare(strToCompare);
        if (strNotify == null || strNotify.equals("notifymatch")) {
            monitor.setNotifyMatch(true);
            return monitor;
        }
        if (strNotify.equals("notifydiffer")) {
            monitor.setNotifyDiffer(true);
        }
        return monitor;
    }

    private StatisticMonitor createStringStatisticMonitor(Hashtable<String, String> table) {
        StringStatisticMonitor monitor = null;
        try {
            monitor = (StringStatisticMonitor)this.getMBeanServer().instantiate("com.sun.enterprise.admin.selfmanagement.event.StringStatisticMonitor");
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, "sgmt.internal_error", ex);
        }
        String strToCompare = table.get("stringtocompare");
        String strNotify = table.get("stringnotify");
        if (strToCompare == null) {
            throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "stringtocompare", "monitor"));
        }
        monitor.setStringToCompare(strToCompare);
        if (strNotify == null || strNotify.equals("notifymatch")) {
            monitor.setNotifyMatch(true);
            return monitor;
        }
        if (strNotify.equals("notifydiffer")) {
            monitor.setNotifyDiffer(true);
        }
        return monitor;
    }

    static MonitorEventFactory getInstance() {
        return instance;
    }

    private synchronized String getNewVersionString() {
        Long l = this.seqno;
        Long l2 = this.seqno = Long.valueOf(this.seqno + 1L);
        return this.seqno.toString();
    }
}

