/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.verifier;

import com.sun.enterprise.admin.verifier.ServerMgr;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerXMLVerifier {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.verifier");
    public boolean debug = false;
    public String outputFileStr = null;
    public static final int FAIL = 0;
    public static final int WARN = 1;
    public static final int ALL = 2;
    private static int reportLevel = 2;
    public String xmlFileName;
    public ConfigContext configContext = null;
    public LocalStringManagerImpl smh;
    public static ServerMgr serverMgr;

    public ServerXMLVerifier() {
        try {
            StringManagerHelper.setLocalStringsManager(Class.forName(this.getClass().getName()));
            this.smh = StringManagerHelper.getLocalStringsManager();
        }
        catch (ClassNotFoundException e) {
            _logger.log(Level.FINE, "serverxmlverifier.error_getting_localstringsmanager", e);
        }
        this.init();
    }

    public void init() {
        File testNames = new File("lib/TestNamesMBean.xml");
        if (testNames.exists()) {
            _logger.log(Level.INFO, "serverxmlverifier.looking_file", testNames.getAbsolutePath());
        }
    }

    public static void main(String[] args) {
        ServerXMLVerifier serverVerifier = new ServerXMLVerifier();
        serverVerifier.parseArgs(args);
    }

    protected void parseArgs(String[] args) {
        if (args.length < 1) {
            this.usage();
        } else {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.startsWith("-")) {
                    try {
                        switch (arg.charAt(1)) {
                            case 'v': {
                                this.debug = true;
                                this.debug(this.smh.getLocalString(this.getClass().getName() + ".verboseFlag", "Setting verbose flag to TRUE."));
                                break;
                            }
                            case 'h': {
                                this.debug(this.smh.getLocalString(this.getClass().getName() + ".helpMessage", "Displaying help message."));
                                this.usage();
                                break;
                            }
                            case 'o': {
                                this.debug(this.smh.getLocalString(this.getClass().getName() + ".outputFileName", "Retrieving results output filename."));
                                char[] vhstr = new char[arg.length() - 2];
                                arg.getChars(2, arg.length(), vhstr, 0);
                                this.outputFileStr = new String(vhstr);
                                this.debug("Using this output file = " + this.outputFileStr);
                                ServerMgr.setFile(this.outputFileStr);
                                break;
                            }
                            default: {
                                this.usage();
                                break;
                            }
                        }
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        this.debug(e);
                        this.usage();
                    }
                    continue;
                }
                if (this.xmlFileName == null) {
                    this.xmlFileName = new File(arg).getAbsolutePath();
                    this.debug(this.smh.getLocalString(this.getClass().getName() + ".xmlFileName", "XML filename: {0}", new Object[]{this.xmlFileName}));
                    continue;
                }
                this.debug(this.smh.getLocalString(this.getClass().getName() + "invalidArg", "invalid argument \"{0}\"", new Object[]{arg}));
                this.usage();
                return;
            }
            if (this.xmlFileName == null) {
                this.usage();
                return;
            }
        }
    }

    public void usage() {
        System.err.println("\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine1", "usage: server-verifier [optional_params] <server-xml-filename>") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine2", "where :") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine3", "  [optional_params]: Must be: ") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine4", "     -v : verbose debug turned on ") + "\n\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine5", "    -o<output file> : test results written to this file (.xml file preferred)") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine6", "                      (Overrides default file - Results.xml)") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine6a", "                      which is created in system defined <tmp> directory") + "\n" + this.smh.getLocalString(this.getClass().getName() + ".usageLine17", "<server-xml-filename>: Jar file to perform static verification on ") + "\n\n");
    }

    public void debug(String s) {
        if (this.debug) {
            _logger.log(Level.INFO, s);
        }
    }

    public void debug(Exception e) {
        if (this.debug) {
            _logger.log(Level.INFO, "serverxmlverifier.error_check", e);
        }
    }
}

