/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.appclient.jws;

import com.sun.enterprise.appclient.jws.Content;
import com.sun.enterprise.appclient.jws.ContentOrigin;
import com.sun.enterprise.appclient.jws.NamingConventions;
import java.io.File;
import java.net.URI;

public class StaticContent
extends Content {
    private URI relativeURI;
    private boolean isMainJarFile;

    public StaticContent(ContentOrigin origin, String contentKey, String path, File file, URI installRootURI, boolean isMainJarFile) {
        super(origin, contentKey, path);
        URI fileURI = file.toURI();
        this.relativeURI = installRootURI.relativize(fileURI);
        this.isMainJarFile = isMainJarFile;
    }

    public URI getRelativeURI() {
        return this.relativeURI;
    }

    public String toString() {
        String result = super.toString() + ", relative URI=" + this.getRelativeURI() + ", isMain=" + this.isMainJarFile;
        return result;
    }

    public String getMainExpr() {
        String result = this.isMainJarFile ? " main=\"true\"" : "";
        return result;
    }

    public String asJNLPJarElement() {
        String fullPath = "${request.scheme}://${request.host}:${request.port}" + NamingConventions.fullJarPath(this.getContentKey());
        return "        <jar href=\"" + fullPath + "\" " + this.getMainExpr() + "/>" + this.lineSep;
    }
}

