/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.admin.util.JMXConnectorConfig;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgents;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.security.store.IdentityManager;
import java.util.ArrayList;

public class NodeAgentHelper
extends ConfigAPIHelper {
    public static NodeAgent[] getNodeAgentsInDomain(ConfigContext configContext) throws ConfigException {
        Domain domain = NodeAgentHelper.getDomainConfigBean(configContext);
        return domain.getNodeAgents().getNodeAgent();
    }

    public static boolean isANodeAgent(ConfigContext configContext, String agentName) throws ConfigException {
        Domain domain = NodeAgentHelper.getDomainConfigBean(configContext);
        NodeAgents controllers = domain.getNodeAgents();
        if (controllers == null) {
            return false;
        }
        NodeAgent controller = controllers.getNodeAgentByName(agentName);
        return controller != null;
    }

    public static boolean hasNodeAgentRendezvousd(ConfigContext configContext, NodeAgent agent) throws ConfigException {
        ElementProperty rendezvousProperty = agent.getElementPropertyByName("rendezvousOccurred");
        String rendezvous = rendezvousProperty.getValue();
        return rendezvous != null && rendezvousProperty.getValue().equals(Boolean.TRUE.toString());
    }

    public static NodeAgent getNodeAgentByName(ConfigContext configContext, String agentName) throws ConfigException {
        Domain domain = NodeAgentHelper.getDomainConfigBean(configContext);
        NodeAgent controller = domain.getNodeAgents().getNodeAgentByName(agentName);
        if (controller == null) {
            throw new ConfigException(_strMgr.getString("noSuchAgent", agentName));
        }
        return controller;
    }

    public static NodeAgent getNodeAgentForServer(ConfigContext configContext, String instanceName) throws ConfigException {
        Server server = ServerHelper.getServerByName(configContext, instanceName);
        Domain domain = NodeAgentHelper.getDomainConfigBean(configContext);
        NodeAgent controller = domain.getNodeAgents().getNodeAgentByName(server.getNodeAgentRef());
        if (controller == null) {
            throw new ConfigException(_strMgr.getString("noSuchAgentForInstance", instanceName, server.getNodeAgentRef()));
        }
        return controller;
    }

    public static NodeAgent[] getNodeAgentsForCluster(ConfigContext configContext, String clusterName) throws ConfigException {
        ArrayList<NodeAgent> result = new ArrayList<NodeAgent>();
        Server[] servers = ServerHelper.getServersInCluster(configContext, clusterName);
        for (int i = 0; i < servers.length; ++i) {
            NodeAgent controller = NodeAgentHelper.getNodeAgentForServer(configContext, servers[i].getName());
            if (result.contains(controller)) continue;
            result.add(controller);
        }
        return result.toArray(new NodeAgent[result.size()]);
    }

    public static JmxConnector getNodeAgentSystemConnector(ConfigContext configContext, String agentName) throws ConfigException {
        NodeAgent controller = NodeAgentHelper.getNodeAgentByName(configContext, agentName);
        String systemConnectorName = controller.getSystemJmxConnectorName();
        JmxConnector connector = controller.getJmxConnector();
        if (connector == null) {
            throw new ConfigException(_strMgr.getString("noAgentSystemConnector", agentName, systemConnectorName));
        }
        return connector;
    }

    public static JMXConnectorConfig getJMXConnectorInfo(ConfigContext configContext, String nodeAgentName) throws ConfigException {
        JmxConnector connector = NodeAgentHelper.getNodeAgentSystemConnector(configContext, nodeAgentName);
        String adminUser = IdentityManager.getUser();
        String adminPassword = IdentityManager.getPassword();
        ElementProperty hostProp = connector.getElementPropertyByName("client-hostname");
        if (adminUser == null || adminPassword == null || hostProp == null) {
            throw new ConfigException(_strMgr.getString("missingAgentConnectorAuth", nodeAgentName));
        }
        return new JMXConnectorConfig(hostProp.getValue(), connector.getPort(), adminUser, adminPassword, connector.getProtocol());
    }
}

