/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.admin.jmx.remote.server.rmi.JmxServiceUrlFactory;
import com.sun.enterprise.admin.util.JMXConnectorConfig;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.AppclientModule;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ConfigAPIHelper;
import com.sun.enterprise.config.serverbeans.ConnectorModule;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.EjbModule;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.LifecycleModule;
import com.sun.enterprise.config.serverbeans.NodeAgent;
import com.sun.enterprise.config.serverbeans.NodeAgentHelper;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import com.sun.enterprise.config.serverbeans.ResourceHelper;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.security.store.IdentityManager;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class ServerHelper
extends ConfigAPIHelper {
    public static final String ADMIN_HTTP_LISTNER_ID = "admin-listener";

    public static String getServersAsString(Server[] servers) {
        String result = "";
        for (int i = 0; i < servers.length; ++i) {
            result = result + servers[i].getName();
            if (i >= servers.length - 1) continue;
            result = result + ",";
        }
        return result;
    }

    public static Server[] getServersInDomain(ConfigContext configContext) throws ConfigException {
        Domain domain = ServerHelper.getDomainConfigBean(configContext);
        return domain.getServers().getServer();
    }

    public static boolean isAServer(ConfigContext configContext, String instanceName) throws ConfigException {
        Domain domain = ServerHelper.getDomainConfigBean(configContext);
        Server server = domain.getServers().getServerByName(instanceName);
        return server != null;
    }

    public static Server getServerByName(ConfigContext configContext, String instanceName) throws ConfigException {
        Domain domain = ServerHelper.getDomainConfigBean(configContext);
        Server server = domain.getServers().getServerByName(instanceName);
        if (server == null) {
            throw new ConfigException(_strMgr.getString("noSuchInstance", instanceName));
        }
        return server;
    }

    public static Server getDAS(ConfigContext configContext) throws ConfigException {
        Server[] servers = ServerHelper.getServersInDomain(configContext);
        Server das = null;
        for (int i = 0; i < servers.length; ++i) {
            if (!ServerHelper.isDAS(configContext, servers[i])) continue;
            if (das == null) {
                das = servers[i];
                continue;
            }
            throw new ConfigException(_strMgr.getString("tooManyDASFound", das.getName(), servers[i].getName()));
        }
        if (das == null) {
            throw new ConfigException(_strMgr.getString("noDASFound"));
        }
        return das;
    }

    public static Server[] getServersReferencingConfig(ConfigContext configContext, String configName) throws ConfigException {
        Config config = ServerHelper.getConfigByName(configContext, configName);
        Server[] servers = ServerHelper.getServersInDomain(configContext);
        ArrayList<Server> result = new ArrayList<Server>();
        for (int i = 0; i < servers.length; ++i) {
            if (!servers[i].getConfigRef().equals(configName)) continue;
            result.add(servers[i]);
        }
        return result.toArray(new Server[result.size()]);
    }

    public static Server[] getStandAloneServers(ConfigContext configContext, boolean excludeDASInstance) throws ConfigException {
        Server[] servers = ServerHelper.getServersInDomain(configContext);
        ArrayList<Server> result = new ArrayList<Server>();
        for (int i = 0; i < servers.length; ++i) {
            if (ServerHelper.isDAS(configContext, servers[i]) && excludeDASInstance || !ServerHelper.isServerStandAlone(configContext, servers[i].getName())) continue;
            result.add(servers[i]);
        }
        return result.toArray(new Server[result.size()]);
    }

    public static Server[] getUnclusteredServers(ConfigContext configContext, boolean excludeDASInstance) throws ConfigException {
        Server[] servers = ServerHelper.getServersInDomain(configContext);
        ArrayList<Server> result = new ArrayList<Server>();
        for (int i = 0; i < servers.length; ++i) {
            if (ServerHelper.isDAS(configContext, servers[i]) && excludeDASInstance || ServerHelper.isServerClustered(configContext, servers[i])) continue;
            result.add(servers[i]);
        }
        return result.toArray(new Server[result.size()]);
    }

    public static Server[] getServersInCluster(ConfigContext configContext, String clusterName) throws ConfigException {
        Cluster cluster = ClusterHelper.getClusterByName(configContext, clusterName);
        ServerRef[] serverRefs = cluster.getServerRef();
        Server[] result = new Server[serverRefs.length];
        for (int i = 0; i < serverRefs.length; ++i) {
            try {
                result[i] = ServerHelper.getServerByName(configContext, serverRefs[i].getRef());
                continue;
            }
            catch (ConfigException ex) {
                throw new ConfigException(_strMgr.getString("noSuchClusterInstance", clusterName, serverRefs[i].getRef()));
            }
        }
        return result;
    }

    public static boolean isDAS(ConfigContext configContext, Server server) throws ConfigException {
        return server.getNodeAgentRef() == null;
    }

    public static boolean isDAS(ConfigContext configContext, String instanceName) throws ConfigException {
        Domain domain = ServerHelper.getDomainConfigBean(configContext);
        Server server = domain.getServers().getServerByName(instanceName);
        return ServerHelper.isDAS(configContext, server);
    }

    public static Server[] getServersOfANodeAgent(ConfigContext configContext, String agentName) throws ConfigException {
        NodeAgent controller = NodeAgentHelper.getNodeAgentByName(configContext, agentName);
        Server[] servers = ServerHelper.getServersInDomain(configContext);
        ArrayList<Server> result = new ArrayList<Server>();
        for (int i = 0; i < servers.length; ++i) {
            if (ServerHelper.isDAS(configContext, servers[i]) || !servers[i].getNodeAgentRef().equals(agentName)) continue;
            result.add(servers[i]);
        }
        return result.toArray(new Server[result.size()]);
    }

    public static JmxConnector getServerSystemConnector(ConfigContext configContext, String instanceName) throws ConfigException {
        String systemConnectorName;
        AdminService adminService = ServerHelper.getAdminServiceForServer(configContext, instanceName);
        JmxConnector connector = adminService.getJmxConnectorByName(systemConnectorName = adminService.getSystemJmxConnectorName());
        if (connector == null) {
            throw new ConfigException(_strMgr.getString("noInstanceSystemConnector", instanceName, systemConnectorName));
        }
        return connector;
    }

    public static JMXConnectorConfig getJMXConnectorInfo(ConfigContext configContext, String instanceName) throws ConfigException {
        JmxConnector connector = ServerHelper.getServerSystemConnector(configContext, instanceName);
        String portAttribute = connector.getRawAttributeValue("port");
        String port = new PropertyResolver(configContext, instanceName).resolve(portAttribute);
        Server server = ServerHelper.getServerByName(configContext, instanceName);
        ElementProperty hostProp = null;
        AdminService adminService = ServerHelper.getAdminServiceForServer(configContext, instanceName);
        if (ServerHelper.isDAS(configContext, server)) {
            hostProp = connector.getElementPropertyByName("client-hostname");
        } else {
            JmxConnector agentConnector = NodeAgentHelper.getNodeAgentSystemConnector(configContext, server.getNodeAgentRef());
            hostProp = agentConnector.getElementPropertyByName("client-hostname");
        }
        String adminUser = IdentityManager.getUser();
        String adminPassword = IdentityManager.getPassword();
        if (adminUser == null || adminPassword == null || hostProp == null) {
            throw new ConfigException(_strMgr.getString("missingInstanceConnectorAuth", instanceName));
        }
        return new JMXConnectorConfig(hostProp.getValue(), port, adminUser, adminPassword, connector.getProtocol());
    }

    public static AdminService getAdminServiceForServer(ConfigContext configContext, String instanceName) throws ConfigException {
        Config config = ServerHelper.getConfigForServer(configContext, instanceName);
        AdminService adminService = config.getAdminService();
        if (adminService == null) {
            throw new ConfigException(_strMgr.getString("noAdminService", config.getName(), instanceName));
        }
        return adminService;
    }

    public static Config getConfigForServer(ConfigContext configContext, String instanceName) throws ConfigException {
        Server server = ServerHelper.getServerByName(configContext, instanceName);
        return ServerHelper.getConfigByName(configContext, server.getConfigRef());
    }

    public static boolean isServerClustered(ConfigContext configContext, Server server) throws ConfigException {
        String instanceName = server.getName();
        Cluster[] clusters = ClusterHelper.getClustersInDomain(configContext);
        for (int i = 0; i < clusters.length; ++i) {
            ServerRef[] servers = clusters[i].getServerRef();
            for (int j = 0; j < servers.length; ++j) {
                if (!servers[j].getRef().equals(instanceName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isServerClustered(ConfigContext configContext, String instanceName) throws ConfigException {
        return ServerHelper.isServerClustered(configContext, ServerHelper.getServerByName(configContext, instanceName));
    }

    public static boolean isServerStandAlone(ConfigContext configContext, String instanceName) throws ConfigException {
        Server server = ServerHelper.getServerByName(configContext, instanceName);
        String configName = server.getConfigRef();
        return ServerHelper.isConfigurationNameStandAlone(configName, instanceName) && !ServerHelper.isServerClustered(configContext, server) && ServerHelper.isConfigurationReferencedByServerOnly(configContext, configName, instanceName);
    }

    public static boolean serverReferencesApplication(ConfigContext configContext, String instanceName, String appName) throws ConfigException {
        Server server = ServerHelper.getServerByName(configContext, instanceName);
        return ServerHelper.serverReferencesApplication(server, appName);
    }

    public static boolean serverReferencesApplication(Server server, String appName) throws ConfigException {
        ApplicationRef ref = server.getApplicationRefByRef(appName);
        return ref != null;
    }

    public static Server[] getServersReferencingApplication(ConfigContext configContext, String appName) throws ConfigException {
        Server[] servers = ServerHelper.getServersInDomain(configContext);
        ArrayList<Server> result = new ArrayList<Server>();
        for (int i = 0; i < servers.length; ++i) {
            if (!ServerHelper.serverReferencesApplication(servers[i], appName)) continue;
            result.add(servers[i]);
        }
        return result.toArray(new Server[result.size()]);
    }

    public static boolean serverReferencesJdbcConPool(ConfigContext ctx, String instanceName, String poolName) throws ConfigException {
        Server server = ServerHelper.getServerByName(ctx, instanceName);
        return ServerHelper.serverReferencesJdbcConPool(server, poolName);
    }

    public static boolean serverReferencesJdbcConPool(Server server, String poolName) throws ConfigException {
        ResourceRef ref = server.getResourceRefByRef(poolName);
        return ref != null;
    }

    public static boolean serverReferencesResource(ConfigContext configContext, String instanceName, String resourceName) throws ConfigException {
        Server server = ServerHelper.getServerByName(configContext, instanceName);
        return ServerHelper.serverReferencesResource(server, resourceName);
    }

    public static boolean serverReferencesResource(Server server, String resourceName) throws ConfigException {
        ResourceRef ref = server.getResourceRefByRef(resourceName);
        return ref != null;
    }

    public static Server[] getServersReferencingResource(ConfigContext configContext, String resName) throws ConfigException {
        Server[] servers = ServerHelper.getServersInDomain(configContext);
        ArrayList<Server> result = new ArrayList<Server>();
        for (int i = 0; i < servers.length; ++i) {
            if (!ServerHelper.serverReferencesResource(servers[i], resName)) continue;
            result.add(servers[i]);
        }
        return result.toArray(new Server[result.size()]);
    }

    public static Server[] getServersReferencingJdbcPool(ConfigContext ctx, String poolName) throws ConfigException {
        Server[] servers = ServerHelper.getServersInDomain(ctx);
        ArrayList<Server> result = new ArrayList<Server>();
        for (int i = 0; i < servers.length; ++i) {
            if (!ResourceHelper.isJdbcPoolReferenced(ctx, poolName, servers[i].getName())) continue;
            result.add(servers[i]);
        }
        return result.toArray(new Server[result.size()]);
    }

    public static Server[] getServersReferencingConnectorPool(ConfigContext ctx, String poolName) throws ConfigException {
        Server[] servers = ServerHelper.getServersInDomain(ctx);
        ArrayList<Server> result = new ArrayList<Server>();
        for (int i = 0; i < servers.length; ++i) {
            if (!ResourceHelper.isConnectorPoolReferenced(ctx, poolName, servers[i].getName())) continue;
            result.add(servers[i]);
        }
        return result.toArray(new Server[result.size()]);
    }

    public static ApplicationRef[] getApplicationReferences(ConfigContext configContext, String serverName) throws ConfigException {
        Server server = ServerHelper.getServerByName(configContext, serverName);
        if (server.getApplicationRef() == null) {
            return new ApplicationRef[0];
        }
        return server.getApplicationRef();
    }

    public static ResourceRef[] getResourceReferences(ConfigContext configContext, String serverName) throws ConfigException {
        Server server = ServerHelper.getServerByName(configContext, serverName);
        if (server.getResourceRef() == null) {
            return new ResourceRef[0];
        }
        return server.getResourceRef();
    }

    public static J2eeApplication[] getAssociatedJ2eeApplications(ConfigContext ctx, String serverName) throws ConfigException {
        ArrayList<J2eeApplication> list = new ArrayList<J2eeApplication>();
        Domain domain = (Domain)ctx.getRootConfigBean();
        Applications applications = domain.getApplications();
        Servers servers = domain.getServers();
        Server s = servers.getServerByName(serverName);
        if (s != null) {
            J2eeApplication[] j2eeApps = applications.getJ2eeApplication();
            for (int i = 0; i < j2eeApps.length; ++i) {
                if (!ServerHelper.serverReferencesApplication(ctx, serverName, j2eeApps[i].getName())) continue;
                list.add(j2eeApps[i]);
            }
        }
        J2eeApplication[] associatedApps = new J2eeApplication[list.size()];
        return list.toArray(associatedApps);
    }

    public static J2eeApplication[] getUnAssociatedJ2eeApplications(ConfigContext ctx, String serverName) throws ConfigException {
        ArrayList<J2eeApplication> list = new ArrayList<J2eeApplication>();
        Domain domain = (Domain)ctx.getRootConfigBean();
        Applications applications = domain.getApplications();
        Servers servers = domain.getServers();
        Server s = servers.getServerByName(serverName);
        if (s != null) {
            J2eeApplication[] j2eeApps = applications.getJ2eeApplication();
            for (int i = 0; i < j2eeApps.length; ++i) {
                if (ServerHelper.serverReferencesApplication(ctx, serverName, j2eeApps[i].getName())) continue;
                list.add(j2eeApps[i]);
            }
        }
        J2eeApplication[] unassociatedApps = new J2eeApplication[list.size()];
        return list.toArray(unassociatedApps);
    }

    public static EjbModule[] getAssociatedEjbModules(ConfigContext ctx, String serverName) throws ConfigException {
        ArrayList<EjbModule> list = new ArrayList<EjbModule>();
        Domain domain = (Domain)ctx.getRootConfigBean();
        Applications applications = domain.getApplications();
        Servers servers = domain.getServers();
        Server s = servers.getServerByName(serverName);
        if (s != null) {
            EjbModule[] ejbMods = applications.getEjbModule();
            for (int i = 0; i < ejbMods.length; ++i) {
                if (!ServerHelper.serverReferencesApplication(ctx, serverName, ejbMods[i].getName())) continue;
                list.add(ejbMods[i]);
            }
        }
        EjbModule[] associatedApps = new EjbModule[list.size()];
        return list.toArray(associatedApps);
    }

    public static EjbModule[] getUnAssociatedEjbModules(ConfigContext ctx, String serverName) throws ConfigException {
        ArrayList<EjbModule> list = new ArrayList<EjbModule>();
        Domain domain = (Domain)ctx.getRootConfigBean();
        Applications applications = domain.getApplications();
        Servers servers = domain.getServers();
        Server s = servers.getServerByName(serverName);
        if (s != null) {
            EjbModule[] ejbMods = applications.getEjbModule();
            for (int i = 0; i < ejbMods.length; ++i) {
                if (ServerHelper.serverReferencesApplication(ctx, serverName, ejbMods[i].getName())) continue;
                list.add(ejbMods[i]);
            }
        }
        EjbModule[] unassociatedApps = new EjbModule[list.size()];
        return list.toArray(unassociatedApps);
    }

    public static WebModule[] getAssociatedWebModules(ConfigContext ctx, String serverName) throws ConfigException {
        ArrayList<WebModule> list = new ArrayList<WebModule>();
        Domain domain = (Domain)ctx.getRootConfigBean();
        Applications applications = domain.getApplications();
        Servers servers = domain.getServers();
        Server s = servers.getServerByName(serverName);
        if (s != null) {
            WebModule[] webMods = applications.getWebModule();
            for (int i = 0; i < webMods.length; ++i) {
                if (!ServerHelper.serverReferencesApplication(ctx, serverName, webMods[i].getName())) continue;
                list.add(webMods[i]);
            }
        }
        WebModule[] associatedApps = new WebModule[list.size()];
        return list.toArray(associatedApps);
    }

    public static WebModule[] getUnAssociatedWebModules(ConfigContext ctx, String serverName) throws ConfigException {
        ArrayList<WebModule> list = new ArrayList<WebModule>();
        Domain domain = (Domain)ctx.getRootConfigBean();
        Applications applications = domain.getApplications();
        Servers servers = domain.getServers();
        Server s = servers.getServerByName(serverName);
        if (s != null) {
            WebModule[] webMods = applications.getWebModule();
            for (int i = 0; i < webMods.length; ++i) {
                if (ServerHelper.serverReferencesApplication(ctx, serverName, webMods[i].getName())) continue;
                list.add(webMods[i]);
            }
        }
        WebModule[] unassociatedApps = new WebModule[list.size()];
        return list.toArray(unassociatedApps);
    }

    public static ConnectorModule[] getUnAssociatedConnectorModules(ConfigContext ctx, String serverName) throws ConfigException {
        ArrayList<ConnectorModule> list = new ArrayList<ConnectorModule>();
        Domain domain = (Domain)ctx.getRootConfigBean();
        Applications applications = domain.getApplications();
        Servers servers = domain.getServers();
        Server s = servers.getServerByName(serverName);
        if (s != null) {
            ConnectorModule[] connMods = applications.getConnectorModule();
            for (int i = 0; i < connMods.length; ++i) {
                if (ServerHelper.serverReferencesApplication(ctx, serverName, connMods[i].getName())) continue;
                list.add(connMods[i]);
            }
        }
        ConnectorModule[] unassociatedApps = new ConnectorModule[list.size()];
        return list.toArray(unassociatedApps);
    }

    public static ConnectorModule[] getAssociatedConnectorModules(ConfigContext ctx, String serverName) throws ConfigException {
        ArrayList<ConnectorModule> list = new ArrayList<ConnectorModule>();
        Domain domain = (Domain)ctx.getRootConfigBean();
        Applications applications = domain.getApplications();
        Servers servers = domain.getServers();
        Server s = servers.getServerByName(serverName);
        if (s != null) {
            ConnectorModule[] connMods = applications.getConnectorModule();
            for (int i = 0; i < connMods.length; ++i) {
                if (!ServerHelper.serverReferencesApplication(ctx, serverName, connMods[i].getName())) continue;
                list.add(connMods[i]);
            }
        }
        ConnectorModule[] associatedApps = new ConnectorModule[list.size()];
        return list.toArray(associatedApps);
    }

    public static LifecycleModule[] getUnAssociatedLifecycleModules(ConfigContext ctx, String serverName) throws ConfigException {
        ArrayList<LifecycleModule> list = new ArrayList<LifecycleModule>();
        Domain domain = (Domain)ctx.getRootConfigBean();
        Applications applications = domain.getApplications();
        Servers servers = domain.getServers();
        Server s = servers.getServerByName(serverName);
        if (s != null) {
            LifecycleModule[] lcMods = applications.getLifecycleModule();
            for (int i = 0; i < lcMods.length; ++i) {
                if (ServerHelper.serverReferencesApplication(ctx, serverName, lcMods[i].getName())) continue;
                list.add(lcMods[i]);
            }
        }
        LifecycleModule[] unassociatedApps = new LifecycleModule[list.size()];
        return list.toArray(unassociatedApps);
    }

    public static LifecycleModule[] getAssociatedLifecycleModules(ConfigContext ctx, String serverName) throws ConfigException {
        ArrayList<LifecycleModule> list = new ArrayList<LifecycleModule>();
        Domain domain = (Domain)ctx.getRootConfigBean();
        Applications applications = domain.getApplications();
        Servers servers = domain.getServers();
        Server s = servers.getServerByName(serverName);
        if (s != null) {
            LifecycleModule[] lcMods = applications.getLifecycleModule();
            for (int i = 0; i < lcMods.length; ++i) {
                if (!ServerHelper.serverReferencesApplication(ctx, serverName, lcMods[i].getName())) continue;
                list.add(lcMods[i]);
            }
        }
        LifecycleModule[] associatedApps = new LifecycleModule[list.size()];
        return list.toArray(associatedApps);
    }

    public static AppclientModule[] getUnAssociatedAppclientModules(ConfigContext ctx, String serverName) throws ConfigException {
        ArrayList<AppclientModule> list = new ArrayList<AppclientModule>();
        Domain domain = (Domain)ctx.getRootConfigBean();
        Applications applications = domain.getApplications();
        Servers servers = domain.getServers();
        Server s = servers.getServerByName(serverName);
        if (s != null) {
            AppclientModule[] appclntMods = applications.getAppclientModule();
            for (int i = 0; i < appclntMods.length; ++i) {
                if (ServerHelper.serverReferencesApplication(ctx, serverName, appclntMods[i].getName())) continue;
                list.add(appclntMods[i]);
            }
        }
        AppclientModule[] unassociatedApps = new AppclientModule[list.size()];
        return list.toArray(unassociatedApps);
    }

    public static AppclientModule[] getAssociatedAppclientModules(ConfigContext ctx, String serverName) throws ConfigException {
        ArrayList<AppclientModule> list = new ArrayList<AppclientModule>();
        Domain domain = (Domain)ctx.getRootConfigBean();
        Applications applications = domain.getApplications();
        Servers servers = domain.getServers();
        Server s = servers.getServerByName(serverName);
        if (s != null) {
            AppclientModule[] appclntMods = applications.getAppclientModule();
            for (int i = 0; i < appclntMods.length; ++i) {
                if (!ServerHelper.serverReferencesApplication(ctx, serverName, appclntMods[i].getName())) continue;
                list.add(appclntMods[i]);
            }
        }
        AppclientModule[] associatedApps = new AppclientModule[list.size()];
        return list.toArray(associatedApps);
    }

    public static String getAdministrativeDomainName(ConfigContext ctx, String serverName) throws ConfigException {
        ElementProperty aDomainNameProp;
        String ADMIN_DOMAIN_PROP = "administrative.domain.name";
        String aDomainName = null;
        Domain domain = ServerHelper.getDomainConfigBean(ctx);
        if (domain != null && (aDomainNameProp = domain.getElementPropertyByName("administrative.domain.name")) != null) {
            aDomainName = aDomainNameProp.getValue();
        }
        return aDomainName;
    }

    public static MBeanServerConnection connect(ConfigContext configContext, String instanceName) throws ConfigException, IOException {
        JMXConnector conn = ServerHelper.getJMXConnector(configContext, instanceName);
        return conn.getMBeanServerConnection();
    }

    public static JMXConnector getJMXConnector(ConfigContext configContext, String instanceName) throws ConfigException, IOException {
        JMXConnectorConfig jcc = ServerHelper.getJMXConnectorInfo(configContext, instanceName);
        JMXServiceURL url = null;
        try {
            url = JmxServiceUrlFactory.forRmiWithJndiInAppserver((String)jcc.getHost(), (int)Integer.parseInt(jcc.getPort()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        env.put("jmx.remote.credentials", new String[]{jcc.getUser(), jcc.getPassword()});
        JMXConnector conn = JMXConnectorFactory.connect(url, env);
        return conn;
    }

    public static HttpListener getHttpListener(ConfigContext cc, String sn, String ln) throws ConfigException {
        Config cfg = ServerHelper.getConfigForServer(cc, sn);
        HttpService hs = cfg.getHttpService();
        HttpListener hl = hs.getHttpListenerById(ln);
        return hl;
    }

    public static HttpListener[] getHttpListeners(ConfigContext cc, String sn) throws ConfigException {
        Config cfg = ServerHelper.getConfigForServer(cc, sn);
        HttpService hs = cfg.getHttpService();
        return hs.getHttpListener();
    }

    public static String getUrlString(HttpListener ls) {
        String url = ls.isSecurityEnabled() ? "https://" : "http://";
        String address = "0.0.0.0".equals(ls.getAddress()) ? "localhost" : ls.getAddress();
        url = url + address + ":" + ls.getPort();
        return url;
    }

    public static JMXServiceURL getJmxServiceUrl(JmxConnector conn) {
        int port;
        String sport = conn.getPort();
        String local = null;
        try {
            port = Integer.parseInt(sport);
            local = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String address = "0.0.0.0".equals(conn.getAddress()) ? local : conn.getAddress();
        JMXServiceURL url = JmxServiceUrlFactory.forJconsoleOverRmiWithJndiInAppserver((String)address, (int)port);
        return url;
    }
}

