/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConnectionDefinitionUtils {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public static Set getConnectionDefinitionProperties(String connectionDefinitionClassName) {
        HashSet<String> propertySet = new HashSet<String>();
        try {
            Method[] methods = Thread.currentThread().getContextClassLoader().loadClass(connectionDefinitionClassName).getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!ConnectionDefinitionUtils.isValidSetterMethod(methods[i])) continue;
                String name = methods[i].getName();
                String propertyName = name.substring(name.indexOf("set") + "set".length(), name.length());
                propertySet.add(propertyName);
            }
        }
        catch (SecurityException e) {
            ConnectionDefinitionUtils.handleException(e);
        }
        catch (ClassNotFoundException e) {
            ConnectionDefinitionUtils.handleException(e);
        }
        return propertySet;
    }

    private static boolean isValidSetterMethod(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes().length == 1 && ConnectionDefinitionUtils.isValidArgumentType(method);
    }

    private static boolean isValidArgumentType(Method method) {
        Class<?>[] parameters = method.getParameterTypes();
        boolean isValid = true;
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> param = parameters[i];
            if (param.isPrimitive() || param.equals(String.class)) continue;
            return false;
        }
        return isValid;
    }

    public static Map getConnectionDefinitionPropertiesAndDefaults(String connectionDefinitionClassName) {
        Set s = ConnectionDefinitionUtils.getConnectionDefinitionProperties(connectionDefinitionClassName);
        HashMap<String, Object> hm = new HashMap<String, Object>();
        try {
            Class<?> connectionDefinitionClass = Thread.currentThread().getContextClassLoader().loadClass(connectionDefinitionClassName);
            Object obj = connectionDefinitionClass.newInstance();
            for (String property : s) {
                Object defaultVal = null;
                try {
                    Method m = connectionDefinitionClass.getMethod("get" + property, new Class[0]);
                    defaultVal = m.invoke(obj, new Object[0]);
                }
                catch (NoSuchMethodException e) {
                }
                catch (IllegalArgumentException e) {
                }
                catch (InvocationTargetException e) {
                    // empty catch block
                }
                hm.put(property, defaultVal);
            }
        }
        catch (ClassNotFoundException e) {
            ConnectionDefinitionUtils.handleException(e);
        }
        catch (InstantiationException e) {
            ConnectionDefinitionUtils.handleException(e);
        }
        catch (IllegalAccessException e) {
            ConnectionDefinitionUtils.handleException(e);
        }
        catch (SecurityException e) {
            ConnectionDefinitionUtils.handleException(e);
        }
        return hm;
    }

    private static void handleException(Exception ex) {
        ex.printStackTrace();
        _logger.log(Level.SEVERE, "Exception while trying to find properties ", ex.getMessage());
    }

    public static void main(String[] args) {
        Map m = ConnectionDefinitionUtils.getConnectionDefinitionPropertiesAndDefaults("sun.jdbc.odbc.ee.DataSource");
        for (String element : m.keySet()) {
            System.out.println(element + " : " + m.get(element));
        }
    }
}

