/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.archivist.AppClientArchivist;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ConnectorArchivist;
import com.sun.enterprise.deployment.archivist.EjbArchivist;
import com.sun.enterprise.deployment.archivist.PluggableArchivists;
import com.sun.enterprise.deployment.archivist.PluggableArchivistsHelper;
import com.sun.enterprise.deployment.archivist.WebArchivist;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import java.io.File;
import java.io.IOException;
import javax.enterprise.deploy.shared.ModuleType;

public class ArchivistFactory {
    private static PluggableArchivistsHelper defaultArchivists;

    private ArchivistFactory() {
    }

    private static void init() {
        if (defaultArchivists != null) {
            return;
        }
        defaultArchivists = new PluggableArchivistsHelper();
        defaultArchivists.registerArchivist(new ApplicationArchivist());
        defaultArchivists.registerArchivist(new WebArchivist());
        defaultArchivists.registerArchivist(new ConnectorArchivist());
        defaultArchivists.registerArchivist(new AppClientArchivist());
        defaultArchivists.registerArchivist(new EjbArchivist());
    }

    public static PluggableArchivists getPluggableArchivists() {
        ArchivistFactory.init();
        return defaultArchivists;
    }

    public static Archivist getArchivistForType(ModuleType type) {
        ArchivistFactory.init();
        return defaultArchivists.getArchivistForType(type);
    }

    public static Archivist getArchivistForArchive(File jarFileOrDirectory) throws IOException {
        ArchivistFactory.init();
        return defaultArchivists.getArchivistForArchive(jarFileOrDirectory);
    }

    public static Archivist getArchivistForArchive(String path) throws IOException {
        ArchivistFactory.init();
        return defaultArchivists.getArchivistForArchive(path);
    }

    public static Archivist getArchivistForArchive(AbstractArchive archive) throws IOException {
        ArchivistFactory.init();
        return defaultArchivists.getArchivistForArchive(archive);
    }

    public static void registerArchivist(Archivist archivist) {
        ArchivistFactory.init();
        defaultArchivists.registerArchivist(archivist);
    }
}

