/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.backend.J2EEModuleExploder;
import com.sun.enterprise.deployment.backend.ModuleDeployer;
import com.sun.enterprise.instance.AppclientModulesManager;
import com.sun.enterprise.instance.BaseManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.ModuleEnvironment;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.zip.ZipItem;
import java.io.IOException;

public class AppClientModuleDeployer
extends ModuleDeployer {
    private static StringManager localStrings = StringManager.getManager(AppClientModuleDeployer.class);

    AppClientModuleDeployer(DeploymentRequest r) throws IASDeploymentException {
        super(r);
    }

    protected BaseManager createConfigManager(InstanceEnvironment ienv, ModuleEnvironment menv) throws IASDeploymentException, ConfigException {
        return new AppclientModulesManager(ienv);
    }

    protected void preDeploy() throws IASDeploymentException {
        assert (this.moduleDir != null);
        assert (StringUtils.ok(this.moduleName));
        try {
            if (this.isRegistered()) {
                String msg = localStrings.getString("enterprise.deployment.backend.deploy_error_module_exists");
                throw new IASDeploymentException(msg);
            }
            this.liquidateModuleDirAndStubsDirIfTheyHappenToExist();
            if (this.request.isArchive()) {
                J2EEModuleExploder.explodeJar(this.request.getFileSource().getFile(), this.moduleDir);
            }
            this.xmlDir.mkdirs();
            this.jwsDir.mkdirs();
        }
        catch (Exception e) {
            throw new IASDeploymentException(e.toString(), e);
        }
    }

    protected boolean needsStubs() {
        return true;
    }

    protected void preRedeploy() throws IASDeploymentException, ConfigException {
        this.setOldDirs();
        if (this.request.isArchive()) {
            try {
                J2EEModuleExploder.explodeJar(this.request.getFileSource().getFile(), this.moduleDir);
            }
            catch (IOException e) {
                throw new IASDeploymentException(e.toString(), e);
            }
        }
        this.xmlDir.mkdir();
        this.jwsDir.mkdirs();
    }

    protected void deploy() throws IASDeploymentException, ConfigException {
        this.loadDescriptors();
        this.runVerifier();
        this.checkAppclientsMainClasses();
        this.xmlDir.mkdirs();
        this.request.getDescriptor().setGeneratedXMLDirectory(this.xmlDir.getAbsolutePath());
        ZipItem[] clientStubs = this.runEJBC();
        this.createClientJar(clientStubs);
    }
}

