/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.IASDeploymentException;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchiveFactory;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.deploy.shared.FileArchiveFactory;
import com.sun.enterprise.deployment.deploy.shared.JarArchiveFactory;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipFile;
import com.sun.enterprise.util.zip.ZipFileException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;

public class J2EEModuleExploder {
    private static StringManager localStrings = StringManager.getManager(J2EEModuleExploder.class);
    private static Logger logger = null;
    private static final String PRESERVED_MANIFEST_NAME = "META-INF/MANIFEST.MF.preserved";
    private static final String WEB_INF_PREFIX = "WEB-INF/";
    private static String validationLevel = null;

    public static void explode(File archive, File directory, String moduleName) throws IOException, IASDeploymentException {
        J2EEModuleExploder.explode(archive, directory, moduleName, false);
    }

    public static void explode(File archive, File directory, String moduleName, boolean preserveManifest) throws IOException, IASDeploymentException {
        assert (archive != null);
        AbstractArchiveFactory factory = null;
        factory = archive.isDirectory() ? new FileArchiveFactory() : new JarArchiveFactory();
        AbstractArchive source = factory.openArchive(archive.getAbsolutePath());
        Archivist archivist = null;
        try {
            archivist = ArchivistFactory.getArchivistForArchive(source);
            if (archivist == null) {
                String msg = localStrings.getString("enterprise.deployment.backend.no_archivist_recognized_arch", archive.getAbsolutePath());
                throw new IASDeploymentException(msg);
            }
        }
        catch (IOException ioe) {
            String msg = localStrings.getString("enterprise.deployment.backend.error_getting_archivist", archive.getAbsolutePath());
            throw new IASDeploymentException(msg, ioe);
        }
        if (!archivist.getModuleType().equals(ModuleType.EAR)) {
            J2EEModuleExploder.explodeModule(archivist, source, directory, moduleName, preserveManifest);
        }
    }

    private static void explodeModule(Archivist archivist, AbstractArchive source, File directory, String moduleName, boolean preserveManifest) throws IOException, IASDeploymentException {
        File explodedManifest = null;
        File preservedManifestFromArchive = null;
        FileArchive target = new FileArchive();
        target.create(directory.getAbsolutePath());
        J2EEModuleExploder.explodeJar(new File(source.getArchiveUri()), directory);
        if (preserveManifest && (explodedManifest = new File(directory, "META-INF/MANIFEST.MF")).exists()) {
            preservedManifestFromArchive = new File(directory, PRESERVED_MANIFEST_NAME);
            try {
                if (OS.isWindows()) {
                    FileUtils.validateWindowsFilePathLength(preservedManifestFromArchive);
                }
            }
            catch (IOException ioe) {
                IOException newIOE = new IOException(localStrings.getString("enterprise.deployment.backend.error_saving_manifest", new Object[]{explodedManifest.getAbsolutePath(), preservedManifestFromArchive.getAbsolutePath()}));
                newIOE.initCause(ioe);
                throw newIOE;
            }
            if (!explodedManifest.renameTo(preservedManifestFromArchive)) {
                throw new RuntimeException(localStrings.getString("enterprise.deployment.backend.error_saving_manifest", new Object[]{explodedManifest.getAbsolutePath(), preservedManifestFromArchive.getAbsolutePath()}));
            }
        }
        Enumeration itr = source.entries();
        while (itr.hasMoreElements()) {
            String fileName = (String)itr.nextElement();
            if (!fileName.toLowerCase().endsWith(".jar") || fileName.replace('\\', '/').toUpperCase().startsWith(WEB_INF_PREFIX)) continue;
            try {
                File f = new File(directory, fileName);
                File targetDirectory = directory;
                ZipFile zip = new ZipFile(f, targetDirectory);
                zip.explode();
            }
            catch (ZipFileException e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        }
        if (preservedManifestFromArchive != null) {
            if (explodedManifest.exists() && !explodedManifest.delete()) {
                throw new RuntimeException(localStrings.getString("enterprise.deployment.backend.error_deleting_manifest", new Object[]{explodedManifest.getAbsolutePath(), preservedManifestFromArchive.getAbsolutePath()}));
            }
            if (!preservedManifestFromArchive.renameTo(explodedManifest)) {
                throw new RuntimeException(localStrings.getString("enterprise.deployment.backend.error_restoring_manifest", new Object[]{preservedManifestFromArchive.getAbsolutePath(), explodedManifest.getAbsolutePath()}));
            }
        }
        source.close();
        target.close();
    }

    public static Application explodeEar(File source, File destination) throws Exception {
        J2EEModuleExploder.explodeJar(source, destination);
        ApplicationArchivist archivist = new ApplicationArchivist();
        archivist.setXMLValidationLevel(J2EEModuleExploder.getValidationLevel());
        FileArchive appArchive = new FileArchive();
        appArchive.open(destination.getAbsolutePath());
        archivist.setManifest(appArchive.getManifest());
        Application appDesc = null;
        appDesc = archivist.hasStandardDeploymentDescriptor(appArchive) ? (Application)archivist.readStandardDeploymentDescriptor(appArchive) : Application.createApplication(appArchive, true);
        archivist.setDescriptor(appDesc);
        Iterator bundles = appDesc.getModules();
        while (bundles.hasNext()) {
            ModuleDescriptor bundle = (ModuleDescriptor)bundles.next();
            String moduleName = bundle.getArchiveUri();
            String massagedModuleName = FileUtils.makeFriendlyFilename(moduleName);
            File archiveFile = new File(destination, moduleName);
            File moduleDir = new File(destination, massagedModuleName);
            J2EEModuleExploder.explodeJar(archiveFile, moduleDir);
            archiveFile.delete();
        }
        return appDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void explodeJar(File source, File destination) throws IOException {
        JarFile jarFile = null;
        String fileSystemName = null;
        try {
            try {
                jarFile = new JarFile(source);
                Enumeration<JarEntry> e = jarFile.entries();
                while (e.hasMoreElements()) {
                    FileOutputStream fos;
                    block11: {
                        Object var12_15;
                        JarEntry entry = e.nextElement();
                        fileSystemName = entry.getName().replace('/', File.separatorChar);
                        File out = new File(destination, fileSystemName);
                        if (OS.isWindows()) {
                            FileUtils.validateWindowsFilePathLength(out);
                        }
                        if (entry.isDirectory()) {
                            out.mkdirs();
                            continue;
                        }
                        InputStream is = null;
                        fos = null;
                        try {
                            if (!out.getParentFile().exists()) {
                                out.getParentFile().mkdirs();
                            }
                            is = new BufferedInputStream(jarFile.getInputStream(entry));
                            fos = new FileOutputStream(out);
                            ReadableByteChannel inChannel = Channels.newChannel(is);
                            FileChannel outChannel = fos.getChannel();
                            outChannel.transferFrom(inChannel, 0L, entry.getSize());
                            var12_15 = null;
                            if (is == null) break block11;
                        }
                        catch (Throwable throwable) {
                            var12_15 = null;
                            if (is != null) {
                                is.close();
                            }
                            if (fos == null) throw throwable;
                            fos.close();
                            throw throwable;
                        }
                        is.close();
                    }
                    if (fos == null) continue;
                    fos.close();
                    {
                    }
                }
                Object var14_17 = null;
                if (jarFile == null) return;
            }
            catch (Throwable e) {
                String msg0 = localStrings.getString("enterprise.deployment.backend.error_expanding", new Object[]{source.getAbsolutePath()});
                String msg = localStrings.getString("enterprise.deployment.backend.could_not_expand", new Object[]{fileSystemName, destination.getAbsolutePath()});
                IOException ioe = new IOException(msg0);
                ioe.initCause(e);
                J2EEModuleExploder.getLogger().log(Level.SEVERE, msg, ioe);
                throw ioe;
            }
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            if (jarFile == null) throw throwable;
            jarFile.close();
            throw throwable;
        }
        jarFile.close();
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = DeploymentLogger.get();
        }
        return logger;
    }

    private static String getValidationLevel() {
        if (validationLevel == null) {
            try {
                if (ApplicationServer.getServerContext() == null) {
                    validationLevel = "full";
                } else {
                    ConfigContext ctx = ApplicationServer.getServerContext().getConfigContext();
                    DasConfig dc = ServerBeansFactory.getDasConfigBean(ctx);
                    validationLevel = dc.getDeployXmlValidation();
                }
            }
            catch (ConfigException ce) {
                validationLevel = "full";
            }
        }
        return validationLevel;
    }
}

