/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.backend;

import com.sun.logging.LogDomains;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OptionalPkgDependency {
    private static Hashtable optionalPackageStore = new Hashtable();
    private static Set extDirJars = new LinkedHashSet();
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");

    public static boolean optionalPkgDependencyLogic(Manifest manifest, String archiveUri) {
        String extensionList;
        boolean dependencySatisfied;
        block7: {
            dependencySatisfied = true;
            extensionList = null;
            try {
                extensionList = manifest.getMainAttributes().getValue(Attributes.Name.EXTENSION_LIST);
                logger.fine("extensionList..." + extensionList);
            }
            catch (Exception npe) {
                if (!logger.isLoggable(Level.FINE)) break block7;
                logger.log(Level.FINE, "OptionalPkgDependency : exception occurred ==> " + npe.toString());
            }
        }
        if (extensionList == null) {
            return dependencySatisfied;
        }
        StringTokenizer st = new StringTokenizer(extensionList, " ");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            String extName = manifest.getMainAttributes().getValue(token + "-" + Attributes.Name.EXTENSION_NAME);
            String specVersion = manifest.getMainAttributes().getValue(token + "-" + Attributes.Name.SPECIFICATION_VERSION);
            if (specVersion == null) {
                specVersion = new String("");
            }
            if (!optionalPackageStore.containsKey(extName)) {
                logger.log(Level.WARNING, "enterprise.deployment.backend.optionalpkg.dependency.notexist", new Object[]{extName, archiveUri});
                dependencySatisfied = false;
                continue;
            }
            if ((specVersion.equals("") || !optionalPackageStore.get(extName).toString().equals("")) && specVersion.equals(optionalPackageStore.get(extName).toString())) continue;
            logger.log(Level.WARNING, "enterprise.deployment.backend.optionalpkg.dependency.notexist", new Object[]{extName, archiveUri});
            dependencySatisfied = false;
        }
        if (dependencySatisfied) {
            logger.log(Level.INFO, "enterprise.deployment.backend.optionalpkg.dependency.satisfied", new Object[]{archiveUri});
        }
        return dependencySatisfied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void satisfyOptionalPackageDependencies() {
        String ext_dirStr = new String(System.getProperty("java.ext.dirs"));
        logger.fine("ext_dirStr..." + ext_dirStr);
        Vector<String> ext_dirs = new Vector<String>();
        StringTokenizer st = new StringTokenizer(ext_dirStr, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            logger.log(Level.FINE, "string tokens..." + next);
            ext_dirs.addElement(next);
        }
        for (int v = 0; v < ext_dirs.size(); ++v) {
            File[] optionalPackages;
            File ext_dir = new File((String)ext_dirs.elementAt(v));
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "extension dir..." + ext_dir);
            }
            if ((optionalPackages = ext_dir.listFiles()) == null) continue;
            try {
                JarFile jarFile;
                int i;
                for (i = 0; i < optionalPackages.length; ++i) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "optional package..." + optionalPackages[i]);
                    }
                    if (optionalPackages[i].isDirectory()) continue;
                    jarFile = new JarFile(optionalPackages[i]);
                    Manifest manifest = jarFile.getManifest();
                    jarFile.close();
                    extDirJars.add(optionalPackages[i].toString());
                    if (manifest == null) continue;
                    String extNameOfOptionalPkg = manifest.getMainAttributes().getValue(Attributes.Name.EXTENSION_NAME);
                    logger.fine("extNameOfOptionalPkg..." + extNameOfOptionalPkg);
                    String specVersion = manifest.getMainAttributes().getValue(Attributes.Name.SPECIFICATION_VERSION);
                    logger.fine("specVersion..." + specVersion);
                    if (extNameOfOptionalPkg == null) continue;
                    if (specVersion == null) {
                        logger.log(Level.WARNING, "enterprise.tools.deployment.backend.optionalpkg.dependency.specversion.null", new Object[]{extNameOfOptionalPkg});
                        specVersion = new String("");
                    }
                    optionalPackageStore.put(extNameOfOptionalPkg, specVersion);
                }
                for (i = 0; i < optionalPackages.length; ++i) {
                    if (optionalPackages[i].isDirectory()) continue;
                    jarFile = null;
                    try {
                        jarFile = new JarFile(optionalPackages[i]);
                        Manifest m = jarFile.getManifest();
                        if (m == null) continue;
                        OptionalPkgDependency.optionalPkgDependencyLogic(m, optionalPackages[i].getAbsolutePath());
                        continue;
                    }
                    finally {
                        if (jarFile != null) {
                            jarFile.close();
                        }
                    }
                }
                continue;
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "enterprise.deployment.backend.optionalpkg.dependency.exception", new Object[]{e.getMessage()});
            }
        }
    }

    public static String getExtDirFilesAsClasspath() {
        StringBuffer classpath = new StringBuffer();
        for (String next : extDirJars) {
            if (classpath.length() > 0) {
                classpath.append(File.pathSeparator);
            }
            classpath.append(next);
        }
        return classpath.toString();
    }
}

