/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.phasing;

import com.sun.enterprise.deployment.backend.DeploymentEvent;
import com.sun.enterprise.deployment.backend.DeploymentEventInfo;
import com.sun.enterprise.deployment.backend.DeploymentLogger;
import com.sun.enterprise.deployment.backend.DeploymentRequest;
import com.sun.enterprise.deployment.phasing.DeploymentContext;
import com.sun.enterprise.deployment.phasing.DeploymentPhaseContext;
import com.sun.enterprise.deployment.phasing.ResourcePhase;
import com.sun.enterprise.resource.Resource;
import com.sun.enterprise.resource.ResourcesXMLParser;
import com.sun.enterprise.util.i18n.StringManager;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostResDeletionPhase
extends ResourcePhase {
    public static final Logger sLogger = DeploymentLogger.get();
    private static StringManager localStrings = StringManager.getManager(PostResDeletionPhase.class);

    public PostResDeletionPhase(DeploymentContext deploymentCtx) {
        this.deploymentCtx = deploymentCtx;
        this.name = "postResDeletion";
    }

    @Override
    public void runPhase(DeploymentPhaseContext phaseCtx) {
        block2: {
            try {
                DeploymentRequest req = phaseCtx.getDeploymentRequest();
                this.prePhaseNotify(this.getPrePhaseEvent(req));
                this.doResourceOperation(req);
                this.postPhaseNotify(this.getPostPhaseEvent(req));
                phaseCtx.getDeploymentStatus().setStageStatus(2);
            }
            catch (Exception e) {
                phaseCtx.getDeploymentStatus().setStageStatus(0);
                if (e.getCause() == null) break block2;
                phaseCtx.getDeploymentStatus().setStageException(e.getCause());
                phaseCtx.getDeploymentStatus().setStageStatusMessage(e.getCause().getMessage());
            }
        }
    }

    private DeploymentEvent getPrePhaseEvent(DeploymentRequest req) {
        return new DeploymentEvent(17, new DeploymentEventInfo(req));
    }

    private DeploymentEvent getPostPhaseEvent(DeploymentRequest req) {
        return new DeploymentEvent(18, new DeploymentEventInfo(req));
    }

    @Override
    public void handleRedeployment(List<String> targetList, List<Resource> resourceList) throws Exception {
        this.handleUndeployment(targetList, resourceList);
    }

    @Override
    public void handleDeployment(List<String> targetList, List<Resource> resourceList) throws Exception {
    }

    @Override
    public String getActualAction(String resAction) {
        if (resAction.equals("resDeployment")) {
            return "resNoOp";
        }
        return resAction;
    }

    @Override
    public List<Resource> getRelevantResources(List<Resource> allResources) {
        return ResourcesXMLParser.getNonConnectorResourcesList(allResources, false);
    }
}

