/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DOLLoadingContextFactory {
    private static WebBundleDescriptor defaultWebXMLWbd = null;
    private static boolean isParsingDefaultWebXML = false;
    private static boolean isDefaultWebXMLInitialized = false;
    private static Class dolLoadingContext = null;
    private static final String DLC_CLASS_NAME = "com.sun.enterprise.deployment.backend.DOLLoadingContext";
    private static final String DLC_METHOD_NAME = "initDefaultWebBundleDescriptor";
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");

    private static Class getDOLLoadingContext() {
        try {
            if (dolLoadingContext == null) {
                dolLoadingContext = Class.forName(DLC_CLASS_NAME, true, Thread.currentThread().getContextClassLoader());
            }
        }
        catch (ClassNotFoundException cnfe) {
            _logger.log(Level.WARNING, "enterprise.deployment.class.not.found", new Object[]{DLC_CLASS_NAME});
        }
        return dolLoadingContext;
    }

    public static WebBundleDescriptor getDefaultWebBundleDescriptor() {
        if (defaultWebXMLWbd == null && !isDefaultWebXMLInitialized) {
            DOLLoadingContextFactory.initDefaultWebBundleDescriptor();
        }
        WebBundleDescriptor defaultWebBundleDesc = new WebBundleDescriptor();
        if (defaultWebXMLWbd != null) {
            defaultWebBundleDesc.addWebBundleDescriptor(defaultWebXMLWbd);
        }
        return defaultWebBundleDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initDefaultWebBundleDescriptor() {
        try {
            Class dlcClass = DOLLoadingContextFactory.getDOLLoadingContext();
            Method initWbdMethod = dlcClass.getMethod(DLC_METHOD_NAME, new Class[0]);
            if (initWbdMethod != null) {
                defaultWebXMLWbd = (WebBundleDescriptor)initWbdMethod.invoke((Object)dlcClass, new Object[0]);
            } else {
                _logger.log(Level.WARNING, "enterprise.deployment.method.not.found", new Object[]{DLC_METHOD_NAME});
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, e.getMessage());
            defaultWebXMLWbd = null;
        }
        finally {
            isDefaultWebXMLInitialized = true;
        }
    }

    public static boolean isParsingDefaultWebXML() {
        return isParsingDefaultWebXML;
    }

    public static void setParsingDefaultWebXML(boolean isDefault) {
        isParsingDefaultWebXML = isDefault;
    }
}

