/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics;

import com.sun.enterprise.diagnostics.Defaults;
import com.sun.enterprise.diagnostics.ServiceConfig;
import java.util.HashMap;
import java.util.Map;

public class ServiceConfigFactory {
    private static Map diagnosticServiceConfigs;
    private static Map instanceConfigMap;
    private static ServiceConfig defaultConfig;
    private static ServiceConfigFactory configFactory;

    private ServiceConfigFactory() {
        diagnosticServiceConfigs = new HashMap(5);
        instanceConfigMap = new HashMap(5);
    }

    public static ServiceConfigFactory getInstance() {
        if (configFactory == null) {
            configFactory = new ServiceConfigFactory();
        }
        return configFactory;
    }

    public static ServiceConfig getDefaultServiceConfig() {
        if (defaultConfig == null) {
            defaultConfig = new ServiceConfig(true, true, true, true, true, true, Defaults.MIN_LOG_LEVEL, 500, Defaults.LOG_FILE, null, null);
            return defaultConfig;
        }
        return null;
    }

    public ServiceConfig getServiceConfig(String instanceName) {
        if (instanceName != null) {
            String configName = (String)instanceConfigMap.get(instanceName);
            return (ServiceConfig)diagnosticServiceConfigs.get(configName);
        }
        return null;
    }

    public ServiceConfig getServiceConfig(boolean local, String repositoryRoot, String instanceName) {
        if (repositoryRoot != null && instanceName != null) {
            try {
                ServiceConfig config = new ServiceConfig(local, repositoryRoot, instanceName);
                return config;
            }
            catch (Exception de) {
                return ServiceConfigFactory.getDefaultServiceConfig();
            }
        }
        return null;
    }
}

