/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.collect;

import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.DiagnosticException;
import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.collect.WritableData;
import com.sun.enterprise.diagnostics.collect.WritableDataImpl;
import com.sun.enterprise.diagnostics.util.DiagnosticServiceHelper;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChecksumCollector
implements Collector {
    private String source;
    private String destFolder;
    private String destFile;
    private BufferedWriter writer;
    private WritableData dataObj;
    private static final String BIN_FOLDER = File.separator + "bin";
    private static final String LIB_FOLDER = File.separator + "lib";
    private static final String JAR_EXT = ".jar";
    private static final String DLL_EXT = "*.dll";
    private static final String SO_EXT = "*.so";
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");

    public ChecksumCollector(String source, String destFolder) {
        this.destFolder = destFolder;
        this.source = source;
        this.dataObj = new WritableDataImpl(source, "checksum");
    }

    @Override
    public Data capture() throws DiagnosticException {
        this.dataObj.addRow(Arrays.asList("Name", "Length", "Checksum"));
        this.captureChecksum(this.source + LIB_FOLDER, this.getFilter());
        this.captureChecksum(this.source + BIN_FOLDER, null);
        return this.dataObj;
    }

    private void captureChecksum(String sourceName, FilenameFilter filter) throws DiagnosticException {
        File fileObj = new File(sourceName);
        String[] fileNames = fileObj.list(filter);
        if (fileNames != null) {
            int length = fileNames.length;
            for (int i = 0; i < length; ++i) {
                this.dataObj.addRow(this.generateCRC32Checksum(sourceName, fileNames[i]));
            }
        }
    }

    private List<String> generateCRC32Checksum(String parent, String fileName) throws DiagnosticException {
        try {
            String file = parent + File.separator + fileName;
            ArrayList<String> checksumInfo = new ArrayList<String>(3);
            CRC32 crc32 = new CRC32();
            int length = 0;
            BufferedInputStream fileinputstream = new BufferedInputStream(new FileInputStream(new File(file)));
            CheckedInputStream checkedinputstream = new CheckedInputStream(fileinputstream, crc32);
            while (checkedinputstream.read() != -1) {
                ++length;
            }
            long cksum = crc32.getValue();
            fileinputstream.close();
            fileinputstream = null;
            crc32 = null;
            checksumInfo.add(fileName);
            checksumInfo.add(Integer.toString(length));
            checksumInfo.add(Long.toString(cksum));
            return checksumInfo;
        }
        catch (Exception e) {
            logger.log(Level.FINE, "diagnostic-service.compute_checksum_failed", new Object[]{fileName, e.getMessage()});
            return null;
        }
    }

    private FilenameFilter getFilter() {
        final String[] exts = this.isSolaris() ? new String[]{JAR_EXT, SO_EXT} : new String[]{JAR_EXT, DLL_EXT};
        return new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(exts[0]) || name.endsWith(exts[1]);
            }
        };
    }

    private boolean isSolaris() {
        return DiagnosticServiceHelper.isSolaris();
    }

    private void writeToFile(List<String> checksumInfo) throws DiagnosticException {
        if (checksumInfo != null) {
            try {
                this.writer.write("\n");
                for (String entry : checksumInfo) {
                    this.writer.write(entry + "\t");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

