/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.collect;

import com.sun.enterprise.diagnostics.Data;
import com.sun.enterprise.diagnostics.ReportConfig;
import com.sun.enterprise.diagnostics.ReportTarget;
import com.sun.enterprise.diagnostics.ServiceConfig;
import com.sun.enterprise.diagnostics.collect.AppInfoCollector;
import com.sun.enterprise.diagnostics.collect.ChecksumCollector;
import com.sun.enterprise.diagnostics.collect.Collector;
import com.sun.enterprise.diagnostics.collect.ConfigCollector;
import com.sun.enterprise.diagnostics.collect.CustomerInputCollector;
import com.sun.enterprise.diagnostics.collect.DomainXMLVerificationCollector;
import com.sun.enterprise.diagnostics.collect.FilesCollector;
import com.sun.enterprise.diagnostics.collect.LogCollector;
import com.sun.enterprise.diagnostics.collect.MonitoringInfoCollector;
import com.sun.enterprise.diagnostics.collect.SystemInfoCollector;
import com.sun.enterprise.diagnostics.collect.WritableDataImpl;
import com.sun.enterprise.diagnostics.util.DiagnosticServiceHelper;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Harvester
implements Collector {
    protected ReportConfig config;
    protected ReportTarget target;
    private List<Collector> collectors;
    private ChecksumCollector checksumCollector;
    private SystemInfoCollector systemInfoCollector;
    private FilesCollector installationLogCollector;
    protected static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.admin");

    public Harvester(ReportConfig config) {
        if (config != null) {
            this.config = config;
            this.target = config.getTarget();
        }
    }

    @Override
    public Data capture() {
        WritableDataImpl dataImpl = new WritableDataImpl();
        Iterator<Collector> list = this.collectors.iterator();
        while (list.hasNext()) {
            Data dataObj = this.capture(list.next());
            if (dataObj == null) continue;
            dataImpl.addChild(dataObj);
        }
        return dataImpl;
    }

    public void addCollector(Collector obj) {
        if (obj != null) {
            this.collectors.add(obj);
        }
    }

    public abstract void addRemoteCollectors();

    public void initialize() {
        this.collectors = new ArrayList<Collector>(8);
        this.addCustomerInputCollector();
        this.initializeInstanceCollectors(this.config.getInstanceConfigurations());
        this.addRemoteCollectors();
    }

    protected void initializeInstanceCollectors(Iterator<ServiceConfig> iterator) {
        while (iterator.hasNext()) {
            LogCollector collectorObj;
            ServiceConfig serviceConfig = iterator.next();
            String repositoryDir = serviceConfig.getRepositoryDir();
            String reportDir = this.target.getIntermediateReportDir();
            if (!serviceConfig.getInstanceName().equals("server")) {
                reportDir = reportDir + File.separator + serviceConfig.getInstanceName();
            }
            if (serviceConfig.isCaptureChecksumEnabled()) {
                this.addInstallationCheckSumCollector();
                ChecksumCollector collector = new ChecksumCollector(repositoryDir, reportDir);
                this.addCollector(collector);
            }
            if (serviceConfig.isVerifyDomainEnabled()) {
                DomainXMLVerificationCollector domainXMLCollector = new DomainXMLVerificationCollector(repositoryDir, reportDir);
                this.addCollector(domainXMLCollector);
            }
            this.addCollector(new ConfigCollector(repositoryDir, reportDir));
            if (serviceConfig.getMinLogLevel() != Level.OFF.intValue() && (collectorObj = new LogCollector(this.config.getCLIOptions().getStartDate(), this.config.getCLIOptions().getEndDate(), reportDir, serviceConfig)) != null) {
                this.addCollector(collectorObj);
            }
            if (serviceConfig.isCaptureAppDDEnabled()) {
                this.addCollector(new AppInfoCollector(repositoryDir, reportDir));
            }
            this.addFilesCollector(serviceConfig.isCaptureInstallLogEnabled(), "installation log");
            this.addSystemInfoCollector(serviceConfig.isCaptureSystemInfoEnabled());
        }
    }

    protected void addFilesCollector(boolean captureInstallationLog, String dataType) {
        if (captureInstallationLog && this.installationLogCollector == null) {
            String installationRoot = DiagnosticServiceHelper.getInstallationRoot();
            ArrayList<String> files = new ArrayList<String>(2);
            String[] logFiles = new File(installationRoot).list(new FilenameFilter(){

                public boolean accept(File folder, String name) {
                    return name.contains("Install_Application_Server") || name.contains("Sun_Java_System_Application_Server");
                }
            });
            files.addAll(Arrays.asList(logFiles));
            this.installationLogCollector = new FilesCollector(installationRoot, this.target.getIntermediateReportDir(), files, dataType);
            this.addCollector(this.installationLogCollector);
        }
    }

    protected void addCustomerInputCollector() {
        if (this.config.getCLIOptions().getCustomerInput() != null || this.config.getCLIOptions().getCustomerInputFile() != null) {
            this.addCollector(new CustomerInputCollector(this.config.getCLIOptions().getCustomerInputFile(), this.config.getCLIOptions().getCustomerInput(), this.target.getIntermediateReportDir(), this.config.getExecutionContext().isLocal()));
        }
    }

    protected void addInstallationCheckSumCollector() {
        if (this.checksumCollector == null) {
            this.checksumCollector = new ChecksumCollector(DiagnosticServiceHelper.getInstallationRoot(), this.target.getIntermediateReportDir());
            this.addCollector(this.checksumCollector);
        }
    }

    protected void addMonitoringInfoCollectors(String path, List<String> instances) {
        String reportDir = this.target.getIntermediateReportDir();
        for (String instanceName : instances) {
            this.addMonitoringInfoCollector(reportDir, path, instanceName);
        }
    }

    protected void addMonitoringInfoCollector(String reportDir, String path, String instanceName) {
        if (path == null) {
            path = "";
        }
        reportDir = reportDir + File.separator + path + File.separator + instanceName;
        this.addCollector(new MonitoringInfoCollector(path, instanceName, reportDir));
    }

    protected void addSystemInfoCollector(boolean captureSystemInfoEnabled) {
        if (captureSystemInfoEnabled) {
            String reportDir = this.config.getTarget().getIntermediateReportDir();
            if (this.systemInfoCollector == null) {
                this.systemInfoCollector = new SystemInfoCollector(reportDir);
                this.addCollector(this.systemInfoCollector);
            }
        }
    }

    private Data capture(Collector obj) {
        try {
            return obj.capture();
        }
        catch (Throwable de) {
            logger.log(Level.WARNING, "diagnostic-service.error_collecting_data", new Object[]{de.getMessage()});
            return null;
        }
    }
}

