/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.report.html;

import com.sun.enterprise.diagnostics.report.html.Attribute;
import com.sun.enterprise.diagnostics.report.html.CSSElement;
import com.sun.enterprise.diagnostics.report.html.Element;
import com.sun.enterprise.diagnostics.report.html.HTMLElement;
import com.sun.enterprise.diagnostics.report.html.TD;
import com.sun.enterprise.diagnostics.report.html.TH;
import com.sun.enterprise.diagnostics.report.html.TR;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
extends HTMLElement {
    private int border;
    private int cellSpacing;
    private String alignment;
    private float width;
    private boolean absoluteWidth;
    public static final String ALIGN_LEFT = "LEFT";
    public static final String ALIGN_CENTER = "CENTER";
    public static final String ALIGN_RIGHT = "RIGHT";

    public Table() {
        super("table");
    }

    public Table(int border, int cellSpacing) {
        this();
        this.addAttribute("border", String.valueOf(border));
        this.addAttribute("cellspacing", String.valueOf(cellSpacing));
    }

    public void setBorder(int border) {
        this.border = border;
        this.setAttribute("border", String.valueOf(border));
    }

    public void setCellSpacing(int cellSpacing) {
        this.cellSpacing = cellSpacing;
        this.setAttribute("cellspacing", String.valueOf(cellSpacing));
    }

    public void setAlignment(String alignment) {
        this.alignment = alignment;
        this.setAttribute("alignment", alignment);
    }

    public void setWidth(float width, boolean absolute) {
        this.width = width;
        this.absoluteWidth = absolute;
        if (absolute) {
            this.setAttribute("width", String.valueOf(width));
        } else {
            this.setAttribute("width", String.valueOf(width) + "%");
        }
    }

    private void setAttribute(String property, String value) {
        if (property != null && value != null) {
            List<Attribute> attributes = this.getAttributes(property);
            if (attributes.size() == 0) {
                this.addAttribute(property, value);
            } else {
                Attribute attribute = attributes.get(0);
                attribute.setValue(value);
            }
        }
    }

    public int getBorder() {
        return this.border;
    }

    public int getCellSpacing() {
        return this.cellSpacing;
    }

    public String getAlignment() {
        return this.alignment;
    }

    public float getWidth() {
        return this.width;
    }

    public boolean isAbsoluteWidth() {
        return this.absoluteWidth;
    }

    public TR addRow(Iterator<String> values, boolean header, String cssClass) {
        TR row = new TR();
        while (values.hasNext()) {
            CSSElement tableData = null;
            tableData = header ? new TH() : new TD();
            tableData.addText(values.next());
            this.setCSSClass(tableData, cssClass);
            row.add(tableData);
        }
        this.add(row);
        return row;
    }

    public TR addRow(ArrayList elements, String cssClass) {
        TR row = new TR();
        for (int i = 0; i < elements.size(); ++i) {
            TD tableData = new TD();
            tableData.add((Element)elements.get(i));
            this.setCSSClass(tableData, cssClass);
            row.add(tableData);
        }
        this.add(row);
        return row;
    }

    private void setCSSClass(CSSElement element, String cssClass) {
        if (cssClass != null) {
            element.setCSSClass(cssClass);
        }
    }
}

