/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.diagnostics.util;

import com.sun.enterprise.diagnostics.util.NOOPHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XmlUtils {
    public static Document loadXML(String srcXmlFile, String dtdFileName) throws SAXException, IOException, ParserConfigurationException {
        Document doc = null;
        FileInputStream in = null;
        in = new FileInputStream(srcXmlFile);
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        docBuilder.setEntityResolver(new NOOPHandler(dtdFileName));
        doc = docBuilder.parse(in);
        if (in != null) {
            in.close();
        }
        return doc;
    }

    public static void getAttributes(Node element, String srchStr, List list) {
        if (element != null && srchStr != null) {
            if (list == null) {
                list = new ArrayList<String>(5);
            }
            NodeList children = element.getChildNodes();
            int noOfChildren = children.getLength();
            for (int i = 0; i < noOfChildren; ++i) {
                Node child = children.item(i);
                String childName = child.getLocalName();
                NamedNodeMap attrs = null;
                attrs = child.getAttributes();
                if (attrs != null) {
                    for (int j = 0; j < attrs.getLength(); ++j) {
                        Attr attr = (Attr)attrs.item(j);
                        if (attr.getName().toLowerCase().indexOf(srchStr) == -1) continue;
                        String attrName = XmlUtils.getParentNodeName(child);
                        list.add(attrName + File.separator + attr);
                    }
                }
                XmlUtils.getAttributes(child, srchStr, list);
            }
        }
    }

    private static String getParentNodeName(Node child) {
        if (child != null) {
            NamedNodeMap attrs;
            String name = child.getNodeName();
            Node parent = child.getParentNode();
            if (parent != null && parent.getNodeType() == 1) {
                name = XmlUtils.getParentNodeName(parent) + File.separator + name;
            }
            if ((attrs = child.getAttributes()) != null) {
                String nameAttribute = null;
                for (int j = 0; j < attrs.getLength(); ++j) {
                    Attr attr = (Attr)attrs.item(j);
                    if (attr.getName().toLowerCase().indexOf("name") == -1) continue;
                    nameAttribute = attr.getValue();
                }
                if (nameAttribute != null) {
                    name = name + "=" + nameAttribute;
                }
            }
            return name;
        }
        return "";
    }

    public static void attrSearchReplace(Document doc, String srchStr, String rplStr) {
        Element m_root = null;
        Node child = null;
        m_root = doc.getDocumentElement();
        for (child = m_root.getFirstChild(); child != null; child = child.getNextSibling()) {
            NamedNodeMap attrs = null;
            attrs = child.getAttributes();
            if (attrs == null) continue;
            for (int j = 0; j < attrs.getLength(); ++j) {
                Attr attr = (Attr)attrs.item(j);
                if (attr.getName().toLowerCase().indexOf(srchStr) == -1) continue;
                attr.setValue(rplStr);
            }
        }
    }

    public static void attrSearchReplace(Node element, String srchStr, String replaceString) {
        if (element != null) {
            NodeList children = element.getChildNodes();
            int noOfChildren = children.getLength();
            for (int i = 0; i < noOfChildren; ++i) {
                Node child = children.item(i);
                NamedNodeMap attrs = null;
                attrs = child.getAttributes();
                if (attrs != null) {
                    for (int j = 0; j < attrs.getLength(); ++j) {
                        Attr attr = (Attr)attrs.item(j);
                        if (attr.getName().toLowerCase().indexOf(srchStr) == -1) continue;
                        attr.setValue(replaceString);
                    }
                }
                XmlUtils.attrSearchReplace(child, srchStr, replaceString);
            }
        }
    }

    public static void copyXMLFile(Document srcDoc, String destFile) throws IOException, TransformerConfigurationException, TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = tFactory.newTransformer();
        DOMSource source = new DOMSource(srcDoc);
        File destFileObj = new File(destFile);
        if (!destFileObj.getParentFile().exists()) {
            destFileObj.getParentFile().mkdirs();
        }
        FileWriter destFileWriter = new FileWriter(destFile);
        StreamResult result = new StreamResult(destFileWriter);
        transformer.transform(source, result);
    }
}

