/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jbi.serviceengine.install;

import com.sun.enterprise.jbi.serviceengine.ServiceEngineException;
import com.sun.enterprise.jbi.serviceengine.install.Installer;
import com.sun.enterprise.jbi.serviceengine.install.MBeanHelper;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class InstallerImpl
implements Installer {
    private static final String ADD_COMPONENT_OPERATION = "addComponent";
    private static final String INSTALL_COMPONENT_OPERATION = "installComponent";
    private static final String REMOVE_COMPONENT_OPERATION = "removeComponent";
    private static final String UNINSTALL_COMPONENT_OPERATION = "uninstallComponent";
    private static final String START_COMPONENT_OPERATION = "startComponent";
    private static final String STOP_COMPONENT_OPERATION = "stopComponent";
    private String componentName = null;
    private String SE_BUNDLE = "lib/addons/jbi/appserv-jbise.jar";
    private String JBI_FOLDER = "jbi";
    private MBeanHelper mbeanHelper;
    private String jbiInstanceName;
    private boolean jbiInstalled = false;
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system");

    public InstallerImpl(MBeanHelper mbeanHelper) {
        this.mbeanHelper = mbeanHelper;
        String installationRoot = ApplicationServer.getServerContext().getInstallRoot();
        String jbiInstallationDir = installationRoot + File.separator + this.JBI_FOLDER;
        boolean mbeanRegistered = false;
        try {
            mbeanRegistered = mbeanHelper.isMBeanRegistered("com.sun.jbi.esb:ServiceType=Installation");
        }
        catch (ServiceEngineException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        this.jbiInstalled = new File(jbiInstallationDir).exists() && mbeanRegistered;
    }

    public boolean isJBIInstalled() {
        return this.jbiInstalled;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String install(String zipFilePath) throws ServiceEngineException {
        String result = null;
        if (zipFilePath == null) {
            zipFilePath = this.getServiceEngineBundle();
            this.log(Level.FINE, "Java EE Service Engine Bundle :", zipFilePath);
            try {
                ObjectName objName = this.mbeanHelper.getObjectName("com.sun.jbi.esb:ServiceType=Installation");
                this.log(Level.FINEST, "installation_service_log_name", objName.toString());
                result = (String)this.mbeanHelper.invokeMBeanOperation(objName, ADD_COMPONENT_OPERATION, new Object[]{zipFilePath}, new String[]{"java.lang.String"});
                this.log(Level.FINEST, " Status of addComponent ", result);
                result = (String)this.mbeanHelper.invokeMBeanOperation(objName, INSTALL_COMPONENT_OPERATION, new Object[]{this.componentName}, new String[]{"java.lang.String"});
                this.log(Level.FINEST, " Status of installComponent ", result);
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "Error occurred during installation of Java EE Service Engine", e.getMessage());
            }
        }
        return result;
    }

    public void start() throws ServiceEngineException {
        try {
            ObjectName objName = this.mbeanHelper.getObjectName("com.sun.jbi.esb:ServiceType=LifeCycle");
            this.log(Level.FINEST, "lifecycle_service_obj_name", objName.toString());
            String result = (String)this.mbeanHelper.invokeMBeanOperation(objName, START_COMPONENT_OPERATION, new Object[]{this.componentName}, new String[]{"java.lang.String"});
            this.log(Level.FINEST, "Start Component Status", result);
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Error occurred during startup of Java EE Service Engine", e.getMessage());
        }
    }

    public boolean isComponentInstalled() {
        try {
            String domainDir = ApplicationServer.getServerContext().getInstanceEnvironment().getInstancesRoot();
            String fs = File.separator;
            String javaeeSEDir = domainDir + fs + "jbi" + fs + "engines" + fs + "JavaEEServiceEngine";
            if (!new File(javaeeSEDir).exists()) {
                return false;
            }
        }
        catch (Exception e) {
            this.log(Level.WARNING, "Exception occurred while getting component by name", e.getMessage());
            return false;
        }
        return true;
    }

    public void stop() throws ServiceEngineException {
        try {
            ObjectName objName = this.mbeanHelper.getObjectName("com.sun.jbi.esb:ServiceType=LifeCycle");
            this.log(Level.FINEST, "lifecycle_service_obj_name", objName.toString());
            String result = (String)this.mbeanHelper.invokeMBeanOperation(objName, STOP_COMPONENT_OPERATION, new Object[]{this.componentName}, new String[]{"java.lang.String"});
            this.log(Level.FINEST, "Start Component Status", result);
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Error occurred during stopping of Java EE Service Engine", e.getMessage());
        }
    }

    public void uninstall() throws ServiceEngineException {
        try {
            ObjectName objName = this.mbeanHelper.getObjectName("com.sun.jbi.esb:ServiceType=Installation");
            this.log(Level.FINEST, "installation_service_log_name", objName.toString());
            String result = (String)this.mbeanHelper.invokeMBeanOperation(objName, UNINSTALL_COMPONENT_OPERATION, new Object[]{this.componentName}, new String[]{"java.lang.String"});
            this.log(Level.FINEST, " Status of uninstallComponent ", result);
            result = (String)this.mbeanHelper.invokeMBeanOperation(objName, REMOVE_COMPONENT_OPERATION, new Object[]{this.componentName}, new String[]{"java.lang.String"});
            this.log(Level.FINEST, " Status of removeComponent ", result);
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "Error occurred during uninstallation of Java EE Service Engine", e.getMessage());
        }
    }

    private String getServiceEngineBundle() {
        String seBundle = System.getProperty("com.sun.aas.installRoot") + File.separator + this.SE_BUNDLE;
        return seBundle;
    }

    private void log(Level level, String property, String logString) {
        logger.log(level, property, logString);
    }
}

