/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.model;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.management.model.J2EEEventProviderMOMdl;
import com.sun.enterprise.management.util.J2EEModuleUtil;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class J2EEDomainMdl
extends J2EEEventProviderMOMdl
implements NotificationListener {
    public static String DOMAINNAME;
    private static ObjectName jmImpl;
    private boolean debug = false;
    private static String MANAGED_OBJECT_TYPE;
    private String[] eventTypes = new String[]{"j2ee.object.created", "j2ee.object.deleted"};

    public J2EEDomainMdl() {
        super(DOMAINNAME, false, false);
        try {
            this.getMBeanServer().addNotificationListener(jmImpl, this, null, (Object)"J2EEDomain");
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
    }

    public J2EEDomainMdl(String domainname) {
        super(domainname, false, false);
        DOMAINNAME = domainname;
        try {
            this.getMBeanServer().addNotificationListener(jmImpl, this, null, (Object)"J2EEDomain");
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
    }

    public J2EEDomainMdl(String domainname, String serverName) {
        super(domainname, serverName, false, false);
        DOMAINNAME = domainname;
        try {
            this.getMBeanServer().addNotificationListener(jmImpl, this, null, (Object)"J2EEDomain");
        }
        catch (InstanceNotFoundException e) {
            e.printStackTrace();
        }
    }

    public J2EEDomainMdl(String[] location) {
        this(location[0]);
    }

    public String[] getservers() {
        Set servers = this.findNames("j2eeType=J2EEServer");
        Iterator it = servers.iterator();
        String[] ret = new String[servers.size()];
        int i = 0;
        while (it.hasNext()) {
            ret[i++] = ((ObjectName)it.next()).toString();
        }
        return ret;
    }

    public String[] geteventTypes() {
        return this.eventTypes;
    }

    public void handleNotification(Notification n, Object handback) {
        if (this.debug) {
            System.out.println(handback);
            System.out.println("message: " + n.getMessage());
            System.out.println("sequence: " + n.getSequenceNumber());
            System.out.println("source: " + n.getSource());
            System.out.println("timestamp: " + n.getTimeStamp());
            System.out.println("type: " + n.getType());
            System.out.println("user data: " + n.getUserData());
            System.out.println("");
        }
        if (n instanceof MBeanServerNotification) {
            MBeanServerNotification n2 = null;
            if (n.getType().equalsIgnoreCase("jmx.mbean.registered")) {
                ObjectName oname;
                block13: {
                    oname = ((MBeanServerNotification)n).getMBeanName();
                    if (this.debug) {
                        System.out.println("MBean name: " + oname);
                    }
                    if (!oname.getKeyProperty("name").equals(this.getname())) {
                        try {
                            Boolean b = (Boolean)this.getMEJBUtility().getAttribute(oname, "eventProvider");
                            if (b.booleanValue()) {
                                if (this.debug) {
                                    System.out.println("J2EEDomain adding myself as listener to " + oname);
                                }
                                this.getMBeanServer().addNotificationListener(oname, this, null, (Object)this.getname());
                            }
                        }
                        catch (Exception e) {
                            if (!this.debug) break block13;
                            e.printStackTrace();
                        }
                    }
                }
                n2 = new MBeanServerNotification("j2ee.object.created", (Object)this.getobjectName(), n.getSequenceNumber(), oname);
            } else if (n.getType().equalsIgnoreCase("jmx.mbean.unregistered")) {
                n2 = new MBeanServerNotification("j2ee.object.deleted", (Object)this.getobjectName(), n.getSequenceNumber(), ((MBeanServerNotification)n).getMBeanName());
            }
            if (n2 != null) {
                this.sendNotification(n2);
                return;
            }
        }
        if (this.debug) {
            System.out.println("Forwarding original notification " + n);
        }
        this.sendNotification(n);
    }

    public String getj2eeType() {
        return MANAGED_OBJECT_TYPE;
    }

    public String getobjectName() {
        Set s = this.findNames("j2eeType=" + this.getj2eeType() + ",name=" + DOMAINNAME);
        Object[] objs = s.toArray();
        if (objs.length > 0) {
            String name = ((ObjectName)objs[0]).toString();
            return name;
        }
        return null;
    }

    public String getapplicationServerFullVersion() {
        return Version.getFullVersion();
    }

    public String getapplicationServerVersion() {
        return Version.getVersion();
    }

    static {
        try {
            DOMAINNAME = J2EEModuleUtil.getDomainName();
            jmImpl = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (Exception e) {
            DOMAINNAME = "com.sun.appserv";
        }
        MANAGED_OBJECT_TYPE = "J2EEDomain";
    }
}

