/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.management.model;

import com.sun.appserv.management.ext.wsmgmt.MessageTrace;
import com.sun.appserv.management.util.misc.TypeCast;
import com.sun.enterprise.admin.wsmgmt.msg.MessageTraceMgr;
import com.sun.enterprise.admin.wsmgmt.stats.spi.StatsProviderManager;
import com.sun.enterprise.admin.wsmgmt.stats.spi.WebServiceEndpointStatsProvider;
import com.sun.enterprise.management.model.J2EEManagedObjectMdl;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebServiceEndpointMdl
extends J2EEManagedObjectMdl {
    private static String MANAGED_OBJECT_TYPE = "WebServiceEndpoint";
    protected static String WEB_MBEAN = "ServletWebServiceEndpoint";
    protected static String EJB_MBEAN = "EJBWebServiceEndpoint";
    private String moduleName = null;
    private String registrationName = null;
    private String applicationName = null;
    private String epName = null;
    private boolean isEjb = false;
    private boolean isStandAlone = false;
    private String mbeanName = null;

    WebServiceEndpointMdl(String name, String mName, String regName, boolean isVirtual, boolean isejb) {
        super(name, false, false, false);
        this.moduleName = mName;
        this.applicationName = regName;
        this.registrationName = regName;
        this.isStandAlone = isVirtual;
        this.epName = name;
        this.isEjb = isejb;
        this.mbeanName = isejb ? EJB_MBEAN : WEB_MBEAN;
    }

    WebServiceEndpointMdl(String name, String moduleName, String regName, String serverName, boolean isVirtual, boolean isejb) {
        super(name, serverName, false, false, false);
        this.moduleName = moduleName;
        this.applicationName = regName;
        this.registrationName = regName;
        this.epName = name;
        this.isEjb = isejb;
        this.mbeanName = isejb ? EJB_MBEAN : WEB_MBEAN;
        this.isStandAlone = isVirtual;
    }

    public String getModule() {
        return this.moduleName;
    }

    public String getJ2EEApplication() {
        return this.applicationName;
    }

    public String getImplementationType() {
        if (this.isEjb) {
            return "EJB";
        }
        return "SERVLET";
    }

    public Map<String, Serializable>[] getMessagesInHistory() {
        String partialEpName = null;
        partialEpName = this.isStandAlone ? this.epName : this.moduleName + "#" + this.epName;
        Map[] maps = null;
        MessageTrace[] result = MessageTraceMgr.getInstance().getMessages(this.registrationName, partialEpName);
        if (result == null) {
            return null;
        }
        if (result.length > 0) {
            maps = new Map[result.length];
            for (int idx = 0; idx < result.length; ++idx) {
                maps[idx] = result[idx].asMap();
                TypeCast.checkSerializable(maps[idx]);
            }
        }
        return maps;
    }

    @Override
    public String getobjectName() {
        Set s = null;
        s = this.isEjb ? this.findNames("j2eeType=" + this.getj2eeType() + ",name=" + this.epName + ",EJBModule=" + this.getModule() + ",J2EEApplication=" + this.getJ2EEApplication() + ",J2EEServer=" + this.getJ2EEServer()) : this.findNames("j2eeType=" + this.getj2eeType() + ",name=" + this.epName + ",WebModule=" + this.getModule() + ",J2EEApplication=" + this.getJ2EEApplication() + ",J2EEServer=" + this.getJ2EEServer());
        Object[] objs = s.toArray();
        if (objs.length > 0) {
            String name = ((ObjectName)objs[0]).toString();
            return name;
        }
        return null;
    }

    @Override
    public String getj2eeType() {
        return MANAGED_OBJECT_TYPE;
    }

    public abstract String getMBeanName();

    private WebServiceEndpointStatsProvider getWSProvider() {
        String NS = "#";
        StatsProviderManager spMgr = StatsProviderManager.getInstance();
        String fqName = null;
        fqName = !this.isStandAlone ? this.registrationName + "#" + this.moduleName + "#" + this.epName : this.registrationName + "#" + this.epName;
        WebServiceEndpointStatsProvider provider = spMgr.getEndpointStatsProvider(fqName);
        return provider;
    }

    public void resetStats() {
        WebServiceEndpointStatsProvider provider = this.getWSProvider();
        if (provider != null) {
            provider.reset();
        }
    }

    public long getLastResetTime() {
        long resetTime = 0L;
        WebServiceEndpointStatsProvider provider = this.getWSProvider();
        if (provider != null) {
            resetTime = provider.getLastResetTime();
        }
        return resetTime;
    }
}

