/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.AbstractConnectorAllocator;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.ConnectorXAResource;
import com.sun.enterprise.resource.LocalTxConnectionEventListener;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import java.util.logging.Level;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;

public class LocalTxConnectorAllocator
extends AbstractConnectorAllocator {
    public LocalTxConnectorAllocator(PoolManager poolMgr, ManagedConnectionFactory mcf, ResourceSpec spec, Subject subject, ConnectionRequestInfo reqInfo, ClientSecurityInfo info, ConnectorDescriptor desc) {
        super(poolMgr, mcf, spec, subject, reqInfo, info, desc);
    }

    public ResourceHandle createResource() throws PoolingException {
        try {
            ManagedConnection mc = this.mcf.createManagedConnection(this.subject, this.reqInfo);
            ResourceHandle resource = new ResourceHandle(mc, this.spec, this, this.info);
            LocalTxConnectionEventListener l = new LocalTxConnectionEventListener(resource);
            mc.addConnectionEventListener((ConnectionEventListener)l);
            resource.setListener(l);
            ConnectorXAResource xares = new ConnectorXAResource(resource, this.spec, this, this.info);
            resource.fillInResourceObjects(null, xares);
            return resource;
        }
        catch (ResourceException ex) {
            _logger.log(Level.WARNING, "poolmgr.create_resource_error", ex.getMessage());
            _logger.log(Level.FINE, "Resource Exception while creating resource", ex);
            if (ex.getLinkedException() != null) {
                _logger.log(Level.WARNING, "poolmgr.create_resource_error", ex.getLinkedException().getMessage());
            }
            throw new PoolingException((Exception)((Object)ex));
        }
    }

    public void fillInResourceObjects(ResourceHandle resource) throws PoolingException {
        try {
            ManagedConnection mc = (ManagedConnection)resource.getResource();
            Object con = mc.getConnection(this.subject, this.reqInfo);
            ConnectorXAResource xares = (ConnectorXAResource)resource.getXAResource();
            xares.setUserHandle(con);
            resource.fillInResourceObjects(con, xares);
        }
        catch (ResourceException ex) {
            throw new PoolingException((Exception)((Object)ex));
        }
    }

    public void destroyResource(ResourceHandle resource) throws PoolingException {
        try {
            ManagedConnection mc = (ManagedConnection)resource.getResource();
            ConnectorXAResource.freeListener(mc);
            mc.destroy();
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("destroyResource for LocalTxConnectorAllocator done");
            }
        }
        catch (Exception ex) {
            _logger.log(Level.WARNING, ex.getMessage());
            throw new PoolingException(ex);
        }
    }

    public boolean shareableWithinComponent() {
        return true;
    }
}

