/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.monitor;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.ConnectorConnectionPoolStats;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorConstants;
import com.sun.enterprise.resource.MonitorableResourcePool;
import com.sun.enterprise.resource.ResourcePool;
import com.sun.enterprise.resource.monitor.ConnectorConnectionPoolStatsImpl;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ResourcesUtil;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.Stats;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorPoolMonitoringLevelListener
implements MonitoringLevelListener {
    private ResourcesUtil resUtil_;
    private PoolManager poolManager_;
    private MonitoringRegistry registry_;
    private static final MonitoringLevel OFF = MonitoringLevel.OFF;
    private static final MonitoringLevel HIGH = MonitoringLevel.HIGH;
    private static final MonitoringLevel LOW = MonitoringLevel.LOW;
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public void setLevel(MonitoringLevel level) {
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, Stats handback) {
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, MonitoredObjectType type) {
        if (from == to) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ServerContext ctxt = ApplicationServer.getServerContext();
                if (ctxt != null) {
                    ConnectorPoolMonitoringLevelListener.this.registry_ = ctxt.getMonitoringRegistry();
                }
                return null;
            }
        });
        if ((from == OFF || from == LOW) && to == HIGH) {
            this.logFine("Changing level from " + from + "  to HIGH");
            this.transitionToHigh();
        }
        if ((from == HIGH || from == LOW) && to == OFF) {
            this.logFine("Switching level from " + from + " to OFF");
            this.switchOffMonitoring();
        }
        if ((from == OFF || from == HIGH) && to == LOW) {
            this.logFine("Changing level from " + from + " to LOW");
            this.transitionToLow();
        }
    }

    protected String getRAName(String resourceAdapterName) {
        int delimIdx = resourceAdapterName.indexOf("#");
        if (delimIdx == -1) {
            return resourceAdapterName;
        }
        return resourceAdapterName.substring(delimIdx + 1);
    }

    protected String getAppName(String resourceAdapterName) {
        int delimIdx = resourceAdapterName.indexOf("#");
        if (delimIdx == -1) {
            return null;
        }
        return resourceAdapterName.substring(0, delimIdx);
    }

    private Map<ConnectorConnectionPool, MonitorableResourcePool> getPoolMap() {
        ResourcesUtil resUtil = ResourcesUtil.getInstance();
        ConnectorConnectionPool[] cp = resUtil.getConnectorConnectionPools();
        if (cp == null) {
            return null;
        }
        HashMap<ConnectorConnectionPool, MonitorableResourcePool> poolMap = new HashMap<ConnectorConnectionPool, MonitorableResourcePool>();
        ConcurrentHashMap allPools = this.getPoolManager().getPoolTable();
        for (int i = 0; i < cp.length; ++i) {
            ResourcePool p;
            if (cp[i].getName().equalsIgnoreCase(ConnectorConstants.DEFAULT_JMS_ADAPTER) || (p = (ResourcePool)allPools.get(cp[i].getName())) == null || !(p instanceof MonitorableResourcePool)) continue;
            poolMap.put(cp[i], (MonitorableResourcePool)p);
        }
        return poolMap;
    }

    private PoolManager getPoolManager() {
        return Switch.getSwitch().getPoolManager();
    }

    private void transitionToHigh() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Map poolMap = ConnectorPoolMonitoringLevelListener.this.getPoolMap();
                if (poolMap == null) {
                    return null;
                }
                for (ConnectorConnectionPool ccp : poolMap.keySet()) {
                    MonitorableResourcePool pool = (MonitorableResourcePool)poolMap.get(ccp);
                    if (pool == null) continue;
                    try {
                        ConnectorConnectionPoolStatsImpl stats = new ConnectorConnectionPoolStatsImpl(pool);
                        ConnectorPoolMonitoringLevelListener.this.getPoolManager().setMonitoringEnabledHigh(pool.getPoolName());
                        ConnectorPoolMonitoringLevelListener.this.registry_.registerConnectorConnectionPoolStats((ConnectorConnectionPoolStats)stats, pool.getPoolName(), ConnectorPoolMonitoringLevelListener.this.getAppName(ccp.getResourceAdapterName()), ConnectorPoolMonitoringLevelListener.this.getRAName(ccp.getResourceAdapterName()), null);
                    }
                    catch (Exception mre) {
                        try {
                            _logger.log(Level.WARNING, "poolmon.cannot_reg", mre.getMessage());
                            ConnectorPoolMonitoringLevelListener.this.getPoolManager().disableMonitoring(pool.getPoolName());
                        }
                        catch (Exception ex) {}
                    }
                }
                return null;
            }
        });
    }

    private void switchOffMonitoring() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Map pools = ConnectorPoolMonitoringLevelListener.this.getPoolMap();
                if (pools == null) {
                    return null;
                }
                for (ConnectorConnectionPool ccp : pools.keySet()) {
                    MonitorableResourcePool pool = (MonitorableResourcePool)pools.get(ccp);
                    if (pool == null) continue;
                    try {
                        ConnectorPoolMonitoringLevelListener.this.registry_.unregisterConnectorConnectionPoolStats(pool.getPoolName(), ConnectorPoolMonitoringLevelListener.this.getAppName(ccp.getResourceAdapterName()), ConnectorPoolMonitoringLevelListener.this.getRAName(ccp.getResourceAdapterName()));
                        ConnectorPoolMonitoringLevelListener.this.getPoolManager().disableMonitoring(pool.getPoolName());
                    }
                    catch (Exception mre) {
                        _logger.log(Level.INFO, "poolmon.cannot_unreg");
                    }
                }
                return null;
            }
        });
    }

    private void transitionToLow() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Map poolMap = ConnectorPoolMonitoringLevelListener.this.getPoolMap();
                if (poolMap == null) {
                    return null;
                }
                for (ConnectorConnectionPool ccp : poolMap.keySet()) {
                    MonitorableResourcePool pool = (MonitorableResourcePool)poolMap.get(ccp);
                    if (pool == null) continue;
                    try {
                        ConnectorConnectionPoolStatsImpl stats = new ConnectorConnectionPoolStatsImpl(pool);
                        ConnectorPoolMonitoringLevelListener.this.getPoolManager().setMonitoringEnabledLow(pool.getPoolName());
                        ConnectorPoolMonitoringLevelListener.this.registry_.registerConnectorConnectionPoolStats((ConnectorConnectionPoolStats)stats, pool.getPoolName(), ConnectorPoolMonitoringLevelListener.this.getAppName(ccp.getResourceAdapterName()), ConnectorPoolMonitoringLevelListener.this.getRAName(ccp.getResourceAdapterName()), null);
                    }
                    catch (Exception mre) {
                        try {
                            _logger.log(Level.WARNING, "poolmon.cannot_reg", mre.getMessage());
                            ConnectorPoolMonitoringLevelListener.this.getPoolManager().disableMonitoring(pool.getPoolName());
                        }
                        catch (Exception ex) {}
                    }
                }
                return null;
            }
        });
    }

    private void logFine(String msg) {
        if (msg != null && _logger.isLoggable(Level.FINE)) {
            _logger.fine(msg);
        }
    }
}

