/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.security.auth.login.PasswordLoginModule;
import com.sun.enterprise.security.auth.realm.ldap.LDAPRealm;
import com.sun.jndi.ldap.obj.GroupOfURLs;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.login.LoginException;
import javax.security.auth.x500.X500Principal;

public class LDAPLoginModule
extends PasswordLoginModule {
    private String _userDNbase;
    private String _searchFilter;
    private String _grpDNbase;
    private String _grpSearchFilter;
    private String _grpTarget;
    private LDAPRealm _ldapRealm;
    private String[] _dnOnly = new String[]{"dn"};

    protected void authenticate() throws LoginException {
        if (!(this._currentRealm instanceof LDAPRealm)) {
            String msg = sm.getString("ldaplm.badrealm");
            throw new LoginException(msg);
        }
        this._ldapRealm = (LDAPRealm)this._currentRealm;
        if (this._password == null || this._password.length() == 0) {
            String msg = sm.getString("ldaplm.emptypassword", this._username);
            throw new LoginException(msg);
        }
        this._userDNbase = this._currentRealm.getProperty("base-dn");
        this._searchFilter = this._currentRealm.getProperty("search-filter");
        this._grpDNbase = this._currentRealm.getProperty("group-base-dn");
        this._grpSearchFilter = this._currentRealm.getProperty("group-search-filter");
        this._grpTarget = this._currentRealm.getProperty("group-target");
        String mode = this._currentRealm.getProperty("mode");
        if (!"find-bind".equals(mode)) {
            String msg = sm.getString("ldaplm.badmode", mode);
            throw new LoginException(msg);
        }
        this.findAndBind();
    }

    private void findAndBind() throws LoginException {
        StringBuffer sb = new StringBuffer(this._searchFilter);
        LDAPLoginModule.substitute(sb, "%s", this._username);
        String userid = sb.toString();
        InitialDirContext ctx = null;
        String srcFilter = null;
        String[] grpList = null;
        try {
            ctx = new InitialDirContext(this._ldapRealm.getLdapBindProps());
            String realUserDN = this.userSearch(ctx, this._userDNbase, userid);
            if (realUserDN == null) {
                String msg = sm.getString("ldaplm.usernotfound", this._username);
                throw new LoginException(msg);
            }
            boolean bindSuccessful = this.bindAsUser(realUserDN, this._password);
            if (!bindSuccessful) {
                String msg = sm.getString("ldaplm.bindfailed", realUserDN);
                throw new LoginException(msg);
            }
            sb = new StringBuffer(this._grpSearchFilter);
            LDAPLoginModule.substitute(sb, "%s", this._username);
            LDAPLoginModule.substitute(sb, "%d", realUserDN);
            srcFilter = sb.toString();
            ArrayList groupsList = new ArrayList();
            groupsList.addAll(this.groupSearch(ctx, this._grpDNbase, srcFilter, this._grpTarget));
            groupsList.addAll(this.dynamicGroupSearch(ctx, this._grpDNbase, this._grpTarget, realUserDN));
            grpList = new String[groupsList.size()];
            groupsList.toArray(grpList);
        }
        catch (Exception e) {
            throw new LoginException(e.toString());
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {}
            }
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "LDAP:Group search filter: " + srcFilter);
            StringBuffer gb = new StringBuffer();
            gb.append("Group memberships found: ");
            if (grpList != null) {
                for (int i = 0; i < grpList.length; ++i) {
                    gb.append(" " + grpList[i]);
                }
            } else {
                gb.append("(null)");
            }
            this._logger.log(Level.FINE, "LDAP: " + gb.toString());
        }
        this._ldapRealm.setGroupNames(this._username, grpList);
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, "LDAP: login succeeded for: " + this._username);
        }
        this.commitAuthentication(this._username, this._password, this._currentRealm, grpList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String userSearch(DirContext ctx, String baseDN, String filter) {
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.log(Level.FINE, "search: baseDN: " + baseDN + "  filter: " + filter);
        }
        String foundDN = null;
        NamingEnumeration<SearchResult> namingEnum = null;
        SearchControls ctls = new SearchControls();
        ctls.setReturningAttributes(this._dnOnly);
        ctls.setSearchScope(2);
        ctls.setCountLimit(1L);
        try {
            namingEnum = ctx.search(baseDN, filter, ctls);
            if (namingEnum.hasMore()) {
                SearchResult res = namingEnum.next();
                StringBuffer sb = new StringBuffer();
                CompositeName compDN = new CompositeName(res.getName());
                String ldapDN = compDN.get(0);
                sb.append(ldapDN);
                if (res.isRelative()) {
                    sb.append(",");
                    sb.append(baseDN);
                }
                foundDN = sb.toString();
                if (this._logger.isLoggable(Level.FINEST)) {
                    this._logger.log(Level.FINE, "Found user DN: " + foundDN);
                }
            }
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "ldaplm.searcherror", filter);
            this._logger.log(Level.WARNING, "security.exception", e);
        }
        finally {
            if (namingEnum != null) {
                try {
                    namingEnum.close();
                }
                catch (Exception ex) {}
            }
        }
        return foundDN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bindAsUser(String bindDN, String password) {
        boolean bindSuccessful = false;
        Properties p = this._ldapRealm.getLdapBindProps();
        p.put("java.naming.security.principal", bindDN);
        p.put("java.naming.security.credentials", password);
        InitialDirContext ctx = null;
        try {
            ctx = new InitialDirContext(p);
            bindSuccessful = true;
        }
        catch (Exception e) {
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.finest("Error binding to directory as: " + bindDN);
                this._logger.finest("Exception from JNDI: " + e.toString());
            }
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {}
            }
        }
        return bindSuccessful;
    }

    private List dynamicGroupSearch(DirContext ctx, String baseDN, String target, String userDN) {
        ArrayList<String> groupList = new ArrayList<String>();
        String filter = "(&(objectclass=groupofuniquenames)(objectclass=*groupofurls*))";
        String[] targets = new String[]{target, "memberUrl"};
        try {
            SearchControls ctls = new SearchControls();
            ctls.setReturningAttributes(targets);
            ctls.setSearchScope(2);
            ctls.setReturningObjFlag(true);
            NamingEnumeration<SearchResult> e = ctx.search(baseDN, filter, ctls);
            while (e.hasMore()) {
                X500Principal x500principal;
                GroupOfURLs gurls;
                SearchResult res = e.next();
                Object searchedObject = res.getObject();
                if (searchedObject instanceof GroupOfURLs && (gurls = (GroupOfURLs)searchedObject).isMember(x500principal = new X500Principal(userDN))) {
                    Attribute grpAttr = res.getAttributes().get(target);
                    int sz = grpAttr.size();
                    for (int i = 0; i < sz; ++i) {
                        String s = (String)grpAttr.get(i);
                        groupList.add(s);
                    }
                }
                if (!(searchedObject instanceof Context)) continue;
                ((Context)searchedObject).close();
            }
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "ldaplm.searcherror", filter);
            this._logger.log(Level.WARNING, "security.exception", e);
        }
        return groupList;
    }

    private List groupSearch(DirContext ctx, String baseDN, String filter, String target) {
        ArrayList<String> groupList = new ArrayList<String>();
        try {
            String[] targets = new String[]{target};
            SearchControls ctls = new SearchControls();
            ctls.setReturningAttributes(targets);
            ctls.setSearchScope(2);
            NamingEnumeration<SearchResult> e = ctx.search(baseDN, filter, ctls);
            while (e.hasMore()) {
                SearchResult res = e.next();
                Attribute grpAttr = res.getAttributes().get(target);
                int sz = grpAttr.size();
                for (int i = 0; i < sz; ++i) {
                    String s = (String)grpAttr.get(i);
                    groupList.add(s);
                }
            }
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "ldaplm.searcherror", filter);
            this._logger.log(Level.WARNING, "security.exception", e);
        }
        return groupList;
    }

    private static void substitute(StringBuffer sb, String target, String value) {
        int i = sb.indexOf(target);
        while (i >= 0) {
            sb.replace(i, i + target.length(), value);
            i = sb.indexOf(target);
        }
    }
}

