/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

public class PasswordCredential {
    private String username;
    private String password;
    private String realm;
    private boolean readOnly = false;
    private byte[] target_name = new byte[0];

    public PasswordCredential(String user, String password, String realm) {
        this.username = user;
        this.password = password;
        this.realm = realm;
        if (this.username == null) {
            this.username = "";
        }
        if (this.password == null) {
            this.password = "";
        }
        if (this.realm == null) {
            this.realm = "";
        }
    }

    public PasswordCredential(String user, String password, String realm, byte[] target_name) {
        this(user, password, realm);
        this.target_name = target_name;
        this.readOnly = true;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getUser() {
        return this.username;
    }

    public void setRealm(String realm) {
        if (!this.readOnly) {
            this.realm = realm;
        }
    }

    public String getPassword() {
        return this.password;
    }

    public byte[] getTargetName() {
        return this.target_name;
    }

    public boolean equals(Object o) {
        PasswordCredential pc;
        return o instanceof PasswordCredential && (pc = (PasswordCredential)o).getUser().equals(this.username) && pc.getPassword().equals(this.password) && pc.getRealm().equals(this.realm);
    }

    public int hashCode() {
        return this.username.hashCode() + this.password.hashCode() + this.realm.hashCode();
    }

    public String toString() {
        String s = "Realm=" + this.realm;
        s = s + " Username=" + this.username;
        s = s + " Password=" + "########";
        s = s + " TargetName = " + this.target_name;
        return s;
    }
}

