/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.store;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import javax.crypto.spec.SecretKeySpec;

public class PasswordAdapter {
    public static final String PASSWORD_ALIAS_KEYSTORE = "domain-passwords";
    private KeyStore _pwdStore = null;
    private String _keyFile = null;
    private char[] _masterPassword = null;

    private char[] getMasterPassword() {
        return this._masterPassword;
    }

    private void setMasterPassword(char[] smp) {
        this._masterPassword = smp;
    }

    public PasswordAdapter(char[] smp) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        String keyfileName = System.getProperty("com.sun.aas.instanceRoot") + File.separator + "config" + File.separator + PASSWORD_ALIAS_KEYSTORE;
        this.init(keyfileName, smp);
    }

    public PasswordAdapter(String keyfileName, char[] smp) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        this.init(keyfileName, smp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String keyfileName, char[] smp) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        this._keyFile = keyfileName;
        this._pwdStore = KeyStore.getInstance("JCEKS");
        this.setMasterPassword(smp);
        BufferedInputStream bInput = null;
        File file = new File(keyfileName);
        if (file.exists()) {
            bInput = new BufferedInputStream(new FileInputStream(file));
        }
        try {
            this._pwdStore.load(bInput, this.getMasterPassword());
            if (bInput != null) {
                bInput.close();
                bInput = null;
            }
        }
        finally {
            if (bInput != null) {
                try {
                    bInput.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public String getPasswordForAlias(String alias) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Key key = this._pwdStore.getKey(alias, this.getMasterPassword());
        if (key != null) {
            return new String(key.getEncoded());
        }
        return null;
    }

    public boolean aliasExists(String alias) throws KeyStoreException {
        return this._pwdStore.containsAlias(alias);
    }

    public void removeAlias(String alias) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        this._pwdStore.deleteEntry(alias);
        this.writeStore();
    }

    public Enumeration getAliases() throws KeyStoreException {
        return this._pwdStore.aliases();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        FilterOutputStream boutput = null;
        try {
            boutput = new BufferedOutputStream(new FileOutputStream(this._keyFile));
            this._pwdStore.store(boutput, this.getMasterPassword());
            boutput.close();
            boutput = null;
        }
        finally {
            if (boutput != null) {
                try {
                    boutput.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void setPasswordForAlias(String alias, byte[] secretKey) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
        SecretKeySpec key = new SecretKeySpec(secretKey, "AES");
        this._pwdStore.setKeyEntry(alias, key, this.getMasterPassword(), null);
        this.writeStore();
    }

    public void changePassword(char[] newpassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        this.setMasterPassword(newpassword);
        this.writeStore();
    }
}

