/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.server;

import com.sun.appserv.server.util.ASURLClassLoader;
import com.sun.appserv.server.util.ClassLoaderChain;
import com.sun.enterprise.util.ASenvPropertyReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PELaunch {
    public static final String USE_NEW_CLASSLOADER_PROPERTY = "com.sun.aas.useNewClassLoader";
    public static final String PROPERTIES_FILES = "processLauncher.properties";
    private static final String CLASSPATH_PREFIX_PROPERTY = "com.sun.aas.ClassPathPrefix";
    private static final String CLASSPATH_SUFFIX_PROPERTY = "com.sun.aas.ClassPathSuffix";
    private static final String SERVER_CLASSPATH_PROPERTY = "com.sun.aas.ServerClassPath";
    private static final String fileSeparator = File.separator;
    private static final String pathSeparator = File.pathSeparator;
    private static String installRoot = null;
    private static String javaHome = null;
    private static List<String> _appserverClasspath = null;
    private static List<String> _sharedClasspath = null;
    private static List<String> _optionalClasspath = null;
    private static ASURLClassLoader _sharedClassLoader = null;
    private static ClassLoaderChain _optionalChain = null;
    private static ClassLoaderChain _asChain = null;
    private static final boolean bDebug = new Boolean(System.getProperty("com.sun.aas.useNewClassLoader.debug", "false"));

    public static ClassLoader getSharedChain() {
        return _sharedClassLoader;
    }

    public static ClassLoader getOptionalChain() {
        return _optionalChain;
    }

    public static ClassLoader getAppServerChain() {
        return _asChain;
    }

    public static List<String> getSharedClasspath() {
        List manifestaddonJars;
        if (_sharedClasspath != null) {
            return _sharedClasspath;
        }
        String asLib = installRoot + fileSeparator + "lib" + fileSeparator;
        String sharedJarsList = System.getProperty("com.sun.aas.classloader.sharedChainJars");
        if (PELaunch.isEE()) {
            String eeSharedJarsList = System.getProperty("com.sun.aas.classloader.sharedChainJars.ee");
            sharedJarsList = sharedJarsList + "," + eeSharedJarsList;
        }
        PELaunch.logFine("shared jar list " + sharedJarsList);
        List<String> shr = PELaunch.getLibraryList(asLib, sharedJarsList);
        String prefixString = System.getProperty(CLASSPATH_PREFIX_PROPERTY);
        PELaunch.logFine(" prefixString " + prefixString);
        String[] classpathPrefix = null;
        if (prefixString != null) {
            classpathPrefix = prefixString.split("" + File.pathSeparatorChar);
        }
        String suffixString = System.getProperty(CLASSPATH_SUFFIX_PROPERTY);
        PELaunch.logFine(" suffixString " + suffixString);
        String[] classpathSuffix = null;
        if (suffixString != null) {
            classpathSuffix = suffixString.split("" + File.pathSeparatorChar);
        }
        String serverClassPathString = System.getProperty(SERVER_CLASSPATH_PROPERTY);
        PELaunch.logFine(" serverClassPathString " + serverClassPathString);
        String[] serverClassPath = null;
        if (serverClassPathString != null) {
            serverClassPath = serverClassPathString.split("" + File.pathSeparatorChar);
        }
        ArrayList<String> sharedChainList = new ArrayList<String>();
        if (classpathPrefix != null) {
            sharedChainList.addAll(Arrays.asList(classpathPrefix));
        }
        sharedChainList.addAll(shr);
        if (serverClassPath != null) {
            sharedChainList.addAll(Arrays.asList(serverClassPath));
        }
        if (classpathSuffix != null) {
            sharedChainList.addAll(Arrays.asList(classpathSuffix));
        }
        if ((manifestaddonJars = PELaunch.getManifestAddonJars()).size() != 0) {
            sharedChainList.addAll(manifestaddonJars);
        }
        _sharedClasspath = sharedChainList;
        return _sharedClasspath;
    }

    public static List getAppServerClasspath() {
        return _appserverClasspath;
    }

    public static List<String> getOptionalClasspath() {
        return _optionalClasspath;
    }

    public static List getServerClasspath() {
        String asLib = installRoot + fileSeparator + "lib" + fileSeparator;
        String serverJarsList = System.getProperty("com.sun.aas.classloader.serverClassPath");
        if (PELaunch.isEE()) {
            String eeServerJarsList = System.getProperty("com.sun.aas.classloader.serverClassPath.ee");
            serverJarsList = serverJarsList + "," + eeServerJarsList;
        }
        PELaunch.logFine("serverClassPathJarsList " + serverJarsList);
        List<String> serverClasspathList = PELaunch.getLibraryList(asLib, serverJarsList);
        return serverClasspathList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static List getManifestAddonJars() {
        ArrayList<String> manifestJars;
        block20: {
            File libAddonDirectory;
            String addonDir;
            ZipFile file;
            block18: {
                manifestJars = new ArrayList<String>();
                file = null;
                addonDir = installRoot + fileSeparator + "lib" + fileSeparator + "addons";
                libAddonDirectory = new File(addonDir);
                if (libAddonDirectory.isDirectory()) break block18;
                ArrayList<String> arrayList = manifestJars;
                Object var15_7 = null;
                try {
                    if (file != null) {
                        file.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
                return arrayList;
            }
            File[] fileArray = libAddonDirectory.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                String classPath;
                String addonJar = fileArray[i].getName();
                String jarExtension = "";
                int dotLastIndex = addonJar.lastIndexOf(".");
                if (dotLastIndex != -1) {
                    jarExtension = addonJar.substring(dotLastIndex + 1);
                }
                if (!jarExtension.equalsIgnoreCase("jar")) continue;
                manifestJars.add(fileArray[i].getAbsolutePath());
                file = new JarFile(fileArray[i].getAbsolutePath());
                Manifest mf = ((JarFile)file).getManifest();
                Attributes attributes = null;
                if (mf == null) continue;
                attributes = mf.getMainAttributes();
                if (attributes != null && (classPath = attributes.getValue(Attributes.Name.CLASS_PATH)) != null && !classPath.trim().equals("")) {
                    StringTokenizer stoken = new StringTokenizer(classPath);
                    while (stoken.hasMoreTokens()) {
                        String classPathJar = addonDir + fileSeparator + stoken.nextElement();
                        manifestJars.add(classPathJar);
                    }
                }
                file.close();
            }
            Object var15_8 = null;
            try {
                if (file != null) {
                    file.close();
                }
                break block20;
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
            }
            break block20;
            {
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    Object var15_9 = null;
                    try {
                        if (file != null) {
                            file.close();
                        }
                        break block20;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(System.err);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_10 = null;
                try {
                    if (file != null) {
                        file.close();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
                throw throwable;
            }
        }
        return manifestJars;
    }

    public static void main(String[] args) {
        try {
            Class<?> peMainClass = null;
            if (Boolean.getBoolean(USE_NEW_CLASSLOADER_PROPERTY)) {
                ASenvPropertyReader reader = new ASenvPropertyReader(System.getProperty("com.sun.aas.configRoot"), false);
                reader.setSystemProperties();
                installRoot = System.getProperty("com.sun.aas.installRoot");
                javaHome = System.getProperty("com.sun.aas.javaRoot");
                PELaunch.setupClassloaders();
                peMainClass = _asChain.loadClass("com.sun.enterprise.server.PEMain", true);
                Thread.currentThread().setContextClassLoader(_asChain);
            } else {
                peMainClass = Class.forName("com.sun.enterprise.server.PEMain");
            }
            Class[] argTypes = new Class[]{String[].class};
            Method m = peMainClass.getMethod("main", argTypes);
            Object[] argListForInvokedMain = new Object[]{args};
            m.invoke(null, argListForInvokedMain);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private static void setupClassloaders() {
        PELaunch.prepareAppServerJars();
        PELaunch.prepareOptionalOverrideableJars();
        PELaunch.appendOtherJarsToSharedChain();
        PELaunch.setupSharedChain();
        PELaunch.setupOptionalOverrideableChain();
        PELaunch.setupAppServerChain();
        List<String> cp = PELaunch.getSharedClasspath();
        StringBuilder classpath = new StringBuilder(System.getProperty("java.class.path"));
        for (String s : cp) {
            classpath.append(s);
            classpath.append(pathSeparator);
        }
        System.setProperty("java.class.path", classpath.toString());
    }

    public static List<String> getServerClassPath(String configDir, String domainDir) {
        File f;
        File[] fls;
        ASenvPropertyReader reader = new ASenvPropertyReader(configDir, false);
        reader.setSystemProperties();
        installRoot = System.getProperty("com.sun.aas.installRoot");
        javaHome = System.getProperty("com.sun.aas.javaRoot");
        String asLib = installRoot + fileSeparator;
        ArrayList<String> serverClassPathList = new ArrayList<String>();
        for (File element : fls = PELaunch.getAllLibrariesInLib(asLib)) {
            serverClassPathList.add(element.getAbsolutePath());
        }
        String mqlib = System.getProperty("com.sun.aas.imqLib");
        String antlib = System.getProperty("com.sun.aas.antLib");
        String jdmklib = System.getProperty("com.sun.aas.jdmkHome");
        String hadbRoot = System.getProperty("com.sun.aas.hadbRoot");
        String[] peServerClassPath = new String[]{installRoot + "/lib/install/applications/jmsra/imqjmsra.jar", mqlib + "/jaxm-api.jar", mqlib + "/fscontext.jar", mqlib + "/imqbroker.jar", mqlib + "/imqjmx.jar", mqlib + "/imqxm.jar", antlib + "/ant.jar", jdmklib + "/lib/jdmkrt.jar"};
        String[] eeServerClassPath = new String[]{hadbRoot + "/lib/hadbjdbc4.jar", jdmklib + "/lib/jdmkrt.jar", hadbRoot + "/lib/dbstate.jar", hadbRoot + "/lib/hadbm.jar", hadbRoot + "/lib/hadbmgt.jar"};
        for (String element : peServerClassPath) {
            f = new File(element);
            if (!f.exists()) continue;
            serverClassPathList.add(f.getAbsolutePath());
        }
        for (String element : eeServerClassPath) {
            f = new File(element);
            if (!f.exists()) continue;
            serverClassPathList.add(f.getAbsolutePath());
        }
        PELaunch.logFine("Server Classpath for verifier " + serverClassPathList + "\n");
        Logger.getAnonymousLogger().log(Level.FINE, "Server Classpath for verifier " + serverClassPathList);
        return serverClassPathList;
    }

    private static void setupSharedChain() {
        List<String> sharedChainJarList = PELaunch.getSharedClasspath();
        PELaunch.logFine("shared classpath jars : " + sharedChainJarList + "\n");
        URL[] urls = PELaunch.getURLList(sharedChainJarList);
        PELaunch.logFine(" SharedChain URL List " + urls);
        _sharedClassLoader = new ASURLClassLoader(urls, ClassLoader.getSystemClassLoader());
        _sharedClassLoader.setName("Shared ClassLoader Chain");
    }

    private static void setupOptionalOverrideableChain() {
        _optionalChain = new ClassLoaderChain(_sharedClassLoader);
        _optionalChain.setName("optionalChain");
        URL[] urls = PELaunch.getURLList(_optionalClasspath);
        ASURLClassLoader optionalJarsLoader = new ASURLClassLoader(urls, (ClassLoader)_sharedClassLoader);
        _optionalChain.addToList(optionalJarsLoader);
    }

    private static void prepareOptionalOverrideableJars() {
        String asLib = installRoot + fileSeparator + "lib" + fileSeparator;
        String optionalJarsString = System.getProperty("com.sun.aas.classloader.optionalOverrideableChain");
        if (PELaunch.isEE()) {
            String eeOptionalJarsList = System.getProperty("com.sun.aas.classloader.optionalOverrideableChain.ee");
            optionalJarsString = optionalJarsString + "," + eeOptionalJarsList;
        }
        PELaunch.logFine(" optionalOverrideableChain" + optionalJarsString);
        _optionalClasspath = PELaunch.getLibraryList(asLib, optionalJarsString);
        PELaunch.logFine("Optional overrideable chain classpath : " + _optionalClasspath + "\n");
    }

    private static void setupAppServerChain() {
        URL[] urls = PELaunch.getURLList(_appserverClasspath);
        _asChain = new ClassLoaderChain(_sharedClassLoader);
        _asChain.setName("ASChain");
        ASURLClassLoader asimplloader = new ASURLClassLoader(urls, (ClassLoader)_asChain);
        asimplloader.setName("asimpl");
        _asChain.addToList(asimplloader);
        _asChain.addToList(_optionalChain);
    }

    private static void prepareAppServerJars() {
        String asLib = installRoot + fileSeparator + "lib";
        String appserverJarsStr = System.getProperty("com.sun.aas.classloader.appserverChainJars");
        if (PELaunch.isEE()) {
            String eeAppserverJarsList = System.getProperty("com.sun.aas.classloader.appserverChainJars.ee");
            appserverJarsStr = appserverJarsStr + "," + eeAppserverJarsList;
        }
        PELaunch.logFine("appserverJarsString " + appserverJarsStr);
        _appserverClasspath = PELaunch.getLibraryList(asLib, appserverJarsStr);
        PELaunch.logFine("Application server classpath : " + _appserverClasspath + "\n");
    }

    private static boolean isEE() {
        boolean isEE = false;
        String eepffc = "com.sun.enterprise.ee.server.pluggable.EEPluggableFeatureImpl";
        String pn = "com.sun.appserv.pluggable.features";
        String pv = System.getProperty("com.sun.appserv.pluggable.features");
        if ("com.sun.enterprise.ee.server.pluggable.EEPluggableFeatureImpl".equals(pv)) {
            isEE = true;
        }
        return isEE;
    }

    private static List<String> getLibraryList(String libraryRoot, String librariesString) {
        String[] libraries = librariesString.split(",");
        ArrayList<String> shr = new ArrayList<String>();
        for (String library : libraries) {
            File file = new File(library = library.trim());
            if (!file.isAbsolute()) {
                shr.add(libraryRoot + library);
                continue;
            }
            shr.add(library);
        }
        return shr;
    }

    private static URL[] getURLList(List<String> librariesList) {
        int i = 0;
        String[] sharedJars = librariesList.toArray(new String[0]);
        URL[] urls = new URL[sharedJars.length];
        for (String s : sharedJars) {
            try {
                URL url = new File(s).toURI().toURL();
                urls[i++] = url;
            }
            catch (MalformedURLException e) {
                Logger.getAnonymousLogger().warning(e.getMessage());
                Logger.getAnonymousLogger().log(Level.WARNING, "Exception whilesetting up shared chain", e);
            }
        }
        return urls;
    }

    private static void logFine(String s) {
        if (bDebug) {
            System.err.println(s);
        }
    }

    private static void appendOtherJarsToSharedChain() {
        File[] files;
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(PELaunch.getSharedClasspath());
        list.addAll(PELaunch.getAppServerClasspath());
        list.addAll(PELaunch.getOptionalClasspath());
        for (File file : files = PELaunch.getAllLibrariesInLib(installRoot)) {
            try {
                if (list.contains(file.getCanonicalPath())) continue;
                _sharedClasspath.add(file.getCanonicalPath());
            }
            catch (IOException ioe) {
                System.err.println("Error getting " + file.getAbsolutePath() + " " + ioe.getMessage());
            }
        }
    }

    private static File[] getAllLibrariesInLib(String asLib) {
        File installLib = new File(asLib, "lib");
        File[] files = installLib.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                if (name.endsWith(".jar") || name.endsWith(".zip")) {
                    return !name.equals("j2ee.jar");
                }
                return false;
            }
        });
        return files;
    }

    static {
        if (System.getProperty(USE_NEW_CLASSLOADER_PROPERTY) == null) {
            System.setProperty(USE_NEW_CLASSLOADER_PROPERTY, "true");
        }
    }
}

