/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.ejbfindermethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class EjbFinderMethodPublic
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistence = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if (EjbEntityDescriptor.BEAN_PERSISTENCE.equals(persistence)) {
                boolean ejbFindMethodFound = false;
                boolean isPublic = false;
                boolean oneFailed = false;
                int findMethodModifiers = 0;
                int foundAtLeastOne = 0;
                try {
                    Context context = this.getVerifierContext();
                    ClassLoader jcl = context.getClassLoader();
                    Class<?> EJBClass = Class.forName(descriptor.getEjbClassName(), false, this.getVerifierContext().getClassLoader());
                    do {
                        Method[] ejbFinderMethods = EJBClass.getDeclaredMethods();
                        for (int j = 0; j < ejbFinderMethods.length; ++j) {
                            isPublic = false;
                            ejbFindMethodFound = false;
                            if (!ejbFinderMethods[j].getName().startsWith("ejbFind")) continue;
                            ejbFindMethodFound = true;
                            ++foundAtLeastOne;
                            findMethodModifiers = ejbFinderMethods[j].getModifiers();
                            if (Modifier.isPublic(findMethodModifiers)) {
                                isPublic = true;
                            }
                            if (ejbFindMethodFound && isPublic) {
                                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] Finder method [ {1} ]", new Object[]{EJBClass.getName(), ejbFinderMethods[j].getName()}));
                                result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "A public [ {0} ] method was found.", new Object[]{ejbFinderMethods[j].getName()}));
                                continue;
                            }
                            if (!ejbFindMethodFound || isPublic) continue;
                            oneFailed = true;
                            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For EJB Class [ {0} ] Finder Method [ {1} ]", new Object[]{EJBClass.getName(), ejbFinderMethods[j].getName()}));
                            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: An [ {0} ] method was found, but was not public.", new Object[]{ejbFinderMethods[j].getName()}));
                        }
                    } while ((EJBClass = EJBClass.getSuperclass()) != null && foundAtLeastOne == 0);
                    if (foundAtLeastOne == 0) {
                        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "No ejbFind<METHOD> method was found in [ {0} ] class.", new Object[]{descriptor.getEjbClassName()}));
                    }
                }
                catch (ClassNotFoundException e) {
                    Verifier.debug(e);
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: EJB Class [ {1} ] does not exist or is not loadable.", new Object[]{descriptor.getEjbClassName()}));
                    oneFailed = true;
                }
                if (oneFailed) {
                    result.setStatus(1);
                } else if (foundAtLeastOne == 0) {
                    result.setStatus(3);
                } else {
                    result.setStatus(0);
                }
                return result;
            }
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Expected [ {0} ] managed persistence, but [ {1} ] bean has [ {2} ] managed persistence.", new Object[]{EjbEntityDescriptor.BEAN_PERSISTENCE, descriptor.getName(), persistence}));
            return result;
        }
        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

