/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.intf.remoteintf;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import java.util.logging.Level;

public class RemoteInterfaceSuperInterface
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (!(descriptor instanceof EjbSessionDescriptor) && !(descriptor instanceof EjbEntityDescriptor)) {
            this.addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.homeintf.HomeMethodTest.notApplicable1", "Test apply only to session or entity beans."));
            return result;
        }
        if (descriptor.getRemoteClassName() == null || "".equals(descriptor.getRemoteClassName())) {
            this.addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.intf.InterfaceTest.notApplicable", "Not Applicable because, EJB [ {0} ] does not have {1} Interface.", new Object[]{descriptor.getEjbClassName(), "Remote"}));
            return result;
        }
        boolean oneFailed = false;
        try {
            Class<?> c;
            ClassLoader jcl = this.getVerifierContext().getClassLoader();
            Class<?> remote = c = Class.forName(descriptor.getRemoteClassName(), false, jcl);
            boolean validRemoteInterface = false;
            boolean ok = false;
            block2: do {
                Class<?>[] interfaces;
                if ((interfaces = c.getInterfaces()).length == 0) {
                    ok = true;
                }
                for (Class<?> intf : interfaces) {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug1", new Object[]{intf.getName()});
                    if (!ok) {
                        ok = RmiIIOPUtils.isValidRmiIIOPInterface(intf);
                    }
                    if (RmiIIOPUtils.isValidRmiIIOPInterfaceMethods(intf)) {
                        if (!intf.getName().equals("javax.ejb.EJBObject")) continue;
                        validRemoteInterface = true;
                        continue block2;
                    }
                    oneFailed = true;
                    this.addErrorDetails(result, compName);
                    result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] does not properly conform to rules of RMI-IIOP for superinterfaces.  All enterprise beans remote interfaces are allowed to have superinterfaces that conform to the rules of RMI-IIOP for superinterfaces .  [ {1} ] is not a valid remote interface.", new Object[]{intf.getName(), descriptor.getRemoteClassName()}));
                }
            } while ((c = c.getSuperclass()) != null && !validRemoteInterface);
            if (!ok) {
                oneFailed = true;
                this.addErrorDetails(result, compName);
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] does not properly conform to rules of RMI-IIOP for superinterfaces.  All enterprise beans remote interfaces are allowed to have superinterfaces that conform to the rules of RMI-IIOP for superinterfaces.  [ {1} ] is not a valid remote interface.", new Object[]{remote.getName(), descriptor.getRemoteClassName()}));
            }
            if (validRemoteInterface) {
                this.addGoodDetails(result, compName);
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] properly conforms to rules of RMI-IIOP for superinterfaces.", new Object[]{descriptor.getRemoteClassName()}));
            }
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.addGoodDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Remote interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{descriptor.getRemoteClassName(), descriptor.getName()}));
            oneFailed = true;
        }
        if (oneFailed) {
            result.setStatus(1);
        } else {
            result.setStatus(0);
        }
        return result;
    }
}

