/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.messagebean;

import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.messagebean.MessageBeanTest;
import java.lang.reflect.Method;

public class RemoteExceptionNotThrown
extends MessageBeanTest {
    public Result check(EjbMessageBeanDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        ClassLoader cl = this.getVerifierContext().getClassLoader();
        try {
            Method[] methods = descriptor.getMessageListenerInterfaceMethods(cl);
            for (int i = 0; i < methods.length; ++i) {
                if (!this.containsRemote(methods[i].getExceptionTypes())) continue;
                this.addErrorDetails(result, compName);
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Method [ {0} ] throws RemoteException", new Object[]{methods[i]}));
            }
        }
        catch (NoSuchMethodException e) {
            Verifier.debug(e);
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "[ {0} ]", new Object[]{e.getMessage()}));
        }
        if (result.getStatus() != 1) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Valid message listener method(s)."));
        }
        return result;
    }

    private boolean containsRemote(Class[] exceptions) {
        for (int i = 0; i < exceptions.length; ++i) {
            if (!exceptions[i].getName().equals("java.rmi.RemoteException")) continue;
            return true;
        }
        return false;
    }
}

