/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.ClusterHelper;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.JdbcConnectionPool;
import com.sun.enterprise.config.serverbeans.JdbcResource;
import com.sun.enterprise.config.serverbeans.ManagerProperties;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.config.serverbeans.SessionConfig;
import com.sun.enterprise.config.serverbeans.SessionManager;
import com.sun.enterprise.config.serverbeans.SessionProperties;
import com.sun.enterprise.config.serverbeans.StoreProperties;
import com.sun.enterprise.config.serverbeans.WebContainer;
import com.sun.enterprise.config.serverbeans.WebContainerAvailability;
import com.sun.enterprise.config.serverbeans.WebModule;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.uuid.UuidGenerator;
import com.sun.enterprise.util.uuid.UuidGeneratorImpl;
import com.sun.enterprise.web.session.PersistenceType;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerConfigLookup {
    protected final String HADB_CONNECTION_URL_PREFIX = "jdbc:sun:hadb:";
    protected final String CLUSTER_ID_PROPERTY_NAME = "cluster-id";
    protected final String STALE_SESSION_CHECKING_ENABLED_PROPERTY_NAME = "stale-session-checking-enabled";
    protected final String DEFAULT_CLUSTER_ID = "cluster1";
    protected final String HADB_STORE_POOL_JNDI_NAME_PROPERTY_NAME = "store-pool-jndi-name";
    protected final String DEFAULT_STORE_POOL_JNDI_NAME = "jdbc/hastore";
    protected final String HADB_MGMT_ENV_PATH_PROPERTY_NAME = "hadb-mgmt-env-path";
    protected final String HADB_DATABASE_NAME_PROPERTY_NAME = "hadb-database-name";
    protected final String UUID_GENERATOR_CLASS_PROPERTY_NAME = "uuid-impl-class";
    protected final String DEFAULT_UUID_GENERATOR_CLASS = "com.sun.enterprise.util.uuid.UuidGeneratorImpl";
    protected final String EE_BUILDER_PATH_PROPERTY_NAME = "ee-builder-path";
    protected final String DEFAULT_EE_BUILDER_PATH = "com.sun.enterprise.ee.web.initialization";
    protected final String HADB_HEALTH_CHECK_ENABLED_PROPERTY_NAME = "hadb-health-check-enabled";
    protected final int DEFAULT_HA_STORE_HEALTHCHECK_INTERVAL_IN_SECONDS = 5;
    protected final String USER_NAME = "User";
    protected final String PASSWORD = "Password";
    protected final String HADB_AGENT_PASSWORD = "ha-agent-password";
    protected ConfigContext _configContext = null;
    private static Logger _logger = null;

    public ServerConfigLookup() {
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
        }
    }

    public ServerConfigLookup(ConfigContext configContext) {
        this();
        this._configContext = configContext;
    }

    protected ServerContext getServerContext() {
        return ApplicationServer.getServerContext();
    }

    protected ConfigContext getConfigContextDynamic() {
        if (this._configContext != null) {
            return this._configContext;
        }
        return this.getConfigContext();
    }

    protected ConfigContext getConfigContext() {
        ServerContext serverCtx = this.getServerContext();
        if (serverCtx == null) {
            return null;
        }
        return serverCtx.getConfigContext();
    }

    private Server getServerBean() {
        Server serverBean = null;
        ConfigContext configCtx = this.getConfigContext();
        try {
            serverBean = ServerBeansFactory.getServerBean(configCtx);
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        return serverBean;
    }

    private String getServerName() {
        String result = null;
        Server serverBean = this.getServerBean();
        if (serverBean != null) {
            result = serverBean.getName();
        }
        return result;
    }

    public String getClusterName() {
        String result = null;
        ConfigContext configCtx = this.getConfigContext();
        String serverName = this.getServerName();
        if (serverName == null) {
            return result;
        }
        boolean isClustered = false;
        try {
            isClustered = ServerHelper.isServerClustered(configCtx, serverName);
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        if (!isClustered) {
            result = serverName + "_nc";
            return result;
        }
        Cluster cluster = null;
        try {
            cluster = ClusterHelper.getClusterForInstance(configCtx, serverName);
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        if (cluster != null) {
            result = cluster.getName();
        }
        return result;
    }

    private Resources getResourcesBean() {
        Resources resourcesBean = null;
        Domain domainBean = null;
        ConfigContext configCtx = this.getConfigContext();
        try {
            domainBean = ServerBeansFactory.getDomainBean(configCtx);
            if (domainBean != null) {
                resourcesBean = domainBean.getResources();
            }
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        return resourcesBean;
    }

    private Applications getApplicationsBean() {
        Applications applicationsBean = null;
        Domain domainBean = null;
        ConfigContext configCtx = this.getConfigContext();
        try {
            domainBean = ServerBeansFactory.getDomainBean(configCtx);
            if (domainBean != null) {
                applicationsBean = domainBean.getApplications();
            }
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        return applicationsBean;
    }

    private Applications getApplicationsBeanDynamic() {
        Applications applicationsBean = null;
        Domain domainBean = null;
        ConfigContext configCtx = this.getConfigContextDynamic();
        try {
            domainBean = ServerBeansFactory.getDomainBean(configCtx);
            if (domainBean != null) {
                applicationsBean = domainBean.getApplications();
            }
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        return applicationsBean;
    }

    private Config getConfigBean() {
        Config configBean = null;
        ConfigContext configCtx = this.getConfigContext();
        try {
            configBean = ServerBeansFactory.getConfigBean(configCtx);
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        return configBean;
    }

    private Config getConfigBeanDynamic() {
        Config configBean = null;
        ConfigContext configCtx = this.getConfigContextDynamic();
        try {
            configBean = ServerBeansFactory.getConfigBean(configCtx);
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        return configBean;
    }

    protected AvailabilityService getAvailabilityService() {
        Config configBean = this.getConfigBean();
        if (configBean == null) {
            return null;
        }
        return configBean.getAvailabilityService();
    }

    protected AvailabilityService getAvailabilityServiceDynamic() {
        Config configBean = this.getConfigBeanDynamic();
        if (configBean == null) {
            return null;
        }
        return configBean.getAvailabilityService();
    }

    private WebContainerAvailability getWebContainerAvailability() {
        AvailabilityService availabilityServiceBean = this.getAvailabilityService();
        if (availabilityServiceBean == null) {
            return null;
        }
        return availabilityServiceBean.getWebContainerAvailability();
    }

    private ElementProperty[] getWebContainerAvailabilityProperties() {
        WebContainerAvailability webContainerAvailabilityBean = this.getWebContainerAvailability();
        if (webContainerAvailabilityBean == null) {
            return new ElementProperty[0];
        }
        return webContainerAvailabilityBean.getElementProperty();
    }

    protected String getWebContainerAvailabilityPropertyString(String propName) {
        String result = null;
        WebContainerAvailability wcAvailabilityBean = this.getWebContainerAvailability();
        if (wcAvailabilityBean != null && wcAvailabilityBean.sizeElementProperty() > 0) {
            ElementProperty[] props = wcAvailabilityBean.getElementProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (!name.equalsIgnoreCase(propName)) continue;
                result = value;
            }
        }
        return result;
    }

    protected String getWebContainerAvailabilityPropertyString(String propName, String defaultValue) {
        String result = null;
        WebContainerAvailability wcAvailabilityBean = this.getWebContainerAvailability();
        if (wcAvailabilityBean != null && wcAvailabilityBean.sizeElementProperty() > 0) {
            ElementProperty[] props = wcAvailabilityBean.getElementProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (!name.equalsIgnoreCase(propName)) continue;
                result = value;
            }
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    protected int getWebContainerAvailabilityPropertyInt(String propName, int defaultValue) {
        int returnValue;
        block5: {
            returnValue = defaultValue;
            String returnValueString = null;
            WebContainerAvailability wcAvailabilityBean = this.getWebContainerAvailability();
            if (wcAvailabilityBean != null && wcAvailabilityBean.sizeElementProperty() > 0) {
                ElementProperty[] props = wcAvailabilityBean.getElementProperty();
                for (int i = 0; i < props.length; ++i) {
                    String name = props[i].getAttributeValue("name");
                    String value = props[i].getAttributeValue("value");
                    if (!name.equalsIgnoreCase(propName)) continue;
                    returnValueString = value;
                }
            }
            if (returnValueString != null) {
                try {
                    returnValue = Integer.valueOf(returnValueString);
                }
                catch (NumberFormatException ex) {
                    if (!_logger.isLoggable(Level.FINEST)) break block5;
                    _logger.finest("Using Default Value = " + defaultValue);
                }
            }
        }
        return returnValue;
    }

    private WebModule getWebModuleByContextRoot(String contextRoot) {
        WebModule result = null;
        Applications applicationsBean = this.getApplicationsBeanDynamic();
        if (applicationsBean == null) {
            return null;
        }
        WebModule[] webModules = applicationsBean.getWebModule();
        for (int i = 0; i < webModules.length; ++i) {
            WebModule nextWebModule = webModules[i];
            String nextContextRoot = nextWebModule.getContextRoot();
            if (nextContextRoot == null || !nextContextRoot.equalsIgnoreCase(contextRoot)) continue;
            result = nextWebModule;
        }
        return result;
    }

    private boolean getWebModuleAvailability(String contextRoot, boolean inheritedValue) {
        WebModule webModule = this.getWebModuleByContextRoot(contextRoot);
        if (webModule == null) {
            return false;
        }
        return webModule.isAvailabilityEnabled();
    }

    private J2eeApplication getJ2eeApplicationByName(String appName) {
        Object result = null;
        Applications applicationsBean = this.getApplicationsBeanDynamic();
        if (applicationsBean == null) {
            return null;
        }
        return applicationsBean.getJ2eeApplicationByName(appName);
    }

    private boolean getJ2eeApplicationAvailability(String appName, boolean inheritedValue) {
        J2eeApplication j2eeApp = this.getJ2eeApplicationByName(appName);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("ServerConfigLookup>>getJ2eeApplicationAvailability j2eeApp = " + j2eeApp);
        }
        if (j2eeApp == null) {
            return false;
        }
        return j2eeApp.isAvailabilityEnabled();
    }

    public PersistenceType getPersistenceTypeFromConfig() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getPersistenceTypeFromConfig");
        }
        String persistenceTypeString = null;
        PersistenceType persistenceType = null;
        WebContainerAvailability webContainerAvailabilityBean = this.getWebContainerAvailability();
        if (webContainerAvailabilityBean == null) {
            return null;
        }
        persistenceTypeString = webContainerAvailabilityBean.getPersistenceType();
        if (persistenceTypeString != null) {
            persistenceType = PersistenceType.parseType(persistenceTypeString);
        }
        if (persistenceType != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("SERVER.XML persistenceType= " + persistenceType.getType());
            }
        } else if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("SERVER.XML persistenceType missing");
        }
        return persistenceType;
    }

    public String getPersistenceFrequencyFromConfig() {
        WebContainerAvailability webContainerAvailabilityBean;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getPersistenceFrequencyFromConfig");
        }
        if ((webContainerAvailabilityBean = this.getWebContainerAvailability()) == null) {
            return null;
        }
        return webContainerAvailabilityBean.getPersistenceFrequency();
    }

    public String getPersistenceScopeFromConfig() {
        WebContainerAvailability webContainerAvailabilityBean;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getPersistenceScopeFromConfig");
        }
        if ((webContainerAvailabilityBean = this.getWebContainerAvailability()) == null) {
            return null;
        }
        return webContainerAvailabilityBean.getPersistenceScope();
    }

    public boolean getStaleSessionCheckingFromConfig() {
        String staleSessionCheckingEnabledString;
        Boolean bool;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getStaleSessionCheckingFromConfig");
        }
        if ((bool = this.toBoolean(staleSessionCheckingEnabledString = this.getWebContainerAvailabilityPropertyString("stale-session-checking-enabled", "false"))) == null) {
            return false;
        }
        return bool;
    }

    public String getClusterIdFromConfig() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getClusterIdFromConfig");
        }
        return this.getWebContainerAvailabilityPropertyString("cluster-id", "cluster1");
    }

    public boolean getAvailabilityEnabledFromConfig() {
        AvailabilityService as;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getAvailabilityEnabledFromConfig");
        }
        if ((as = this.getAvailabilityService()) == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("AvailabilityService was not defined - check domain.xml");
            }
            return false;
        }
        return as.isAvailabilityEnabled();
    }

    public boolean calculateWebAvailabilityEnabledFromConfig(String contextRoot, String j2eeAppName) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>calculateWebAvailabilityEnabledFromConfig");
        }
        boolean globalAvailability = this.getAvailabilityEnabledFromConfig();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("globalAvailability = " + globalAvailability);
        }
        boolean webContainerAvailability = this.getWebContainerAvailabilityEnabledFromConfig(globalAvailability);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("webContainerAvailability = " + webContainerAvailability);
        }
        if (j2eeAppName == null || "null".equals(j2eeAppName)) {
            boolean webModuleAvailability = this.getWebModuleAvailability(contextRoot, webContainerAvailability);
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("webModuleAvailability = " + webModuleAvailability);
            }
            return globalAvailability && webContainerAvailability && webModuleAvailability;
        }
        boolean j2eeApplicationAvailability = this.getJ2eeApplicationAvailability(j2eeAppName, webContainerAvailability);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("j2eeApplicationAvailability = " + j2eeApplicationAvailability);
        }
        return globalAvailability && webContainerAvailability && j2eeApplicationAvailability;
    }

    public boolean getWebContainerAvailabilityEnabledFromConfig() {
        WebContainerAvailability was;
        boolean globalAvailabilityEnabled = this.getAvailabilityEnabledFromConfig();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getWebContainerAvailabilityEnabledFromConfig");
        }
        if ((was = this.getWebContainerAvailability()) == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("WebContainerAvailability was not defined - check domain.xml");
            }
            return globalAvailabilityEnabled;
        }
        String wasString = was.getAvailabilityEnabled();
        Boolean bool = this.toBoolean(wasString);
        if (bool == null) {
            return globalAvailabilityEnabled;
        }
        return bool;
    }

    public boolean getWebContainerAvailabilityEnabledFromConfig(boolean inheritedValue) {
        WebContainerAvailability was;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getWebContainerAvailabilityEnabledFromConfig");
        }
        if ((was = this.getWebContainerAvailability()) == null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("WebContainerAvailability was not defined - check domain.xml");
            }
            return inheritedValue;
        }
        String wasString = was.getAvailabilityEnabled();
        Boolean bool = this.toBoolean(wasString);
        if (bool == null) {
            return inheritedValue;
        }
        return bool;
    }

    protected Boolean toBoolean(String value) {
        if (value == null) {
            return null;
        }
        if (value.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("yes")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("on")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String getStorePoolJndiNameFromConfig() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getStorePoolJndiNameFromConfig");
        }
        String result = "jdbc/hastore";
        AvailabilityService as = this.getAvailabilityService();
        if (as == null) {
            return result;
        }
        String storePoolJndiName = as.getStorePoolName();
        if (storePoolJndiName != null) {
            result = storePoolJndiName;
        }
        return result;
    }

    public String getHaStorePoolJndiNameFromConfig() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getHaStorePoolJndiNameFromConfig");
        }
        String result = this.getStorePoolJndiNameFromConfig();
        WebContainerAvailability webContainerAvailabilityBean = this.getWebContainerAvailability();
        if (webContainerAvailabilityBean == null) {
            return result;
        }
        String result2 = webContainerAvailabilityBean.getHttpSessionStorePoolName();
        if (result2 != null) {
            result = result2;
        }
        return result;
    }

    public boolean getHadbHealthCheckFromConfig() {
        AvailabilityService as = this.getAvailabilityService();
        if (as == null) {
            return false;
        }
        return as.isHaStoreHealthcheckEnabled();
    }

    public boolean getHadbHealthCheckFromConfigDynamic() {
        AvailabilityService as = this.getAvailabilityServiceDynamic();
        if (as == null) {
            return false;
        }
        return as.isHaStoreHealthcheckEnabled();
    }

    public boolean getSsoFailoverEnabledFromConfig() {
        WebContainerAvailability webContainerAvailabilityBean = this.getWebContainerAvailability();
        if (webContainerAvailabilityBean == null) {
            return false;
        }
        return webContainerAvailabilityBean.isSsoFailoverEnabled();
    }

    public String getHadbMgmtEnvPathFromConfig() {
        return this.getWebContainerAvailabilityPropertyString("hadb-mgmt-env-path", null);
    }

    protected String getAvailabilityServicePropertyString(String propName) {
        String result = null;
        AvailabilityService availabilityServiceBean = this.getAvailabilityService();
        if (availabilityServiceBean != null && availabilityServiceBean.sizeElementProperty() > 0) {
            ElementProperty[] props = availabilityServiceBean.getElementProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (!name.equalsIgnoreCase(propName)) continue;
                result = value;
            }
        }
        return result;
    }

    public String getHadbDatabaseNameFromConfig() {
        AvailabilityService as = this.getAvailabilityService();
        if (as == null) {
            return null;
        }
        return as.getHaStoreName();
    }

    public String getHadbDatabaseNameFromConfigDynamic() {
        AvailabilityService as = this.getAvailabilityServiceDynamic();
        if (as == null) {
            return null;
        }
        return as.getHaStoreName();
    }

    public String getHadbAgentPasswordFromConfig() {
        AvailabilityService as = this.getAvailabilityService();
        if (as == null) {
            return null;
        }
        return as.getHaAgentPassword();
    }

    public String getHaStoreHealthcheckIntervalInSecondsStringFromConfig() {
        AvailabilityService as = this.getAvailabilityService();
        if (as == null) {
            return null;
        }
        return as.getHaStoreHealthcheckIntervalInSeconds();
    }

    public int getHaStoreHealthcheckIntervalInSecondsFromConfig() {
        int returnValue;
        int candidateReturnValue;
        block4: {
            candidateReturnValue = -1;
            returnValue = 5;
            String returnValueString = this.getHaStoreHealthcheckIntervalInSecondsStringFromConfig();
            if (returnValueString != null) {
                try {
                    candidateReturnValue = Integer.valueOf(returnValueString);
                }
                catch (NumberFormatException ex) {
                    if (!_logger.isLoggable(Level.FINEST)) break block4;
                    _logger.finest("Using Default Value = 5");
                }
            }
        }
        if (candidateReturnValue > 0) {
            returnValue = candidateReturnValue;
        }
        return returnValue;
    }

    public String getHaStoreHealthcheckIntervalInSecondsStringFromConfigDynamic() {
        AvailabilityService as = this.getAvailabilityServiceDynamic();
        if (as == null) {
            return null;
        }
        return as.getHaStoreHealthcheckIntervalInSeconds();
    }

    public int getHaStoreHealthcheckIntervalInSecondsFromConfigDynamic() {
        int returnValue;
        int candidateReturnValue;
        block4: {
            candidateReturnValue = -1;
            returnValue = 5;
            String returnValueString = this.getHaStoreHealthcheckIntervalInSecondsStringFromConfigDynamic();
            if (returnValueString != null) {
                try {
                    candidateReturnValue = Integer.valueOf(returnValueString);
                }
                catch (NumberFormatException ex) {
                    if (!_logger.isLoggable(Level.FINEST)) break block4;
                    _logger.finest("Using Default Value = 5");
                }
            }
        }
        if (candidateReturnValue > 0) {
            returnValue = candidateReturnValue;
        }
        return returnValue;
    }

    public String getHadbAgentPortFromConfig() {
        AvailabilityService as = this.getAvailabilityService();
        if (as == null) {
            return null;
        }
        return as.getHaAgentPort();
    }

    public String getHadbAgentPortFromConfigDynamic() {
        AvailabilityService as = this.getAvailabilityServiceDynamic();
        if (as == null) {
            return null;
        }
        return as.getHaAgentPort();
    }

    public String getHadbAgentConnectionURLFromConfig() {
        String url = null;
        StringBuffer sb = new StringBuffer();
        String hostsString = this.getHadbAgentHostsFromConfig();
        String portString = this.getHadbAgentPortFromConfig();
        if (hostsString != null && portString != null) {
            sb.append(hostsString);
            sb.append(":");
            sb.append(portString);
            url = sb.toString();
        } else {
            url = null;
        }
        return url;
    }

    public String getHadbAgentConnectionURLFromConfigDynamic() {
        String url = null;
        StringBuffer sb = new StringBuffer();
        String hostsString = this.getHadbAgentHostsFromConfigDynamic();
        String portString = this.getHadbAgentPortFromConfigDynamic();
        if (hostsString != null && portString != null) {
            sb.append(hostsString);
            sb.append(":");
            sb.append(portString);
            url = sb.toString();
        } else {
            url = null;
        }
        return url;
    }

    public String getHadbAgentHostsFromConfig() {
        AvailabilityService as = this.getAvailabilityService();
        if (as == null) {
            return null;
        }
        return as.getHaAgentHosts();
    }

    public String getHadbAgentHostsFromConfigDynamic() {
        AvailabilityService as = this.getAvailabilityServiceDynamic();
        if (as == null) {
            return null;
        }
        return as.getHaAgentHosts();
    }

    public String getEEBuilderPathFromConfig() {
        return this.getWebContainerAvailabilityPropertyString("ee-builder-path", "com.sun.enterprise.ee.web.initialization");
    }

    public String getUuidGeneratorImplClassFromConfig() {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getUuidGeneratorImplClassFromConfig");
        }
        return this.getWebContainerAvailabilityPropertyString("uuid-impl-class", "com.sun.enterprise.util.uuid.UuidGeneratorImpl");
    }

    public UuidGenerator getUuidGeneratorFromConfig() {
        UuidGenerator generator = new UuidGeneratorImpl();
        String generatorImplClassName = this.getUuidGeneratorImplClassFromConfig();
        try {
            generator = (UuidGenerator)Class.forName(generatorImplClassName).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return generator;
    }

    public String getServerConfigValue(String xpath, String defaultValue) {
        ServerContext serverCtx;
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in ServerConfigLookup>>getServerConfigValue:xpath=" + xpath + " defaultValue= " + defaultValue);
        }
        if ((serverCtx = ApplicationServer.getServerContext()) == null) {
            return defaultValue;
        }
        ConfigContext configCtx = serverCtx.getConfigContext();
        ConfigBean configBean = null;
        String returnValueString = null;
        String returnValue = defaultValue;
        try {
            configBean = configCtx.exactLookup(xpath);
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        if (configBean != null) {
            returnValueString = configBean.getAttributeValue("value");
        }
        if (returnValueString != null) {
            returnValue = returnValueString;
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("RETURNED CONFIG VALUE FOR XPATH:" + xpath + " = " + returnValue);
        }
        return returnValue;
    }

    public int getServerConfigValue(String xpath, int defaultValue) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("in getServerConfigValue:xpath=" + xpath + " defaultValue= " + defaultValue);
        }
        ConfigContext configCtx = this.getConfigContext();
        ConfigBean configBean = null;
        String returnValueString = null;
        int returnValue = defaultValue;
        try {
            configBean = configCtx.exactLookup(xpath);
        }
        catch (ConfigException ex) {
            // empty catch block
        }
        if (configBean != null) {
            returnValueString = configBean.getAttributeValue("value");
        }
        if (returnValueString != null) {
            try {
                returnValue = Integer.valueOf(returnValueString);
            }
            catch (NumberFormatException ex) {
                _logger.finest("Using Default Value = " + defaultValue);
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("RETURNED CONFIG VALUE FOR XPATH:" + xpath + " = " + returnValue);
        }
        return returnValue;
    }

    public SessionManager getInstanceSessionManager() {
        Config configBean = this.getConfigBean();
        if (configBean == null) {
            return null;
        }
        WebContainer webContainerBean = configBean.getWebContainer();
        if (webContainerBean == null) {
            return null;
        }
        SessionConfig sessionConfigBean = webContainerBean.getSessionConfig();
        if (sessionConfigBean == null) {
            return null;
        }
        SessionManager smBean = sessionConfigBean.getSessionManager();
        return smBean;
    }

    public ManagerProperties getInstanceSessionManagerManagerProperties() {
        SessionManager smBean = this.getInstanceSessionManager();
        if (smBean == null) {
            return null;
        }
        return smBean.getManagerProperties();
    }

    public StoreProperties getInstanceSessionManagerStoreProperties() {
        SessionManager smBean = this.getInstanceSessionManager();
        if (smBean == null) {
            return null;
        }
        return smBean.getStoreProperties();
    }

    public SessionProperties getInstanceSessionProperties() {
        Config configBean = this.getConfigBean();
        if (configBean == null) {
            return null;
        }
        WebContainer webContainerBean = configBean.getWebContainer();
        if (webContainerBean == null) {
            return null;
        }
        SessionConfig sessionConfigBean = webContainerBean.getSessionConfig();
        if (sessionConfigBean == null) {
            return null;
        }
        SessionProperties spBean = sessionConfigBean.getSessionProperties();
        return spBean;
    }

    public String getConnectionUserFromConfig() {
        String user = null;
        JdbcConnectionPool pool = this.getHadbJdbcConnectionPoolFromConfig();
        if (pool == null) {
            return null;
        }
        if (pool.sizeElementProperty() > 0) {
            ElementProperty[] props = pool.getElementProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (!name.equalsIgnoreCase("User")) continue;
                user = value;
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN NEW getConnectionUserFromConfig: user=" + user);
        }
        return user;
    }

    public String getConnectionPasswordFromConfig() {
        String password = null;
        JdbcConnectionPool pool = this.getHadbJdbcConnectionPoolFromConfig();
        if (pool == null) {
            return null;
        }
        if (pool.sizeElementProperty() > 0) {
            ElementProperty[] props = pool.getElementProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (!name.equalsIgnoreCase("Password")) continue;
                password = value;
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN NEW getConnectionPasswordFromConfig: password=" + password);
        }
        return password;
    }

    public String getConnectionURLFromConfig() {
        String url = null;
        StringBuffer sb = new StringBuffer();
        JdbcConnectionPool pool = this.getHadbJdbcConnectionPoolFromConfig();
        if (pool == null) {
            return null;
        }
        if (pool.sizeElementProperty() > 0) {
            ElementProperty[] props = pool.getElementProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (!name.equalsIgnoreCase("serverList")) continue;
                sb.append("jdbc:sun:hadb:");
                sb.append(value);
                url = sb.toString();
            }
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN NEW getConnectionURLFromConfig: url=" + url);
        }
        return url;
    }

    public JdbcConnectionPool getHadbJdbcConnectionPoolFromConfig() {
        String storePoolJndiName = this.getHaStorePoolJndiNameFromConfig();
        if (storePoolJndiName == null) {
            return null;
        }
        Resources resources = this.getResourcesBean();
        JdbcResource jdbcResource = resources.getJdbcResourceByJndiName(storePoolJndiName);
        if (jdbcResource == null) {
            return null;
        }
        String poolName = jdbcResource.getPoolName();
        JdbcConnectionPool pool = resources.getJdbcConnectionPoolByName(poolName);
        return pool;
    }

    public String getHadbJdbcConnectionPoolNameFromConfig() {
        String storePoolJndiName = this.getHaStorePoolJndiNameFromConfig();
        if (storePoolJndiName == null) {
            return null;
        }
        Resources resources = this.getResourcesBean();
        JdbcResource jdbcResource = resources.getJdbcResourceByJndiName(storePoolJndiName);
        if (jdbcResource == null) {
            return null;
        }
        String poolName = jdbcResource.getPoolName();
        return poolName;
    }
}

