/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.appserv.server.util.ASClassLoaderUtil;
import com.sun.appserv.server.util.Version;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.event.AdminEventListenerRegistry;
import com.sun.enterprise.admin.event.ApplicationDeployEvent;
import com.sun.enterprise.admin.event.ApplicationDeployEventListener;
import com.sun.enterprise.admin.event.ModuleDeployEvent;
import com.sun.enterprise.admin.event.ModuleDeployEventListener;
import com.sun.enterprise.admin.monitor.registry.MonitoredObjectType;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevelListener;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.ServletStats;
import com.sun.enterprise.admin.monitor.stats.WebModuleStats;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationHelper;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.HttpProtocol;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.J2eeApplication;
import com.sun.enterprise.config.serverbeans.LogService;
import com.sun.enterprise.config.serverbeans.ModuleMonitoringLevels;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServicesDescriptor;
import com.sun.enterprise.deployment.runtime.web.CookieProperties;
import com.sun.enterprise.deployment.runtime.web.ManagerProperties;
import com.sun.enterprise.deployment.runtime.web.SessionConfig;
import com.sun.enterprise.deployment.runtime.web.SessionManager;
import com.sun.enterprise.deployment.runtime.web.SessionProperties;
import com.sun.enterprise.deployment.runtime.web.StoreProperties;
import com.sun.enterprise.deployment.runtime.web.SunWebApp;
import com.sun.enterprise.deployment.runtime.web.WebProperty;
import com.sun.enterprise.deployment.util.WebValidatorWithoutCL;
import com.sun.enterprise.instance.AppsManager;
import com.sun.enterprise.instance.InstanceEnvironment;
import com.sun.enterprise.instance.WebModulesManager;
import com.sun.enterprise.management.util.J2EEModuleUtil;
import com.sun.enterprise.security.SecurityUtil;
import com.sun.enterprise.security.web.SingleSignOn;
import com.sun.enterprise.server.ApplicationRegistry;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.server.StandaloneWebModulesManager;
import com.sun.enterprise.server.pluggable.WebContainerFeatureFactory;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.web.AdHocServletInfo;
import com.sun.enterprise.web.AdHocWebModule;
import com.sun.enterprise.web.DebugMonitor;
import com.sun.enterprise.web.EjbWebServiceRegistryListener;
import com.sun.enterprise.web.EmbeddedWebContainer;
import com.sun.enterprise.web.HealthChecker;
import com.sun.enterprise.web.MimeMap;
import com.sun.enterprise.web.MonitorUtil;
import com.sun.enterprise.web.PersistenceStrategyBuilder;
import com.sun.enterprise.web.PersistenceStrategyBuilderFactory;
import com.sun.enterprise.web.SSOFactory;
import com.sun.enterprise.web.SchemaUpdater;
import com.sun.enterprise.web.SessionManagerConfigurationHelper;
import com.sun.enterprise.web.SessionPurgeUtil;
import com.sun.enterprise.web.VirtualServer;
import com.sun.enterprise.web.WebContainerAdminEventProcessor;
import com.sun.enterprise.web.WebContainerStartStopOperation;
import com.sun.enterprise.web.WebContainerTimer;
import com.sun.enterprise.web.WebDebugMonitor;
import com.sun.enterprise.web.WebModule;
import com.sun.enterprise.web.WebModuleConfig;
import com.sun.enterprise.web.WebPipeline;
import com.sun.enterprise.web.logger.IASLogger;
import com.sun.enterprise.web.monitor.impl.PwcServletStatsImpl;
import com.sun.enterprise.web.monitor.impl.PwcWebModuleStatsImpl;
import com.sun.enterprise.web.session.PersistenceType;
import com.sun.enterprise.web.session.SessionCookieConfig;
import com.sun.enterprise.web.stats.ServletStatsImpl;
import com.sun.enterprise.web.stats.WebModuleStatsImpl;
import com.sun.logging.LogDomains;
import com.sun.web.security.RealmAdapter;
import com.sun.web.security.WebSecurityManager;
import com.sun.web.security.WebSecurityManagerFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimerTask;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.j2ee.statistics.Stats;
import javax.security.jacc.PolicyContextException;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.Valve;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.startup.DigesterFactory;
import org.apache.catalina.startup.TldConfig;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.ServerInfo;
import org.apache.catalina.valves.RemoteAddrValve;
import org.apache.catalina.valves.RemoteHostValve;
import org.apache.coyote.tomcat5.CoyoteRequest;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.xmlparser.ParserUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebContainer
implements Lifecycle,
ApplicationDeployEventListener,
ModuleDeployEventListener,
MonitoringLevelListener {
    public static final String DISABLED = "disabled";
    public static final String OFF = "off";
    public static final String ON = "on";
    public static final String STATE = "state";
    public static final String SSO_ENABLED = "sso-enabled";
    public static final String SSO_MAX_IDLE = "sso-max-inactive-seconds";
    public static final String SSO_REAP_INTERVAL = "sso-reap-interval-seconds";
    public static final String ADMIN_VS = "__asadmin";
    public static final String DISPATCHER_MAX_DEPTH = "dispatcher-max-depth";
    static final int DEFAULT_REAP_INTERVAL = 60;
    public static final String JWS_APPCLIENT_EAR_NAME = "__JWSappclients";
    public static final String JWS_APPCLIENT_WAR_NAME = "sys";
    private static final String JWS_APPCLIENT_MODULE_NAME = "__JWSappclients:sys.war";
    private static final String DOC_BUILDER_FACTORY_PROPERTY = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String DOC_BUILDER_FACTORY_IMPL = "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl";
    protected EmbeddedWebContainer _embedded;
    protected ServerContext _serverContext;
    protected ConfigContext _configContext;
    protected Domain domain;
    protected InstanceEnvironment instance;
    protected WebModulesManager webModulesManager;
    protected AppsManager appsManager;
    private Server _serverBean;
    private String _id;
    protected static Logger _logger = null;
    protected static ResourceBundle _rb = null;
    protected static MonitoringLevel monitoringLevel;
    protected Level _logLevel;
    protected int _debug;
    private String _modulesWorkRoot;
    private String modulesStubRoot;
    protected String _modulesRoot;
    private String _appsWorkRoot;
    private String appsStubRoot;
    private boolean _reloadingEnabled;
    private int _pollInterval;
    private StandaloneWebModulesManager _reloadManager;
    private LifecycleSupport _lifecycle;
    protected boolean _started;
    private WebSecurityManagerFactory webSecurityManagerFactory;
    private EjbWebServiceRegistryListener ejbWebServiceRegistryListener;
    private static final String DOL_DEPLOYMENT = "com.sun.enterprise.web.deployment.backend";
    protected static boolean useDOLforDeployment;
    private String instanceClassPath;
    protected static WebContainer webContainer;
    private static boolean debugMonitoring;
    private static long debugMonitoringPeriodMS;
    private static WebContainerTimer _timer;
    private HealthChecker _healthChecker;
    private WebContainerAdminEventProcessor _adminEventProcessor;

    protected WebContainer(String id, ServerContext context) {
        LogService logService;
        block14: {
            this._embedded = null;
            this._serverContext = null;
            this._configContext = null;
            this.domain = null;
            this.instance = null;
            this.webModulesManager = null;
            this.appsManager = null;
            this._serverBean = null;
            this._id = null;
            this._logLevel = null;
            this._debug = 0;
            this._modulesWorkRoot = null;
            this.modulesStubRoot = null;
            this._modulesRoot = null;
            this._appsWorkRoot = null;
            this.appsStubRoot = null;
            this._reloadingEnabled = false;
            this._pollInterval = 2;
            this._reloadManager = null;
            this._lifecycle = new LifecycleSupport(this);
            this._started = false;
            this.webSecurityManagerFactory = WebSecurityManagerFactory.getInstance();
            this._healthChecker = null;
            this._adminEventProcessor = null;
            this._id = id;
            this._serverContext = context;
            this._configContext = this._serverContext.getConfigContext();
            String rootDir = this._serverContext.getInstallRoot();
            String name = this._serverContext.getInstanceName();
            this.instance = new InstanceEnvironment(rootDir, name);
            this._modulesWorkRoot = this.instance.getWebModuleCompileJspPath();
            this._appsWorkRoot = this.instance.getApplicationCompileJspPath();
            this._modulesRoot = this.instance.getModuleRepositoryPath();
            this.instanceClassPath = this.getInstanceClassPath(this.instance);
            this.ejbWebServiceRegistryListener = new EjbWebServiceRegistryListener(this);
            this.modulesStubRoot = this.instance.getModuleStubPath();
            this.appsStubRoot = this.instance.getApplicationStubPath();
            if (_logger == null) {
                _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
                _rb = _logger.getResourceBundle();
            }
            try {
                this.webModulesManager = new WebModulesManager(this.instance);
                this.appsManager = new AppsManager(this.instance);
            }
            catch (ConfigException cx) {
                _logger.log(Level.WARNING, "Error in creating web modules manager: ", cx);
            }
            this.setNoTldScan();
            logService = null;
            try {
                this.domain = (Domain)this._configContext.getRootConfigBean();
                this._serverBean = ServerBeansFactory.getServerBean(this._configContext);
                this.getDynamicReloadingSettings(ServerBeansFactory.getDasConfigBean(this._configContext));
                Config cfg = ServerBeansFactory.getConfigBean(this._configContext);
                logService = cfg.getLogService();
                this.initLogLevel(logService);
                this.initMonitoringLevel(cfg.getMonitoringService());
                ElementProperty maxDepth = ServerBeansFactory.getWebContainerBean(this._configContext).getElementPropertyByName(DISPATCHER_MAX_DEPTH);
                if (maxDepth == null || maxDepth.getValue() == null) break block14;
                int depth = -1;
                try {
                    depth = Integer.parseInt(maxDepth.getValue());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (depth > 0) {
                    CoyoteRequest.setMaxDispatchDepth(depth);
                    if (_logger.isLoggable(Level.FINE)) {
                        _logger.fine("Maximum depth for nested request dispatches set to " + maxDepth.getValue());
                    }
                }
            }
            catch (ConfigException e) {
                _logger.log(Level.SEVERE, "webcontainer.configError", e);
            }
        }
        String logServiceFile = null;
        if (logService != null) {
            logServiceFile = logService.getFile();
        }
        this._embedded = new EmbeddedWebContainer(_logger, this._serverContext, this, logServiceFile);
        this._embedded.setUseNaming(false);
        if (this._debug > 1) {
            this._embedded.setDebug(this._debug);
        }
        this._embedded.setLogger(new IASLogger(_logger));
        DigesterFactory.setSchemaResourcePrefix("/schemas/");
        DigesterFactory.setDtdResourcePrefix("/dtds/");
        ParserUtils.setSchemaResourcePrefix("/schemas/");
        ParserUtils.setDtdResourcePrefix("/dtds/");
        String serverInfo = System.getProperty("product.name");
        if (serverInfo != null) {
            ServerInfo.setServerInfo(serverInfo);
        } else {
            ServerInfo.setServerInfo(Version.getVersion());
        }
        WebDebugMonitor debugMonitor = new WebDebugMonitor();
        HashMap monitorMap = debugMonitor.getDebugMonitoringDetails();
        debugMonitoring = (Boolean)monitorMap.get("debugMonitoring");
        debugMonitoringPeriodMS = (Long)monitorMap.get("debugMonitoringPeriodMS");
        if (debugMonitoring) {
            _timer.schedule((TimerTask)new DebugMonitor(this._embedded), 0L, debugMonitoringPeriodMS);
        }
    }

    public String getID() {
        return this._id;
    }

    public HealthChecker getHealthChecker() {
        return this._healthChecker;
    }

    private void initHealthChecker() {
        WebContainerFeatureFactory webContainerFeatureFactory = this._serverContext.getPluggableFeatureFactory().getWebContainerFeatureFactory();
        HealthChecker healthChecker = webContainerFeatureFactory.getHADBHealthChecker(this);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("WebContainer>>initHealthChecker - healthChecker = " + healthChecker);
        }
        if (healthChecker != null) {
            this._healthChecker = healthChecker;
            try {
                this._healthChecker.start();
            }
            catch (LifecycleException lifecycleException) {
                // empty catch block
            }
        }
    }

    private void stopHealthChecker() {
        if (this._healthChecker != null) {
            try {
                this._healthChecker.stop();
            }
            catch (LifecycleException lifecycleException) {
                // empty catch block
            }
            this._healthChecker = null;
        }
    }

    public void registerAdminEvents() {
        AdminEventListenerRegistry.addApplicationDeployEventListener(this);
        AdminEventListenerRegistry.addModuleDeployEventListener(this);
        WebContainerFeatureFactory webContainerFeatureFactory = this._serverContext.getPluggableFeatureFactory().getWebContainerFeatureFactory();
        this._adminEventProcessor = webContainerFeatureFactory.getWebContainerAdminEventProcessor();
        this._adminEventProcessor.init(this._embedded);
    }

    public void unregisterAdminEvents() {
        AdminEventListenerRegistry.removeEventListener(this);
        this._adminEventProcessor = null;
    }

    @Override
    public void applicationDeployed(ApplicationDeployEvent deployEvent) {
        this._adminEventProcessor.applicationDeployed(deployEvent);
    }

    @Override
    public void applicationUndeployed(ApplicationDeployEvent deployEvent) {
        this._adminEventProcessor.applicationUndeployed(deployEvent);
    }

    @Override
    public void applicationRedeployed(ApplicationDeployEvent deployEvent) {
        this._adminEventProcessor.applicationRedeployed(deployEvent);
    }

    @Override
    public void applicationEnabled(ApplicationDeployEvent deployEvent) {
    }

    @Override
    public void applicationDisabled(ApplicationDeployEvent deployEvent) {
    }

    @Override
    public void moduleDeployed(ModuleDeployEvent deployEvent) {
        this._adminEventProcessor.moduleDeployed(deployEvent);
    }

    @Override
    public void moduleUndeployed(ModuleDeployEvent deployEvent) {
        this._adminEventProcessor.moduleUndeployed(deployEvent);
    }

    @Override
    public void moduleRedeployed(ModuleDeployEvent deployEvent) {
        this._adminEventProcessor.moduleRedeployed(deployEvent);
    }

    @Override
    public void moduleEnabled(ModuleDeployEvent deployEvent) {
    }

    @Override
    public void moduleDisabled(ModuleDeployEvent deployEvent) {
    }

    public void registerMonitoringLevelEvents() {
        MonitoringRegistry monitoringRegistry = this._serverContext.getMonitoringRegistry();
        monitoringRegistry.registerMonitoringLevelListener((MonitoringLevelListener)this, MonitoredObjectType.SERVLET);
    }

    public void unregisterMonitoringLevelEvents() {
        MonitoringRegistry monitoringRegistry = this._serverContext.getMonitoringRegistry();
        monitoringRegistry.unregisterMonitoringLevelListener((MonitoringLevelListener)this);
    }

    public void setLevel(MonitoringLevel level) {
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, Stats handback) {
    }

    public void changeLevel(MonitoringLevel from, MonitoringLevel to, MonitoredObjectType type) {
        if (MonitoredObjectType.SERVLET.equals(type)) {
            monitoringLevel = to;
            if (MonitoringLevel.OFF.equals((Object)to)) {
                this.resetMonitorStatistics();
            }
        }
    }

    public static MonitoringLevel getMonitoringLevel() {
        return monitoringLevel;
    }

    public static boolean isMonitoringEnabled() {
        return !MonitoringLevel.OFF.equals((Object)monitoringLevel);
    }

    private void resetMonitorStatistics() {
        MonitorUtil.resetMonitorStats(this._embedded, this._serverContext);
    }

    public VirtualServer createVS(String vsID, com.sun.enterprise.config.serverbeans.VirtualServer vsBean, String docroot, String logFile, MimeMap mimeMap, HttpProtocol httpProtocol) {
        VirtualServer vs = (VirtualServer)this._embedded.createHost(vsID, vsBean, docroot, logFile, mimeMap);
        this.configureVirtualServerState(vs, vsBean);
        this.configureRemoteAddressFilterValve(vs, vsBean);
        this.configureRemoteHostFilterValve(vs, vsBean, httpProtocol);
        this.configureSSOValve(vs, vsBean);
        this.configureRedirect(vs, vsBean);
        this.configureErrorPage(vs, vsBean);
        return vs;
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this._lifecycle.addLifecycleListener(listener);
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this._lifecycle.removeLifecycleListener(listener);
    }

    private void doSchemaCheck() {
        SchemaUpdater schemaUpdater = this._serverContext.getPluggableFeatureFactory().getSchemaUpdater();
        try {
            schemaUpdater.doSchemaCheck();
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "schemaupdater.error", ex);
        }
    }

    @Override
    public void start() throws LifecycleException {
        if (this._started) {
            String msg = _rb.getString("webcontainer.alreadyStarted");
            throw new LifecycleException(msg);
        }
        if (System.getProperty(DOC_BUILDER_FACTORY_PROPERTY) == null) {
            System.setProperty(DOC_BUILDER_FACTORY_PROPERTY, DOC_BUILDER_FACTORY_IMPL);
        }
        this.registerAdminEvents();
        this.registerMonitoringLevelEvents();
        this.initHealthChecker();
        long btime = 0L;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("before schema check");
            btime = System.currentTimeMillis();
        }
        this.doSchemaCheck();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("after schema check time: " + (System.currentTimeMillis() - btime));
        }
        this.ejbWebServiceRegistryListener.register();
        Engine[] engines = this._embedded.getEngines();
        for (int j = 0; j < engines.length; ++j) {
            Container[] vsList = engines[j].findChildren();
            for (int i = 0; i < vsList.length; ++i) {
                this.loadWebModules((VirtualServer)vsList[i]);
            }
        }
        this.loadAllJ2EEApplicationWebModules(true);
        this.loadSystemDefaultWebModules();
        this._lifecycle.fireLifecycleEvent("start", null);
        this._started = true;
        this._embedded.start();
        if (this._reloadingEnabled) {
            com.sun.enterprise.config.serverbeans.WebModule[] wmBeans;
            Applications appsBean = null;
            try {
                appsBean = ServerBeansFactory.getApplicationsBean(this._configContext);
            }
            catch (ConfigException e) {
                String msg = _rb.getString("webcontainer.appsConfigError");
                _logger.log(Level.SEVERE, msg, e);
            }
            this._reloadManager = new StandaloneWebModulesManager(this._id, this._modulesRoot, this._pollInterval);
            if (appsBean != null && (wmBeans = appsBean.getWebModule()) != null && wmBeans.length > 0) {
                this._reloadManager.addWebModules(wmBeans);
            }
        }
        this.enableAllWSEndpoints();
    }

    @Override
    public void stop() throws LifecycleException {
        ArrayList shutdownCleanupCapablesList;
        WebContainerStartStopOperation startStopOperation;
        block4: {
            if (!this._started) {
                String msg = _rb.getString("webcontainer.notStarted");
                throw new LifecycleException(msg);
            }
            this.ejbWebServiceRegistryListener.unregister();
            this.unregisterAdminEvents();
            this.unregisterMonitoringLevelEvents();
            this.stopHealthChecker();
            startStopOperation = this.getWebContainerStartStopOperation();
            shutdownCleanupCapablesList = startStopOperation.doPreStop();
            this._started = false;
            try {
                this._embedded.stop();
            }
            catch (LifecycleException ex) {
                if (ex.getMessage().indexOf("has not been started") != -1) break block4;
                throw ex;
            }
        }
        if (this._reloadManager != null) {
            this._reloadManager.stop();
            this._reloadManager = null;
        }
        startStopOperation.doPostStop(shutdownCleanupCapablesList);
    }

    public WebContainerStartStopOperation getWebContainerStartStopOperation() {
        WebContainerFeatureFactory webContainerFeatureFactory = this._serverContext.getPluggableFeatureFactory().getWebContainerFeatureFactory();
        WebContainerStartStopOperation startStopOperation = webContainerFeatureFactory.getWebContainerStartStopOperation();
        startStopOperation.init(this._embedded);
        return startStopOperation;
    }

    protected void loadWebModules(VirtualServer vs) {
        WebModuleConfig wmInfo = null;
        this.loadDefaultWebModule(vs, this._serverBean);
        List modules = vs.getWebModules(this._serverBean, this._modulesRoot);
        if (modules != null && modules.size() > 0) {
            ListIterator iterator = modules.listIterator();
            while (iterator.hasNext()) {
                wmInfo = (WebModuleConfig)iterator.next();
                com.sun.enterprise.config.serverbeans.WebModule webBean = wmInfo.getBean();
                if (webBean == null || !this.isEnabled(webBean.getConfigContext(), webBean.getName())) continue;
                this.loadStandaloneWebModule(vs, wmInfo);
            }
        }
    }

    public void loadDefaultWebModule(VirtualServer vs, Server serverBean) {
        WebModuleConfig wmInfo = vs.getUserDefaultWebModuleConfig(serverBean);
        if (wmInfo != null) {
            this.loadStandaloneWebModule(vs, wmInfo);
        }
    }

    protected void loadSystemDefaultWebModules() {
        Engine[] engines = this._embedded.getEngines();
        for (int j = 0; j < engines.length; ++j) {
            Container[] vsArray = engines[j].findChildren();
            for (int i = 0; i < vsArray.length; ++i) {
                VirtualServer vs;
                WebModuleConfig wmInfo;
                if (!(vsArray[i] instanceof VirtualServer) || (wmInfo = (vs = (VirtualServer)vsArray[i]).createSystemDefaultWebModuleIfNecessary()) == null) continue;
                this.loadStandaloneWebModule(vs, wmInfo);
            }
        }
    }

    protected void loadStandaloneWebModule(VirtualServer vs, WebModuleConfig wmInfo) {
        this.loadWebModule(vs, wmInfo, "null");
    }

    protected void loadAllJ2EEApplicationWebModules() {
        this.loadAllJ2EEApplicationWebModules(false);
    }

    private void loadAllJ2EEApplicationWebModules(boolean isStartUp) {
        J2eeApplication[] j2eeAppBeans;
        Applications appsBean = null;
        try {
            appsBean = ServerBeansFactory.getApplicationsBean(this._configContext);
        }
        catch (ConfigException e) {
            String msg = _rb.getString("webcontainer.appsConfigError");
            _logger.log(Level.SEVERE, msg, e);
        }
        if (appsBean != null && (j2eeAppBeans = appsBean.getJ2eeApplication()) != null) {
            for (int i = 0; i < j2eeAppBeans.length; ++i) {
                if (!this.isReferenced(j2eeAppBeans[i].getName())) continue;
                this.loadJ2EEApplicationWebModules(j2eeAppBeans[i]);
            }
        }
    }

    public void loadJ2EEApplicationWebModules(J2eeApplication j2eeAppBean) {
        if (j2eeAppBean != null && this.isEnabled(j2eeAppBean.getConfigContext(), j2eeAppBean.getName())) {
            String id = j2eeAppBean.getName();
            String location = j2eeAppBean.getLocation();
            String resourceType = j2eeAppBean.getObjectType();
            ApplicationRegistry registry = ApplicationRegistry.getInstance();
            ClassLoader appLoader = registry.getClassLoaderForApplication(id);
            if (appLoader != null) {
                Application appDesc = registry.getApplication(appLoader);
                if (appDesc == null) {
                    Object[] params = new Object[]{id};
                    _logger.log(Level.SEVERE, "webcontainer.notLoaded", params);
                } else {
                    ConfigContext eventConfigContext = j2eeAppBean.getConfigContext();
                    String j2eeApplication = appDesc.getRegistrationName();
                    Set wbds = appDesc.getWebBundleDescriptors();
                    WebBundleDescriptor wbd = null;
                    com.sun.enterprise.config.serverbeans.WebModule wm = null;
                    WebModuleConfig wmInfo = null;
                    Iterator itr = wbds.iterator();
                    while (itr.hasNext()) {
                        StringBuffer dir = new StringBuffer(location);
                        wbd = (WebBundleDescriptor)itr.next();
                        String moduleName = wbd.getModuleDescriptor().getArchiveUri();
                        dir.append(File.separator);
                        dir.append(FileUtils.makeFriendlyFilename(moduleName));
                        wm = new com.sun.enterprise.config.serverbeans.WebModule();
                        wm.setConfigContext(eventConfigContext);
                        wm.setName(moduleName);
                        wm.setContextRoot(wbd.getContextRoot());
                        wm.setLocation(dir.toString());
                        wm.setEnabled(true);
                        wm.setObjectType(resourceType);
                        wmInfo = new WebModuleConfig();
                        wmInfo.setBean(wm);
                        wmInfo.setDescriptor(wbd);
                        wmInfo.setParentLoader(appLoader);
                        wmInfo.setVirtualServers(this.getVirtualServers(id, j2eeAppBean.getConfigContext()));
                        this.loadWebModule(wmInfo, j2eeApplication);
                    }
                }
            }
        }
    }

    protected boolean isEnabled(ConfigContext config, String moduleName) {
        try {
            if (config == null) {
                config = this._configContext;
            }
            ConfigBean app = ApplicationHelper.findApplication(config, moduleName);
            Server server = ServerBeansFactory.getServerBean(config);
            ApplicationRef appRef = server.getApplicationRefByRef(moduleName);
            return app != null && app.isEnabled() && appRef != null && appRef.isEnabled();
        }
        catch (ConfigException e) {
            _logger.log(Level.WARNING, "Error finding " + moduleName, e);
            return false;
        }
    }

    public List<Throwable> loadWebModule(WebModuleConfig wmInfo, String j2eeApplication) {
        String vsIDs = wmInfo.getVirtualServers();
        List vsList = StringUtils.parseStringList(vsIDs, " ,");
        boolean loadToAll = vsList == null || vsList.size() == 0;
        boolean loadAtLeastToOne = false;
        Engine[] engines = this._embedded.getEngines();
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        for (int j = 0; j < engines.length; ++j) {
            Container[] vsArray = engines[j].findChildren();
            for (int i = 0; i < vsArray.length; ++i) {
                VirtualServer vs;
                if (!(vsArray[i] instanceof VirtualServer) || (vs = (VirtualServer)vsArray[i]).getID().equals(ADMIN_VS) && loadToAll || !loadToAll && !vsList.contains(vs.getID()) && !this.verifyAlias(vsList, vs)) continue;
                Throwable t = this.loadWebModule(vs, wmInfo, j2eeApplication);
                if (t != null) {
                    throwables.add(t);
                }
                loadAtLeastToOne = true;
            }
        }
        if (!loadAtLeastToOne) {
            Object[] params = new Object[]{wmInfo.getName(), vsIDs};
            _logger.log(Level.SEVERE, "webcontainer.moduleNotLoadedToVS", params);
        }
        return throwables;
    }

    private boolean verifyAlias(List vsList, VirtualServer vs) {
        for (int i = 0; i < vs.getAliases().length; ++i) {
            if (!vsList.contains(vs.getAliases()[i])) continue;
            return true;
        }
        return false;
    }

    protected Throwable loadWebModule(VirtualServer vs, WebModuleConfig wmInfo, String j2eeApplication) {
        ClassLoader parentLoader;
        String wmName = wmInfo.getName();
        if (wmName.indexOf(":") != -1) {
            wmInfo.setWorkDirBase(this._appsWorkRoot);
            wmInfo.setStubBaseDir(this.appsStubRoot);
        } else {
            wmInfo.setWorkDirBase(this._modulesWorkRoot);
            wmInfo.setStubBaseDir(this.modulesStubRoot);
        }
        String wmContextPath = wmInfo.getContextPath();
        String displayContextPath = null;
        displayContextPath = wmContextPath.equals("") ? "/" : wmContextPath;
        HashMap adHocPaths = null;
        HashMap adHocSubtrees = null;
        WebModule ctx = (WebModule)vs.findChild(wmContextPath);
        if (ctx != null) {
            if (ctx instanceof AdHocWebModule) {
                if (ctx.hasAdHocPaths()) {
                    adHocPaths = ctx.getAdHocPaths();
                }
                if (ctx.hasAdHocSubtrees()) {
                    adHocSubtrees = ctx.getAdHocSubtrees();
                }
                vs.removeChild(ctx);
            } else if ("__default-web-module".equals(ctx.getModuleName())) {
                this.unloadWebModule(wmContextPath, ctx.getJ2EEApplication(), vs.getName(), null, true);
            } else {
                if (!ctx.getAvailable()) {
                    ctx.setAvailable(true);
                    return null;
                }
                Object[] params = new Object[]{vs.getID(), displayContextPath, wmName};
                _logger.log(Level.WARNING, "webcontainer.duplicateContextRoot", params);
                return null;
            }
        }
        Object[] params = new Object[]{wmName, vs.getID(), displayContextPath};
        if (wmName.equals("__default-web-module")) {
            _logger.log(Level.FINE, "webcontainer.loadModule", params);
        } else {
            _logger.log(Level.INFO, "webcontainer.loadModule", params);
        }
        String docBase = null;
        if (JWS_APPCLIENT_MODULE_NAME.equals(wmName)) {
            File installRootFile = new File(System.getProperty("com.sun.aas.installRoot"));
            String path = installRootFile.toURI().getPath();
            if (OS.isWindows()) {
                path = path.substring(1);
            }
            docBase = path;
        } else {
            docBase = wmInfo.getLocation();
        }
        ctx = (WebModule)this._embedded.createContext(wmContextPath, docBase, vs.getDefaultWebXmlLocation(), useDOLforDeployment, wmInfo.getDescriptor());
        String engineName = vs.getParent().getName();
        String j2eeServer = this._serverContext.getInstanceName();
        String domain = this._serverContext.getDefaultDomainName();
        String server = domain + ":j2eeType=J2EEServer,name=" + j2eeServer;
        String[] javaVMs = J2EEModuleUtil.getjavaVMs();
        ctx.setDomain(domain);
        ctx.setJ2EEServer(j2eeServer);
        ctx.setJ2EEApplication(j2eeApplication);
        ctx.setEngineName(engineName);
        ctx.setServer(server);
        ctx.setJavaVMs(javaVMs);
        ctx.setCachingAllowed(true);
        ctx.setCacheControls(vs.getCacheControls());
        if (adHocPaths != null) {
            ctx.addAdHocPaths(adHocPaths);
        }
        if (adHocSubtrees != null) {
            ctx.addAdHocSubtrees(adHocSubtrees);
        }
        WebBundleDescriptor wbd = wmInfo.getDescriptor();
        if (wmInfo.getBean() != null) {
            String contextRoot = wmInfo.getBean().getContextRoot();
            ctx.setContextRoot(contextRoot);
            if (wbd != null) {
                wbd.setContextRoot(contextRoot);
            }
        } else {
            _logger.log(Level.WARNING, "Unable to set context root", wmInfo);
        }
        String wmInfoWorkDir = wmInfo.getWorkDir();
        if (wmInfoWorkDir != null) {
            StringBuffer workDir = new StringBuffer(wmInfo.getWorkDir());
            if (wmName.equals("__default-web-module")) {
                workDir.append("-");
                workDir.append(FileUtils.makeFriendlyFilename(vs.getID()));
            }
            ctx.setWorkDir(workDir.toString());
        }
        if ((parentLoader = wmInfo.getParentLoader()) == null) {
            parentLoader = this._serverContext.getSharedClassLoader();
        }
        ctx.setParentClassLoader(parentLoader);
        Throwable exception = null;
        Switch sw = Switch.getSwitch();
        try {
            if (wbd != null) {
                String altDDName = wbd.getModuleDescriptor().getAlternateDescriptor();
                if (altDDName != null) {
                    String appName = wmName.substring(0, wmName.indexOf(":"));
                    String appLoc = this.appsManager.getGeneratedXMLLocation(appName);
                    if (!FileUtils.safeIsDirectory(appLoc)) {
                        appLoc = wmInfo.getLocation() + "/..";
                    }
                    altDDName = altDDName.startsWith("/") ? appLoc + altDDName.trim() : appLoc + "/" + altDDName.trim();
                    Object[] objs = new Object[]{altDDName, wmName};
                    _logger.log(Level.INFO, "webcontainer.altDDName", objs);
                    ctx.setAltDDName(altDDName);
                }
                if (wbd.hasWebServices()) {
                    ctx.setHasWebServices(true);
                    WebServicesDescriptor webService = wbd.getWebServices();
                    Vector<String> endpointList = new Vector<String>();
                    for (WebServiceEndpoint wse : webService.getEndpoints()) {
                        if (wbd.getContextRoot() != null) {
                            endpointList.add(wbd.getContextRoot() + "/" + wse.getEndpointAddressUri());
                            continue;
                        }
                        endpointList.add(wse.getEndpointAddressUri());
                    }
                    Object[] endpointAddresses = new String[endpointList.size()];
                    endpointList.copyInto(endpointAddresses);
                    ctx.setEndpointAddresses((String[])endpointAddresses);
                } else {
                    ctx.setHasWebServices(false);
                }
            }
            SunWebApp iasBean = null;
            if (wbd != null) {
                iasBean = wbd.getSunDescriptor();
            }
            ctx.setIasWebAppConfigBean(iasBean);
            ctx.setID(wmName);
            Loader loader = this.configureLoader(ctx, iasBean, wmInfo);
            if (wbd != null && wbd.hasWebServices()) {
                wbd.addExtraAttribute("WEBLOADER", loader);
            }
            if (this._reloadingEnabled) {
                if (this._reloadManager == null) {
                    this._reloadManager = new StandaloneWebModulesManager(this._id, this._modulesRoot, this._pollInterval);
                }
                this._reloadManager.addWebModule(wmInfo.getBean());
            }
            this.configureMiscSettings(ctx, iasBean, vs, displayContextPath);
            this.configureSessionSettings(ctx, iasBean, wbd, wmInfo);
            ctx.setI18nInfo();
            if (wbd != null) {
                String resourceType = wmInfo.getBean().getObjectType();
                boolean isSystem = resourceType != null && resourceType.startsWith("system-");
                ctx.setRealm(new RealmAdapter(wbd, isSystem));
                this.configureSecurity(wbd, isSystem);
                sw.setDescriptorFor(ctx, wbd);
                if (wbd.getApplication() != null && wbd.getApplication().isVirtual()) {
                    wbd.visit(new WebValidatorWithoutCL());
                }
                sw.getNamingManager().bindObjects(wbd);
            }
            this.addMimeMappings(ctx, vs.getMimeMap());
        }
        catch (Throwable ex) {
            exception = ex;
        }
        if (wbd != null && wbd.getApplication() != null) {
            sw.setDescriptorFor(ctx, wbd);
            String moduleName = wbd.getApplication().isVirtual() ? wbd.getApplication().getRegistrationName() : wbd.getModuleDescriptor().getArchiveUri();
            ctx.setModuleName(moduleName);
        } else {
            ctx.setModuleName("__default-web-module");
        }
        try {
            vs.addChild(ctx);
        }
        catch (Throwable ex) {
            exception = ex;
        }
        if (exception != null) {
            ctx.setAvailable(false);
            Object[] objs = new Object[]{wmName, exception};
            _logger.log(Level.SEVERE, "webcontainer.webModuleDisabled", objs);
        }
        this.enableWSMonitoring(wbd, j2eeServer);
        return exception;
    }

    protected void configureSecurity(WebBundleDescriptor wbd, boolean isSystem) {
        try {
            this.webSecurityManagerFactory.newWebSecurityManager(wbd);
            String context = WebSecurityManager.getContextID(wbd);
            SecurityUtil.generatePolicyFile(context);
        }
        catch (Exception ce) {
            _logger.log(Level.SEVERE, "webcontainer.configureSecurity", ce);
            throw new RuntimeException(ce);
        }
    }

    public ServerContext getServerContext() {
        return this._serverContext;
    }

    private Loader configureLoader(WebModule ctx, SunWebApp bean, WebModuleConfig wmInfo) {
        com.sun.enterprise.deployment.runtime.web.ClassLoader clBean = null;
        Loader loader = this._embedded.createLoader(ctx.getParentClassLoader());
        if (bean != null) {
            clBean = bean.getClassLoader();
        }
        if (clBean != null) {
            this.configureLoaderAttributes(loader, clBean, ctx);
            this.configureLoaderProperties(loader, clBean);
        } else {
            loader.setDelegate(true);
        }
        String stubPath = wmInfo.getStubPath();
        if (stubPath != null) {
            loader.addRepository("file:" + stubPath + File.separator);
        }
        this.addLibs(loader, ctx);
        String packagesName = System.getProperty("com.sun.enterprise.overrideablejavaxpackages");
        if (packagesName != null) {
            List overridablePackages = StringUtils.parseStringList(packagesName, " ,");
            for (int i = 0; i < overridablePackages.size(); ++i) {
                loader.addOverridablePackage((String)overridablePackages.get(i));
            }
        }
        ctx.setLoader(loader);
        return loader;
    }

    private void configureMiscSettings(WebModule ctx, SunWebApp bean, VirtualServer vs, String contextPath) {
        boolean allowLinking = vs.getAllowLinking();
        if (bean != null && bean.sizeWebProperty() > 0) {
            WebProperty[] props = bean.getWebProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (name == null || value == null) {
                    throw new IllegalArgumentException(_rb.getString("webcontainer.nullWebProperty"));
                }
                if (name.equalsIgnoreCase("singleThreadedServletPoolSize")) {
                    int poolSize = ctx.getSTMPoolSize();
                    try {
                        poolSize = Integer.parseInt(value);
                    }
                    catch (NumberFormatException e) {
                        Object[] params = new Object[]{value, contextPath, Integer.toString(poolSize)};
                        _logger.log(Level.WARNING, "webcontainer.invalidServletPoolSize", params);
                    }
                    if (poolSize <= 0) continue;
                    ctx.setSTMPoolSize(poolSize);
                    continue;
                }
                if (name.equalsIgnoreCase("tempdir")) {
                    ctx.setWorkDir(value);
                    continue;
                }
                if (name.equalsIgnoreCase("crossContextAllowed")) {
                    boolean crossContext = ConfigBean.toBoolean(value);
                    ctx.setCrossContext(crossContext);
                    continue;
                }
                if (name.equalsIgnoreCase("allowLinking")) {
                    allowLinking = ConfigBean.toBoolean(value);
                    continue;
                }
                if (name.equalsIgnoreCase("reuseSessionID")) {
                    boolean reuse = ConfigBean.toBoolean(value);
                    ctx.setReuseSessionID(reuse);
                    if (!reuse) continue;
                    Object[] params = new Object[]{contextPath, vs.getID()};
                    _logger.log(Level.WARNING, "webcontainer.sessionIDsReused", params);
                    continue;
                }
                if (name.equalsIgnoreCase("useResponseCTForHeaders")) {
                    if (!value.equalsIgnoreCase("true")) continue;
                    ctx.setResponseCTForHeaders();
                    continue;
                }
                if (name.equalsIgnoreCase("encodeCookies")) {
                    boolean flag = ConfigBean.toBoolean(value);
                    ctx.setEncodeCookies(flag);
                    continue;
                }
                if (name.equalsIgnoreCase("relativeRedirectAllowed")) {
                    boolean relativeRedirect = ConfigBean.toBoolean(value);
                    ctx.setAllowRelativeRedirect(relativeRedirect);
                    continue;
                }
                if (name.equalsIgnoreCase("fileEncoding")) {
                    ctx.setFileEncoding(value);
                    continue;
                }
                if (name.equalsIgnoreCase("enableTldValidation") && ConfigBean.toBoolean(value)) {
                    ctx.setTldValidation(true);
                    continue;
                }
                if (name.equalsIgnoreCase("enableTldNamespaceAware") && ConfigBean.toBoolean(value)) {
                    ctx.setTldNamespaceAware(true);
                    continue;
                }
                Object[] params = new Object[]{name, value};
                _logger.log(Level.WARNING, "webcontainer.invalidProperty", params);
            }
        }
        ctx.setAllowLinking(allowLinking);
    }

    private void configureSessionSettings(WebModule ctx, SunWebApp bean, WebBundleDescriptor wbd, WebModuleConfig wmInfo) {
        SessionConfig cfg = null;
        SessionManager smBean = null;
        SessionProperties sessionBean = null;
        CookieProperties cookieBean = null;
        if (bean != null) {
            cfg = bean.getSessionConfig();
        }
        if (cfg != null) {
            smBean = cfg.getSessionManager();
        }
        if (cfg != null) {
            sessionBean = cfg.getSessionProperties();
        }
        if (cfg != null) {
            cookieBean = cfg.getCookieProperties();
        }
        this.configureSessionManager(ctx, smBean, wbd, wmInfo);
        this.configureSession(ctx, sessionBean, wbd);
        this.configureCookieProperties(ctx, cookieBean);
    }

    public String getApplicationId(WebModule wm) {
        return wm.getID();
    }

    public String getModulesRoot() {
        return this._modulesRoot;
    }

    private void configureSessionManager(WebModule ctx, SessionManager smBean, WebBundleDescriptor wbd, WebModuleConfig wmInfo) {
        PersistenceType persistence = PersistenceType.MEMORY;
        String frequency = null;
        String scope = null;
        SessionManagerConfigurationHelper configHelper = new SessionManagerConfigurationHelper(ctx, smBean, wbd, wmInfo);
        persistence = configHelper.getPersistenceType();
        frequency = configHelper.getPersistenceFrequency();
        scope = configHelper.getPersistenceScope();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("IN WebContainer>>ConfigureSessionManager before builder factory");
            _logger.finest("FINAL_PERSISTENCE-TYPE IS = " + persistence.getType());
            _logger.finest("FINAL_PERSISTENCE_FREQUENCY IS = " + frequency);
            _logger.finest("FINAL_PERSISTENCE_SCOPE IS = " + scope);
        }
        PersistenceStrategyBuilderFactory factory = new PersistenceStrategyBuilderFactory();
        PersistenceStrategyBuilder builder = factory.createPersistenceStrategyBuilder(persistence.getType(), frequency, scope, ctx);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("PersistenceStrategyBuilder class = " + builder.getClass().getName());
        }
        builder.setLogger(_logger);
        builder.initializePersistenceStrategy(ctx, smBean);
    }

    private String getPersistenceFrequency(SessionManager smBean) {
        String persistenceFrequency = null;
        ManagerProperties mgrBean = smBean.getManagerProperties();
        if (mgrBean != null && mgrBean.sizeWebProperty() > 0) {
            WebProperty[] props = mgrBean.getWebProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (name == null || value == null) {
                    throw new IllegalArgumentException(_rb.getString("webcontainer.nullWebProperty"));
                }
                if (!name.equalsIgnoreCase("persistenceFrequency")) continue;
                persistenceFrequency = value;
                break;
            }
        }
        return persistenceFrequency;
    }

    private String getPersistenceScope(SessionManager smBean) {
        String persistenceScope = null;
        StoreProperties storeBean = smBean.getStoreProperties();
        if (storeBean != null && storeBean.sizeWebProperty() > 0) {
            WebProperty[] props = storeBean.getWebProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (name == null || value == null) {
                    throw new IllegalArgumentException(_rb.getString("webcontainer.nullWebProperty"));
                }
                if (!name.equalsIgnoreCase("persistenceScope")) continue;
                persistenceScope = value;
                break;
            }
        }
        return persistenceScope;
    }

    private void configureSession(WebModule ctx, SessionProperties spBean, WebBundleDescriptor wbd) {
        boolean timeoutConfigured = false;
        int timeoutSeconds = 1800;
        boolean enableCookies = true;
        if (spBean != null && spBean.sizeWebProperty() > 0) {
            WebProperty[] props = spBean.getWebProperty();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (name == null || value == null) {
                    throw new IllegalArgumentException(_rb.getString("webcontainer.nullWebProperty"));
                }
                if (name.equalsIgnoreCase("timeoutSeconds")) {
                    try {
                        timeoutSeconds = Integer.parseInt(value);
                        timeoutConfigured = true;
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (name.equalsIgnoreCase("enableCookies")) {
                    enableCookies = ConfigBean.toBoolean(value);
                    continue;
                }
                Object[] params = new Object[]{name};
                _logger.log(Level.INFO, "webcontainer.notYet", params);
            }
        }
        int webXmlTimeoutSeconds = -1;
        if (wbd != null) {
            webXmlTimeoutSeconds = wbd.getSessionTimeout() * 60;
        }
        if (webXmlTimeoutSeconds != -1 && webXmlTimeoutSeconds != 1800) {
            ctx.getManager().setMaxInactiveIntervalSeconds(webXmlTimeoutSeconds);
        } else if (timeoutConfigured) {
            ctx.getManager().setMaxInactiveIntervalSeconds(timeoutSeconds);
        }
        ctx.setCookies(enableCookies);
    }

    private void configureCookieProperties(WebModule ctx, CookieProperties bean) {
        WebProperty[] props;
        if (bean != null && (props = bean.getWebProperty()) != null) {
            SessionCookieConfig cookieConfig = new SessionCookieConfig();
            for (int i = 0; i < props.length; ++i) {
                String name = props[i].getAttributeValue("name");
                String value = props[i].getAttributeValue("value");
                if (name == null || value == null) {
                    throw new IllegalArgumentException(_rb.getString("webcontainer.nullWebProperty"));
                }
                if (name.equalsIgnoreCase("cookieName")) {
                    cookieConfig.setName(value);
                    continue;
                }
                if (name.equalsIgnoreCase("cookiePath")) {
                    cookieConfig.setPath(value);
                    continue;
                }
                if (name.equalsIgnoreCase("cookieMaxAgeSeconds")) {
                    try {
                        cookieConfig.setMaxAge(Integer.parseInt(value));
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (name.equalsIgnoreCase("cookieDomain")) {
                    cookieConfig.setDomain(value);
                    continue;
                }
                if (name.equalsIgnoreCase("cookieComment")) {
                    cookieConfig.setComment(value);
                    continue;
                }
                Object[] params = new Object[]{name, value};
                _logger.log(Level.WARNING, "webcontainer.invalidProperty", params);
            }
            if (props.length > 0) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("WebModule[" + ctx.getPath() + "]: " + cookieConfig);
                }
                ctx.setSessionCookieConfig(cookieConfig);
            }
        }
    }

    protected void configureVirtualServerState(VirtualServer host, com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        String stateValue = ON;
        if (vsBean != null) {
            stateValue = vsBean.getState();
        }
        if (!stateValue.equalsIgnoreCase(ON) && host.getName().equalsIgnoreCase(ADMIN_VS)) {
            throw new IllegalArgumentException("virtual-server __asadmin state property cannot be modified");
        }
        if (stateValue.equalsIgnoreCase(DISABLED)) {
            host.setIsDisabled(true);
        } else if (!ConfigBean.toBoolean(stateValue)) {
            host.setIsOff(true);
        }
    }

    private void configureSSOValve(VirtualServer vs, com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        if (vsBean == null) {
            return;
        }
        if (!this.isSSOEnabled(vsBean)) {
            Object[] params = new Object[]{vs.getID()};
            _logger.log(Level.INFO, "webcontainer.ssodisabled", params);
        } else {
            try {
                ElementProperty expireTime;
                ElementProperty idle;
                WebContainerFeatureFactory webContainerFeatureFactory = this._serverContext.getPluggableFeatureFactory().getWebContainerFeatureFactory();
                SSOFactory ssoFactory = webContainerFeatureFactory.getSSOFactory();
                SingleSignOn sso = ssoFactory.createSingleSignOnValve();
                if (this._debug > 1) {
                    sso.setDebug(this._debug);
                }
                if ((idle = vsBean.getElementPropertyByName(SSO_MAX_IDLE)) != null && idle.getValue() != null) {
                    _logger.fine("SSO entry max idle time set to: " + idle.getValue());
                    int i = Integer.parseInt(idle.getValue());
                    sso.setMaxInactive(i);
                }
                if ((expireTime = vsBean.getElementPropertyByName(SSO_REAP_INTERVAL)) != null && expireTime.getValue() != null) {
                    _logger.fine("SSO expire thread interval set to : " + expireTime.getValue());
                    int i = Integer.parseInt(expireTime.getValue());
                    sso.setReapInterval(i);
                }
                vs.addValve(sso);
            }
            catch (Exception e) {
                _logger.log(Level.WARNING, "webcontainer.ssobadconfig", e);
                _logger.log(Level.WARNING, "webcontainer.ssodisabled", vs.getID());
            }
        }
    }

    public void configureRemoteAddressFilterValve(VirtualServer vs, com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        RemoteAddrValve remoteAddrValve = null;
        if (vsBean == null) {
            return;
        }
        ElementProperty allow = vsBean.getElementPropertyByName("allowRemoteAddress");
        ElementProperty deny = vsBean.getElementPropertyByName("denyRemoteAddress");
        if (allow != null && allow.getValue() != null || deny != null && deny.getValue() != null) {
            remoteAddrValve = new RemoteAddrValve();
        }
        if (allow != null && allow.getValue() != null) {
            _logger.fine("Allowing access to " + vs.getID() + " from " + allow.getValue());
            remoteAddrValve.setAllow(allow.getValue());
        }
        if (deny != null && deny.getValue() != null) {
            _logger.fine("Denying access to " + vs.getID() + " from " + deny.getValue());
            remoteAddrValve.setDeny(deny.getValue());
        }
        if (remoteAddrValve != null) {
            Valve[] valves = vs.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof RemoteAddrValve)) continue;
                vs.removeValve(valves[i]);
                break;
            }
            vs.addValve(remoteAddrValve);
        }
    }

    public void configureRemoteHostFilterValve(VirtualServer vs, com.sun.enterprise.config.serverbeans.VirtualServer vsBean, HttpProtocol httpProtocol) {
        RemoteHostValve remoteHostValve = null;
        if (vsBean == null) {
            return;
        }
        ElementProperty allow = vsBean.getElementPropertyByName("allowRemoteHost");
        ElementProperty deny = vsBean.getElementPropertyByName("denyRemoteHost");
        if (allow != null && allow.getValue() != null || deny != null && deny.getValue() != null) {
            remoteHostValve = new RemoteHostValve();
        }
        if (allow != null && allow.getValue() != null) {
            _logger.fine("Allowing access to " + vs.getID() + " from " + allow.getValue());
            if (httpProtocol == null || !httpProtocol.isDnsLookupEnabled()) {
                _logger.log(Level.WARNING, "webcontainer.allowRemoteHost.dnsLookupDisabled", vs.getID());
            }
            remoteHostValve.setAllow(allow.getValue());
        }
        if (deny != null && deny.getValue() != null) {
            _logger.fine("Denying access to " + vs.getID() + " from " + deny.getValue());
            if (httpProtocol == null || !httpProtocol.isDnsLookupEnabled()) {
                _logger.log(Level.WARNING, "webcontainer.denyRemoteHost.dnsLookupDisabled", vs.getID());
            }
            remoteHostValve.setDeny(deny.getValue());
        }
        if (remoteHostValve != null) {
            Valve[] valves = vs.getValves();
            for (int i = 0; valves != null && i < valves.length; ++i) {
                if (!(valves[i] instanceof RemoteHostValve)) continue;
                vs.removeValve(valves[i]);
                break;
            }
            vs.addValve(remoteHostValve);
        }
    }

    public void unloadWebModule(String contextRoot, String appName, String virtualServers, WebBundleDescriptor wbd) {
        this.unloadWebModule(contextRoot, appName, virtualServers, wbd, false);
    }

    public void unloadWebModule(String contextRoot, String appName, String virtualServers, WebBundleDescriptor wbd, boolean dummy) {
        this.disableWSMonitoring(wbd);
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("WebContainer.unloadWebModule(): contextRoot: " + contextRoot + " appName:" + appName);
        }
        SessionPurgeUtil purgeUtil = new SessionPurgeUtil(this._embedded);
        this.cleanSecurityContext(appName);
        if (this.webModulesManager != null) {
            this.webModulesManager.unregisterDescriptor(appName);
        }
        if (!contextRoot.equals("") && !contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        } else if ("/".equals(contextRoot)) {
            contextRoot = "";
        }
        Engine[] engines = this._embedded.getEngines();
        List hostList = StringUtils.parseStringList(virtualServers, " ,");
        boolean unloadToAll = hostList == null || hostList.size() == 0;
        boolean hasBeenUndeployed = false;
        Container[] hostArray = null;
        VirtualServer host = null;
        WebModule context = null;
        for (int j = 0; j < engines.length; ++j) {
            hostArray = engines[j].findChildren();
            for (int i = 0; i < hostArray.length; ++i) {
                WebModuleConfig wmInfo;
                host = (VirtualServer)hostArray[i];
                if (unloadToAll && host.getName().equalsIgnoreCase(ADMIN_VS) || !unloadToAll && !hostList.contains(host.getName()) && !this.verifyAlias(hostList, host) || (context = (WebModule)host.findChild(contextRoot)) == null) continue;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.finest("about to call SessionPurgeUtil for " + appName + " contextRoot: " + contextRoot);
                }
                purgeUtil.purgeSessionsForContext(context);
                this.disableMonitoring(context, host.getName());
                host.removeChild(context);
                try {
                    context.destroy();
                }
                catch (Exception ex) {
                    _logger.log(Level.WARNING, "[WebContainer] Context " + contextRoot + " threw exception in destroy()", ex);
                }
                Switch sw = Switch.getSwitch();
                sw.removeDescriptorFor(context);
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "[WebContainer] Context " + contextRoot + " undeployed from " + host);
                }
                hasBeenUndeployed = true;
                host.fireContainerEvent("remove", context);
                if (context.hasAdHocPaths() || context.hasAdHocSubtrees()) {
                    WebModule wm = this.createAdHocWebModule(host, contextRoot, context.getJ2EEApplication());
                    wm.addAdHocPaths(context.getAdHocPaths());
                    wm.addAdHocSubtrees(context.getAdHocSubtrees());
                }
                if (dummy || (wmInfo = host.createSystemDefaultWebModuleIfNecessary()) == null) continue;
                this.loadStandaloneWebModule(host, wmInfo);
            }
        }
        if (!hasBeenUndeployed) {
            _logger.log(Level.SEVERE, "[WebContainer] Undeployment failed for context " + contextRoot);
        }
    }

    public void enableWebModule(WebModuleConfig wmInfo, String j2eeApplication) {
        String vsIDs = wmInfo.getVirtualServers();
        List vsList = StringUtils.parseStringList(vsIDs, " ,");
        boolean enabledToAll = vsList == null || vsList.size() == 0;
        Engine[] engines = this._embedded.getEngines();
        for (int j = 0; j < engines.length; ++j) {
            Container[] vsArray = engines[j].findChildren();
            for (int i = 0; i < vsArray.length; ++i) {
                VirtualServer vs;
                if (!(vsArray[i] instanceof VirtualServer) || (vs = (VirtualServer)vsArray[i]).getID().equals(ADMIN_VS) && enabledToAll || !enabledToAll && !vsList.contains(vs.getID()) && !this.verifyAlias(vsList, vs)) continue;
                this.loadWebModule(vs, wmInfo, j2eeApplication);
            }
        }
    }

    public void disableWebModule(String contextRoot, String appName, String virtualServers) {
        if (!contextRoot.equals("") && !contextRoot.startsWith("/")) {
            contextRoot = "/" + contextRoot;
        }
        Engine[] engines = this._embedded.getEngines();
        List hostList = StringUtils.parseStringList(virtualServers, " ,");
        boolean disableToAll = hostList == null || hostList.size() == 0;
        boolean hasBeenDisabled = false;
        Container[] hostArray = null;
        VirtualServer host = null;
        Context context = null;
        for (int j = 0; j < engines.length; ++j) {
            hostArray = engines[j].findChildren();
            for (int i = 0; i < hostArray.length; ++i) {
                host = (VirtualServer)hostArray[i];
                if (disableToAll && host.getName().equalsIgnoreCase(ADMIN_VS) || !disableToAll && !hostList.contains(host.getName()) && !this.verifyAlias(hostList, host) || (context = (Context)host.findChild(contextRoot)) == null) continue;
                context.setAvailable(false);
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "[WebContainer] Context " + contextRoot + " disabled from " + host);
                }
                hasBeenDisabled = true;
            }
        }
        if (!hasBeenDisabled) {
            _logger.log(Level.WARNING, "[WebContainer] moduleDisabled fail for context " + contextRoot);
        }
    }

    private void getDynamicReloadingSettings(DasConfig appsBean) {
        if (appsBean != null) {
            this._reloadingEnabled = appsBean.isDynamicReloadEnabled();
            String seconds = appsBean.getDynamicReloadPollIntervalInSeconds();
            if (seconds != null) {
                try {
                    this._pollInterval = Integer.parseInt(seconds);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private void setLogLevel(Level level) {
        this._logLevel = level;
        _logger.setLevel(this._logLevel);
        this._debug = level.equals(Level.FINE) ? 1 : (level.equals(Level.FINER) ? 2 : (level.equals(Level.FINEST) ? 5 : 0));
    }

    private void initLogLevel(LogService logserviceBean) throws ConfigException {
        Level level = Level.SEVERE;
        this.setLogLevel(level);
        if (logserviceBean != null) {
            try {
                level = Level.parse(logserviceBean.getModuleLogLevels().getRoot());
                this.setLogLevel(level);
            }
            catch (NullPointerException e) {
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        try {
            level = Level.parse(ServerBeansFactory.getWebContainerLogLevel(this._configContext));
            this.setLogLevel(level);
        }
        catch (NullPointerException e) {
            if (this._debug > 0) {
                _logger.finest("Defaulting <web-container> log-level");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this._debug > 0) {
            _logger.fine("Web container log level: " + this._logLevel);
        }
    }

    private void initMonitoringLevel(MonitoringService monitoringBean) {
        ModuleMonitoringLevels levels;
        monitoringLevel = MonitoringLevel.OFF;
        if (monitoringBean != null && (levels = monitoringBean.getModuleMonitoringLevels()) != null) {
            monitoringLevel = MonitoringLevel.instance((String)levels.getWebContainer());
        }
    }

    private boolean isSSOEnabled(com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        ElementProperty ssoProperty = vsBean.getElementPropertyByName(SSO_ENABLED);
        return ssoProperty == null || ssoProperty.getValue() == null || ConfigBean.toBoolean(ssoProperty.getValue());
    }

    private com.sun.enterprise.config.serverbeans.VirtualServer findVirtualServerBean(String vsID) {
        HttpService httpService = null;
        try {
            httpService = ServerBeansFactory.getHttpServiceBean(this._configContext);
        }
        catch (ConfigException e) {
            String msg = _rb.getString("webcontainer.httpConfigError");
            _logger.log(Level.SEVERE, msg, e);
        }
        com.sun.enterprise.config.serverbeans.VirtualServer[] vses = httpService.getVirtualServer();
        for (int i = 0; vses != null && i < vses.length; ++i) {
            if (!vsID.equals(vses[i].getId())) continue;
            return vses[i];
        }
        return null;
    }

    @Override
    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    private void cleanSecurityContext(String appName) {
        String[] cIDs = this.webSecurityManagerFactory.getContextIdsOfApp(appName);
        for (int i = 0; cIDs != null && i < cIDs.length; ++i) {
            WebSecurityManager wsm = this.webSecurityManagerFactory.getWebSecurityManager(cIDs[i]);
            _logger.log(Level.FINE, "[JACC]: Removing WebSecurityManager: " + cIDs[i]);
            if (wsm == null) continue;
            try {
                wsm.destroy();
            }
            catch (PolicyContextException pce) {
                _logger.log(Level.WARNING, "Unable to destroy WebSecurityManager", pce);
            }
            this.webSecurityManagerFactory.removeWebSecurityManager(cIDs[i]);
        }
    }

    private String getVirtualServers(String appName, ConfigContext configCtx) {
        if (configCtx == null) {
            configCtx = this._configContext;
        }
        String ret = null;
        try {
            ret = ServerBeansFactory.getVirtualServersByAppName(configCtx, appName);
        }
        catch (ConfigException ce) {
            _logger.log(Level.WARNING, "No virtual servers defined for " + appName, ce);
        }
        return ret;
    }

    private void addMimeMappings(StandardContext ctx, MimeMap mimeMap) {
        if (mimeMap == null) {
            return;
        }
        Iterator itr = mimeMap.getExtensions();
        while (itr.hasNext()) {
            String extension = (String)itr.next();
            if (ctx.findMimeMapping(extension) != null) continue;
            ctx.addMimeMapping(extension, mimeMap.getType(extension));
        }
    }

    private void enableAllWSEndpoints() {
        J2eeApplication[] j2eeAppBeans;
        Applications appsBean = null;
        try {
            appsBean = ServerBeansFactory.getApplicationsBean(this._configContext);
        }
        catch (ConfigException e) {
            String msg = _rb.getString("webcontainer.appsConfigError");
            _logger.log(Level.SEVERE, msg, e);
        }
        if (appsBean != null && (j2eeAppBeans = appsBean.getJ2eeApplication()) != null) {
            for (int i = 0; i < j2eeAppBeans.length; ++i) {
                if (!this.isReferenced(j2eeAppBeans[i].getName())) continue;
                this.enableWSMonitoring(j2eeAppBeans[i].getName());
            }
        }
    }

    private boolean disableWSMonitoring(WebBundleDescriptor wbd) {
        boolean result = true;
        try {
            Switch.getSwitch().getManagementObjectManager().deleteWSEndpointMBeans(wbd, this.instance.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean enableWSMonitoring(String id) {
        boolean result = true;
        ApplicationRegistry registry = ApplicationRegistry.getInstance();
        ClassLoader appLoader = registry.getClassLoaderForApplication(id);
        if (appLoader != null) {
            Application appDesc = registry.getApplication(appLoader);
            if (appDesc == null) {
                Object[] params = new Object[]{id};
                _logger.log(Level.SEVERE, "webcontainer.notLoaded", params);
            } else {
                String j2eeApplication = appDesc.getRegistrationName();
                Set wbds = appDesc.getWebBundleDescriptors();
                WebBundleDescriptor wbd2 = null;
                for (WebBundleDescriptor wbd2 : wbds) {
                    try {
                        Switch.getSwitch().getManagementObjectManager().createWSEndpointMBeans(wbd2, this.instance.getName());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return false;
                    }
                }
            }
        }
        return true;
    }

    void enableWSMonitoring(WebBundleDescriptor wbd, String serverName) {
        try {
            Switch.getSwitch().getManagementObjectManager().createWSEndpointMBeans(wbd, serverName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void enableMonitoring(WebModule ctx, String vsId) {
        if (!ctx.hasWebXml()) {
            return;
        }
        String j2eeServer = this._serverContext.getInstanceName();
        this.registerWebModuleStats(ctx.getJ2EEApplication(), j2eeServer, vsId, ctx, null);
        Container[] children = ctx.findChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                this.registerServletStats(ctx.getJ2EEApplication(), j2eeServer, ctx.getModuleName(), vsId, ctx.getPath(), children[i].getName(), null);
            }
        }
    }

    protected void disableMonitoring(WebModule ctx, String vsId) {
        Container[] children;
        if (!ctx.hasWebXml()) {
            return;
        }
        String appName = ctx.getJ2EEApplication();
        if ("null".equalsIgnoreCase(appName)) {
            appName = null;
        }
        if ((children = ctx.findChildren()) != null) {
            for (int k = 0; k < children.length; ++k) {
                this.unregisterServletStats(appName, ctx.getModuleName(), ctx.getPath(), vsId, children[k].getName());
            }
        }
        this.unregisterWebModuleStats(appName, ctx.getModuleName(), ctx.getPath(), vsId);
    }

    private void setNoTldScan() {
        int size;
        boolean first = true;
        StringBuffer sb = new StringBuffer();
        StringBuffer sbListener = new StringBuffer();
        List tldJars = null;
        List tldListeners = null;
        String prop = System.getProperty("com.sun.enterprise.taglibs");
        if (prop != null) {
            tldJars = StringUtils.parseStringList(prop, ",");
        }
        if ((prop = System.getProperty("com.sun.enterprise.taglisteners")) != null) {
            tldListeners = StringUtils.parseStringList(prop, ",");
        }
        if (!(tldListeners == null || (size = tldListeners.size()) <= 0 || tldListeners.contains("jsf-impl.jar") && size <= 1)) {
            TldConfig.setScanParentTldListener(true);
        }
        for (ClassLoader loader = this.getClass().getClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            URL[] urls = ((URLClassLoader)loader).getURLs();
            for (int i = 0; i < urls.length; ++i) {
                String url = urls[i].toString();
                int index = url.lastIndexOf(47);
                if (index != -1) {
                    url = url.substring(index + 1);
                }
                if (url != null && url.endsWith(".jar") && (tldJars == null || !tldJars.contains(url))) {
                    if (first) {
                        sb.append(url);
                        first = false;
                    } else {
                        sb.append(',');
                        sb.append(url);
                    }
                }
                if (url == null || !url.endsWith(".jar") || tldListeners != null && tldListeners.contains(url)) continue;
                if (first) {
                    sbListener.append(url);
                    first = false;
                    continue;
                }
                sbListener.append(',');
                sbListener.append(url);
            }
        }
        if (sbListener.length() > 0) {
            TldConfig.setNoTldListeners(sbListener.toString());
        }
        if (sb.length() > 0) {
            TldLocationsCache.setNoTldJars(sb.toString());
        }
    }

    private boolean isReferenced(String appName) {
        Servers servers = this.domain.getServers();
        Server server = servers.getServerByName(this._serverContext.getInstanceName());
        ApplicationRef ref = server.getApplicationRefByRef(appName);
        return ref != null;
    }

    private void registerServletStats(String j2eeApplication, String j2eeServer, String webModuleName, String vsId, String contextRoot, String servletName, MonitoringLevelListener listener) {
        PwcServletStatsImpl pwcServletStats = new PwcServletStatsImpl(this._serverContext.getDefaultDomainName(), vsId, contextRoot, servletName, j2eeApplication, j2eeServer);
        ServletStatsImpl servletStats = new ServletStatsImpl(pwcServletStats);
        MonitoringRegistry monitoringRegistry = this._serverContext.getMonitoringRegistry();
        String app = "null".equalsIgnoreCase(j2eeApplication) ? null : j2eeApplication;
        try {
            monitoringRegistry.registerServletStats((ServletStats)servletStats, app, webModuleName, contextRoot, vsId, servletName, listener);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Exception during registration of servletstats", e);
        }
    }

    private void unregisterServletStats(String j2eeApplication, String webModuleName, String contextRoot, String vsId, String servletName) {
        MonitoringRegistry monitoringRegistry = this._serverContext.getMonitoringRegistry();
        try {
            monitoringRegistry.unregisterServletStats(j2eeApplication, webModuleName, contextRoot, vsId, servletName);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Exception during unregistration of servletstats", e);
        }
    }

    private WebModuleStats registerWebModuleStats(String j2eeApplication, String j2eeServer, String vsId, WebModule ctx, MonitoringLevelListener listener) {
        WebContainerFeatureFactory webFeatureFac = this._serverContext.getPluggableFeatureFactory().getWebContainerFeatureFactory();
        WebModuleStatsImpl webStats = (WebModuleStatsImpl)webFeatureFac.getWebModuleStats();
        PwcWebModuleStatsImpl pwcWebStats = new PwcWebModuleStatsImpl(ctx.getObjectName(), ctx.getPath(), this._serverContext.getDefaultDomainName(), vsId, j2eeApplication, j2eeServer);
        webStats.setPwcWebModuleStats(pwcWebStats);
        webStats.setSessionManager(ctx.getManager());
        MonitoringRegistry monitoringRegistry = this._serverContext.getMonitoringRegistry();
        String app = "null".equalsIgnoreCase(j2eeApplication) ? null : j2eeApplication;
        try {
            monitoringRegistry.registerWebModuleStats((WebModuleStats)webStats, app, ctx.getModuleName(), ctx.getPath(), vsId, listener);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Fail to register WebModuleStats for " + ctx.getModuleName() + " deployed on " + vsId, e);
        }
        return webStats;
    }

    private void unregisterWebModuleStats(String j2eeApplication, String webModuleName, String contextRoot, String vsId) {
        MonitoringRegistry monitoringRegistry = this._serverContext.getMonitoringRegistry();
        try {
            monitoringRegistry.unregisterWebModuleStats(j2eeApplication, webModuleName, contextRoot, vsId);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Fail to unregister WebModuleStats for " + webModuleName + " deployed on " + vsId, e);
        }
    }

    @Override
    public void moduleReferenceAdded(ModuleDeployEvent event) {
    }

    @Override
    public void moduleReferenceRemoved(ModuleDeployEvent event) {
    }

    @Override
    public void applicationReferenceAdded(ApplicationDeployEvent event) {
    }

    @Override
    public void applicationReferenceRemoved(ApplicationDeployEvent event) {
    }

    public static WebContainer getInstance() {
        return webContainer;
    }

    public Engine[] getEngines() {
        return this._embedded.getEngines();
    }

    public void registerAdHocPath(String path, String ctxtRoot, String appName, AdHocServletInfo servletInfo) {
        this.registerAdHocPathAndSubtree(path, null, ctxtRoot, appName, servletInfo);
    }

    public void registerAdHocPathAndSubtree(String path, String subtree, String ctxtRoot, String appName, AdHocServletInfo servletInfo) {
        WebModule wm = null;
        Engine[] engines = this._embedded.getEngines();
        for (int j = 0; j < engines.length; ++j) {
            Container[] vsList = engines[j].findChildren();
            for (int i = 0; i < vsList.length; ++i) {
                VirtualServer vs = (VirtualServer)vsList[i];
                if (vs.getName().equalsIgnoreCase(ADMIN_VS)) continue;
                wm = (WebModule)vs.findChild(ctxtRoot);
                if (wm == null) {
                    wm = this.createAdHocWebModule(vs, ctxtRoot, appName);
                }
                wm.addAdHocPathAndSubtree(path, subtree, servletInfo);
            }
        }
    }

    public void unregisterAdHocPath(String path, String ctxtRoot) {
        this.unregisterAdHocPathAndSubtree(path, null, ctxtRoot);
    }

    public void unregisterAdHocPathAndSubtree(String path, String subtree, String ctxtRoot) {
        WebModule wm = null;
        Engine[] engines = this._embedded.getEngines();
        for (int j = 0; j < engines.length; ++j) {
            Container[] vsList = engines[j].findChildren();
            for (int i = 0; i < vsList.length; ++i) {
                VirtualServer vs = (VirtualServer)vsList[i];
                if (vs.getName().equalsIgnoreCase(ADMIN_VS) || (wm = (WebModule)vs.findChild(ctxtRoot)) == null) continue;
                wm.removeAdHocPath(path);
                wm.removeAdHocSubtree(subtree);
                if (!(wm instanceof AdHocWebModule) || wm.hasAdHocPaths() || wm.hasAdHocSubtrees()) continue;
                vs.removeChild(wm);
                try {
                    wm.destroy();
                    continue;
                }
                catch (Exception ex) {
                    _logger.log(Level.WARNING, "[WebContainer] Context " + wm.getPath() + " threw exception in destroy()", ex);
                }
            }
        }
    }

    private WebModule createAdHocWebModule(VirtualServer vs, String ctxtRoot, String appName) {
        AdHocWebModule wm = new AdHocWebModule(this);
        wm.restrictedSetPipeline(new WebPipeline(wm));
        if (Boolean.getBoolean("com.sun.aas.useNewClassLoader")) {
            wm.setParentClassLoader(Thread.currentThread().getContextClassLoader());
        }
        wm.setContextRoot(ctxtRoot);
        wm.setJ2EEApplication(appName);
        wm.setName(ctxtRoot);
        wm.setDocBase(vs.getAppBase());
        wm.setEngineName(vs.getParent().getName());
        String domain = this._serverContext.getDefaultDomainName();
        wm.setDomain(domain);
        String j2eeServer = this._serverContext.getInstanceName();
        wm.setJ2EEServer(j2eeServer);
        String server = domain + ":j2eeType=J2EEServer,name=" + j2eeServer;
        wm.setServer(server);
        wm.setCrossContext(true);
        wm.setJavaVMs(J2EEModuleUtil.getjavaVMs());
        vs.addChild(wm);
        return wm;
    }

    private void addLibs(Loader loader, WebModule ctx) {
        String list = ASClassLoaderUtil.getLibrariesForWebModule(ctx.getID());
        if (list == null) {
            return;
        }
        String[] libs = list.split(",");
        if (libs == null) {
            return;
        }
        File libDir = new File(this.instance.getLibPath());
        String libDirPath = libDir.getAbsolutePath();
        String appLibsPrefix = libDirPath + File.separator + "applibs" + File.separator;
        for (int i = 0; i < libs.length; ++i) {
            File file = new File(libs[i]);
            if (file.isAbsolute()) {
                loader.addRepository("file:" + file.getAbsolutePath());
                continue;
            }
            loader.addRepository("file:" + appLibsPrefix + libs[i]);
        }
    }

    private void configureLoaderAttributes(Loader loader, com.sun.enterprise.deployment.runtime.web.ClassLoader clBean, WebModule ctx) {
        String value = null;
        value = clBean.getAttributeValue("Delegate");
        boolean delegate = ConfigBean.toBoolean(value);
        loader.setDelegate(delegate);
        List pathElements = null;
        value = clBean.getAttributeValue("ExtraClassPath");
        if (value != null && (pathElements = StringUtils.parseStringList(value, ";:")) != null) {
            ListIterator iter = pathElements.listIterator();
            while (iter.hasNext()) {
                String path = (String)iter.next();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("WebModule[" + ctx.getPath() + "]: Adding " + path + " to the classpath");
                }
                try {
                    URL url = new File(path).toURI().toURL();
                    loader.addRepository(url.toString());
                }
                catch (MalformedURLException e) {
                    String msg = _rb.getString("webcontainer.classpathError");
                    Object[] params = new Object[]{path};
                    msg = MessageFormat.format(msg, params);
                    _logger.log(Level.SEVERE, msg, e);
                }
            }
        }
        if ((value = clBean.getAttributeValue("DynamicReloadInterval")) != null) {
            _logger.log(Level.WARNING, "webcontainer.dynamicReloadInterval");
        }
        _logger.fine("WebModule[" + ctx.getPath() + "]: Setting delegate to " + delegate + ", extra-class-path to " + pathElements);
    }

    private void configureLoaderProperties(Loader loader, com.sun.enterprise.deployment.runtime.web.ClassLoader clBean) {
        String name = null;
        String value = null;
        WebProperty[] props = clBean.getWebProperty();
        if (props == null || props.length == 0) {
            return;
        }
        for (int i = 0; i < props.length; ++i) {
            name = props[i].getAttributeValue("name");
            value = props[i].getAttributeValue("value");
            if (name == null || value == null) {
                throw new IllegalArgumentException(_rb.getString("webcontainer.nullWebProperty"));
            }
            if (name.equalsIgnoreCase("ignoreHiddenJarFiles")) {
                loader.setIgnoreHiddenJarFiles(ConfigBean.toBoolean(value));
                continue;
            }
            Object[] params = new Object[]{name, value};
            _logger.log(Level.WARNING, "webcontainer.invalidProperty", params);
        }
    }

    private void configureRedirect(VirtualServer vs, com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        if (vsBean == null) {
            return;
        }
        ElementProperty[] props = vsBean.getElementProperty();
        if (props == null) {
            return;
        }
        for (int i = 0; i < props.length; ++i) {
            String propName = props[i].getName();
            String propValue = props[i].getValue();
            if (propName == null || propValue == null) {
                _logger.log(Level.WARNING, "webcontainer.nullVirtualServerProperty", vs.getID());
            }
            if (!propName.startsWith("redirect_")) continue;
            String from = null;
            String url = null;
            String urlPrefix = null;
            String escape = null;
            String[] redirectParams = propValue.split(" ");
            for (int j = 0; j < redirectParams.length; ++j) {
                if (redirectParams[j].startsWith("from=")) {
                    if (from != null) {
                        _logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, "from"});
                    }
                    from = redirectParams[j].substring("from=".length());
                }
                if (redirectParams[j].startsWith("url=")) {
                    if (url != null) {
                        _logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, "url"});
                    }
                    url = redirectParams[j].substring("url=".length());
                }
                if (redirectParams[j].startsWith("url-prefix=")) {
                    if (urlPrefix != null) {
                        _logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, "url-prefix"});
                    }
                    urlPrefix = redirectParams[j].substring("url-prefix=".length());
                }
                if (!redirectParams[j].startsWith("escape=")) continue;
                if (escape != null) {
                    _logger.log(Level.WARNING, "webcontainer.redirectMultipleElement", new Object[]{propValue, "escape"});
                }
                escape = redirectParams[j].substring("escape=".length());
            }
            if (from == null || from.length() == 0) {
                _logger.log(Level.WARNING, "webcontainer.redirectMissingFrom", propValue);
            }
            if (!(url != null && url.length() != 0 || urlPrefix != null && urlPrefix.length() != 0)) {
                _logger.log(Level.WARNING, "webcontainer.redirectMissingUrlOrUrlPrefix", propValue);
            }
            if (url != null && url.length() > 0 && urlPrefix != null && urlPrefix.length() > 0) {
                _logger.log(Level.WARNING, "webcontainer.redirectBothUrlAndUrlPrefix", propValue);
            }
            boolean escapeURI = true;
            if (escape != null) {
                if ("yes".equalsIgnoreCase(escape)) {
                    escapeURI = true;
                } else if ("no".equalsIgnoreCase(escape)) {
                    escapeURI = false;
                } else {
                    _logger.log(Level.WARNING, "webcontainer.redirectInvalidEscape", propValue);
                }
            }
            vs.addRedirect(from, url, urlPrefix, escapeURI);
        }
    }

    private void configureErrorPage(VirtualServer vs, com.sun.enterprise.config.serverbeans.VirtualServer vsBean) {
        ErrorPage errorPage = null;
        if (vsBean == null) {
            return;
        }
        ElementProperty[] props = vsBean.getElementProperty();
        if (props == null) {
            return;
        }
        for (int i = 0; i < props.length; ++i) {
            String propName = props[i].getName();
            String propValue = props[i].getValue();
            if (propName == null || propValue == null) {
                _logger.log(Level.WARNING, "webcontainer.nullVirtualServerProperty", vs.getID());
            }
            if (!propName.startsWith("send-error_")) continue;
            String path = null;
            String reason = null;
            String status = null;
            String[] errorParams = propValue.split(" ");
            for (int j = 0; j < errorParams.length; ++j) {
                if (errorParams[j].startsWith("path=")) {
                    if (path != null) {
                        _logger.log(Level.WARNING, "webcontainer.sendErrorMultipleElement", new Object[]{propValue, "path"});
                    }
                    path = errorParams[j].substring("path=".length());
                }
                if (errorParams[j].startsWith("reason=")) {
                    if (reason != null) {
                        _logger.log(Level.WARNING, "webcontainer.sendErrorMultipleElement", new Object[]{propValue, "reason"});
                    }
                    reason = errorParams[j].substring("reason=".length());
                }
                if (!errorParams[j].startsWith("code=")) continue;
                if (status != null) {
                    _logger.log(Level.WARNING, "webcontainer.sendErrorMultipleElement", new Object[]{propValue, "code"});
                }
                status = errorParams[j].substring("code=".length());
            }
            if (path == null || path.length() == 0) {
                _logger.log(Level.WARNING, "webcontainer.sendErrorMissingPath", propValue);
            }
            errorPage = new ErrorPage();
            errorPage.setLocation(path);
            errorPage.setErrorCode(status);
            errorPage.setReason(reason);
            vs.addErrorPage(errorPage);
        }
    }

    private String getInstanceClassPath(InstanceEnvironment instanceEnv) {
        if (instanceEnv == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        File libDir = new File(instanceEnv.getLibPath());
        String libDirPath = libDir.getAbsolutePath();
        sb.append(libDirPath + File.separator + "classes");
        sb.append(File.pathSeparator);
        String[] files = libDir.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].endsWith(".jar") && !files[i].endsWith(".zip")) continue;
                sb.append(libDirPath + File.separator + files[i]);
                sb.append(File.pathSeparator);
            }
        }
        return sb.toString();
    }

    String getInstanceClassPath() {
        return this.instanceClassPath;
    }

    static {
        useDOLforDeployment = true;
        if (System.getProperty(DOL_DEPLOYMENT) != null) {
            useDOLforDeployment = Boolean.valueOf(System.getProperty(DOL_DEPLOYMENT));
        }
        debugMonitoring = false;
        debugMonitoringPeriodMS = 30000L;
        _timer = new WebContainerTimer();
    }
}

