/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.SelectorFactory;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public final class OutputWriter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushChannel(SocketChannel socketChannel, ByteBuffer bb) throws IOException {
        SelectionKey key = null;
        Selector writeSelector = null;
        int attempts = 0;
        try {
            while (bb.hasRemaining()) {
                int len = socketChannel.write(bb);
                ++attempts;
                if (len < 0) {
                    throw new EOFException();
                }
                if (len == 0) {
                    if (writeSelector == null && (writeSelector = SelectorFactory.getSelector()) == null) continue;
                    key = socketChannel.register(writeSelector, 4);
                    if (writeSelector.select(30000L) == 0) {
                        if (attempts <= 2) continue;
                        throw new IOException("Client disconnected");
                    }
                    --attempts;
                    continue;
                }
                attempts = 0;
            }
        }
        finally {
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector != null) {
                writeSelector.selectNow();
                SelectorFactory.returnSelector(writeSelector);
            }
        }
    }
}

