/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.ByteBufferInputStream;
import com.sun.enterprise.web.connector.grizzly.ProcessorTask;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.StreamAlgorithm;
import com.sun.enterprise.web.connector.grizzly.TaskBase;
import com.sun.enterprise.web.connector.grizzly.TaskContext;
import com.sun.enterprise.web.connector.grizzly.TaskEvent;
import com.sun.enterprise.web.connector.grizzly.TaskListener;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class ReadTask
extends TaskBase {
    protected TaskContext taskContext;
    protected TaskEvent taskEvent;
    protected ByteBuffer byteBuffer;
    protected ProcessorTask processorTask;
    protected int maxPostSize = 0x1900000;
    protected ByteBufferInputStream inputStream;
    protected StreamAlgorithm algorithm;
    protected boolean bytesAvailable = false;
    protected volatile boolean isReturned = false;

    public ReadTask() {
    }

    public ReadTask(StreamAlgorithm algorithm, boolean useDirectByteBuffer, boolean useByteBufferView) {
        this.type = 1;
        this.algorithm = algorithm;
        this.byteBuffer = algorithm.allocate(useDirectByteBuffer, useByteBufferView);
        this.inputStream = new ByteBufferInputStream();
    }

    public void attachProcessor(ProcessorTask processorTask) {
        this.processorTask = processorTask;
        this.configureProcessorTask();
    }

    public void configureProcessorTask() {
        this.processorTask.useAlternateKeepAlive(true);
        this.processorTask.setSelectionKey(this.key);
        this.processorTask.setSocket(((SocketChannel)this.key.channel()).socket());
        this.processorTask.setHandler(this.algorithm.getHandler());
    }

    public void detachProcessor() {
        if (this.processorTask != null) {
            this.processorTask.recycle();
        }
        if (this.listeners != null) {
            for (int i = this.listeners.size() - 1; i > -1; --i) {
                if (this.taskEvent == null) {
                    this.taskEvent = new TaskEvent();
                }
                this.taskEvent.attach(this);
                this.taskEvent.setStatus(2);
                ((TaskListener)this.listeners.get(i)).taskEvent(this.taskEvent);
            }
            this.clearTaskListeners();
        }
        if (this.recycle && this.processorTask != null) {
            this.selectorThread.returnTask(this.processorTask);
            this.processorTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTask() throws IOException {
        int count = 0;
        Socket socket = null;
        SocketChannel socketChannel = null;
        boolean keepAlive = false;
        Exception exception = null;
        this.isReturned = false;
        try {
            socketChannel = (SocketChannel)this.key.channel();
            socket = socketChannel.socket();
            this.algorithm.setSocketChannel(socketChannel);
            int loop = 0;
            boolean bufferSize = false;
            while (socketChannel.isOpen() && (this.bytesAvailable || (count = socketChannel.read(this.byteBuffer)) > -1)) {
                if (count == 0 && !this.bytesAvailable) {
                    if (++loop <= 2) continue;
                    break;
                }
                this.bytesAvailable = false;
                this.byteBuffer = this.algorithm.preParse(this.byteBuffer);
                this.inputStream.setByteBuffer(this.byteBuffer);
                this.inputStream.setSelectionKey(this.key);
                if (this.algorithm.parse(this.byteBuffer)) {
                    keepAlive = this.executeProcessorTask();
                    if (keepAlive) continue;
                    break;
                }
                keepAlive = true;
            }
        }
        catch (IOException ex) {
            exception = ex;
        }
        catch (RuntimeException ex) {
            exception = ex;
        }
        finally {
            this.manageKeepAlive(keepAlive, count, exception);
        }
    }

    protected void manageKeepAlive(boolean keepAlive, int count, Exception exception) {
        if (count == -1 || !this.key.isValid() || exception != null) {
            keepAlive = false;
            if (exception != null) {
                this.detachProcessor();
                SelectorThread.logger().log(Level.FINEST, "SocketChannel Read Exception: ", exception);
            }
        }
        if (keepAlive) {
            this.registerKey();
        }
        this.terminate(keepAlive);
    }

    public boolean executeProcessorTask() throws IOException {
        boolean registerKey = false;
        if (SelectorThread.logger().isLoggable(Level.FINEST)) {
            SelectorThread.logger().log(Level.FINEST, "executeProcessorTask");
        }
        if (this.algorithm.getHandler().handle(null, 2) == 1) {
            return true;
        }
        if (this.processorTask == null) {
            this.attachProcessor(this.selectorThread.getProcessorTask());
        }
        try {
            registerKey = this.processorTask.process(this.inputStream, null);
        }
        catch (Exception e) {
            SelectorThread.logger().log(Level.SEVERE, "readTask.processException", e);
        }
        this.detachProcessor();
        return registerKey;
    }

    protected void returnTask() {
        if (this.recycle && !this.isReturned) {
            this.isReturned = true;
            this.selectorThread.returnTask(this);
        }
    }

    public void taskEvent(TaskEvent event) {
        if (event.getStatus() == 2) {
            this.terminate(false);
        }
    }

    public void terminate(boolean keepAlive) {
        if (this.isReturned) {
            return;
        }
        if (!keepAlive) {
            this.finishConnection();
        }
        this.recycle();
        this.returnTask();
    }

    public void recycle() {
        this.byteBuffer = this.algorithm.postParse(this.byteBuffer);
        this.byteBuffer.clear();
        this.inputStream.recycle();
        this.algorithm.recycle();
        this.key = null;
        this.inputStream.setSelectionKey(null);
    }

    protected void finishConnection() {
        if (SelectorThread.logger().isLoggable(Level.FINEST)) {
            SelectorThread.logger().log(Level.FINEST, "finishConnection");
        }
        try {
            if (this.taskContext != null) {
                this.taskContext.recycle();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.selectorThread.cancelKey(this.key);
    }

    protected void registerKey() {
        if (this.key.isValid()) {
            if (SelectorThread.logger().isLoggable(Level.FINEST)) {
                SelectorThread.logger().log(Level.FINEST, "registerKey");
            }
            this.selectorThread.registerKey(this.key);
        } else {
            this.terminate(false);
        }
    }

    public ProcessorTask getProcessorTask() {
        return this.processorTask;
    }

    public void setStreamAlgorithm(StreamAlgorithm algorithm) {
        this.algorithm = algorithm;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public void setBytesAvailable(boolean bytesAvailable) {
        this.bytesAvailable = bytesAvailable;
    }
}

