/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.Constants;
import com.sun.enterprise.web.connector.grizzly.OutputWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.apache.coyote.Response;
import org.apache.coyote.http11.InternalOutputBuffer;

public class SocketChannelOutputBuffer
extends InternalOutputBuffer {
    protected SocketChannel socketChannel;

    public SocketChannelOutputBuffer(Response response, int headerBufferSize) {
        super(response, headerBufferSize);
        this.socketBuffer.allocate(headerBufferSize, headerBufferSize);
        this.useSocketBuffer = true;
    }

    public void setChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    public SocketChannel getChannel() {
        return this.socketChannel;
    }

    public void sendAck() throws IOException {
        if (!this.committed) {
            this.flushChannel(ByteBuffer.wrap(Constants.ACK_BYTES));
        }
    }

    public void realWriteBytes(byte[] cbuf, int off, int len) throws IOException {
        if (len > 0) {
            this.flushChannel(ByteBuffer.wrap(cbuf, off, len));
        }
    }

    public void flushChannel(ByteBuffer bb) throws IOException {
        OutputWriter.flushChannel(this.socketChannel, bb);
    }
}

