/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.HtmlHelper;
import com.sun.enterprise.web.connector.grizzly.KeepAliveStats;
import com.sun.enterprise.web.connector.grizzly.Pipeline;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.Task;
import com.sun.enterprise.web.connector.grizzly.TaskEvent;
import com.sun.enterprise.web.connector.grizzly.TaskListener;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.logging.Level;
import org.apache.coyote.RequestGroupInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TaskBase
implements Task,
TaskListener {
    protected int type;
    protected ArrayList<TaskListener> listeners;
    protected Pipeline pipeline;
    protected SelectionKey key;
    protected boolean recycle = true;
    protected SelectorThread selectorThread;

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setSelectorThread(SelectorThread selectorThread) {
        this.selectorThread = selectorThread;
    }

    @Override
    public SelectorThread getSelectorThread() {
        return this.selectorThread;
    }

    public void setPipeline(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    @Override
    public void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    @Override
    public SelectionKey getSelectionKey() {
        return this.key;
    }

    @Override
    public RequestGroupInfo getRequestGroupInfo() {
        return this.selectorThread != null ? this.selectorThread.getRequestGroupInfo() : null;
    }

    @Override
    public boolean isMonitoringEnabled() {
        return this.selectorThread != null ? this.selectorThread.isMonitoringEnabled() : false;
    }

    @Override
    public KeepAliveStats getKeepAliveStats() {
        return this.selectorThread != null ? this.selectorThread.getKeepAliveStats() : null;
    }

    @Override
    public void execute() {
        if (this.pipeline != null) {
            this.pipeline.addTask(this);
        } else {
            this.run();
        }
    }

    private void initListener() {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
    }

    @Override
    public void addTaskListener(TaskListener task) {
        this.initListener();
        this.listeners.add(task);
    }

    @Override
    public void removeTaskListener(TaskListener task) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(task);
    }

    @Override
    public void clearTaskListeners() {
        if (this.listeners == null) {
            return;
        }
        this.listeners.clear();
    }

    protected void fireTaskEvent(TaskEvent<?> event) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).taskEvent(event);
        }
    }

    @Override
    public void recycle() {
    }

    @Override
    public ArrayList getTaskListeners() {
        this.initListener();
        return this.listeners;
    }

    @Override
    public void run() {
        try {
            this.doTask();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void setRecycle(boolean recycle) {
        this.recycle = recycle;
    }

    @Override
    public boolean getRecycle() {
        return this.recycle;
    }

    protected Socket getSocket() {
        return null;
    }

    private SocketChannel getChannel() {
        if (this.key == null) {
            return this.getSocket().getChannel();
        }
        return (SocketChannel)this.key.channel();
    }

    @Override
    public void cancelTask(String message, String code) {
        SocketChannel channel = this.getChannel();
        if (code != null) {
            SelectorThread.logger().log(Level.WARNING, message);
            try {
                ByteBuffer byteBuffer = HtmlHelper.getErrorPage(message, code);
                while (byteBuffer.hasRemaining()) {
                    channel.write(byteBuffer);
                }
            }
            catch (IOException ex) {
                SelectorThread.logger().log(Level.FINE, "CancelTask failed", ex);
            }
        }
        try {
            channel.socket().shutdownInput();
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            channel.socket().shutdownOutput();
            channel.socket().close();
            channel.close();
            this.key.cancel();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public Object call() throws Exception {
        return null;
    }
}

