/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.algorithms;

import com.sun.enterprise.web.connector.grizzly.ByteBufferFactory;
import com.sun.enterprise.web.connector.grizzly.Constants;
import com.sun.enterprise.web.connector.grizzly.Handler;
import com.sun.enterprise.web.connector.grizzly.StreamAlgorithm;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public abstract class StreamAlgorithmBase
implements StreamAlgorithm {
    private int port = 8080;
    protected int contentLength = -1;
    protected int curLimit = -1;
    protected int curPosition = -1;
    protected int headerLength = -1;
    protected int lastStatePosition = -1;
    protected int state = 0;
    protected ByteBuffer primaryByteBuffer = null;
    protected boolean useByteBufferView = false;
    protected boolean useDirectByteBuffer;
    protected SocketChannel socketChannel;
    protected Handler handler;

    public abstract boolean parse(ByteBuffer var1);

    public int contentLength() {
        return this.contentLength;
    }

    public int headerLength() {
        return this.headerLength;
    }

    public ByteBuffer allocate(boolean useDirect, boolean useView) {
        this.useByteBufferView = useView;
        this.useDirectByteBuffer = useDirect;
        return this.allocateByteBuffer(useDirect, useView);
    }

    public ByteBuffer preParse(ByteBuffer byteBuffer) {
        if (byteBuffer.position() == byteBuffer.capacity()) {
            int bufferSize = this.contentLength > 0 ? this.contentLength + this.headerLength + 5 : byteBuffer.capacity() * 2;
            byteBuffer = this.swapBuffer(byteBuffer, bufferSize);
        }
        return byteBuffer;
    }

    public ByteBuffer postParse(ByteBuffer byteBuffer) {
        if (this.primaryByteBuffer != null) {
            this.primaryByteBuffer.clear();
            byteBuffer = this.primaryByteBuffer;
            this.primaryByteBuffer = null;
        }
        return byteBuffer;
    }

    public void recycle() {
        this.contentLength = -1;
        this.lastStatePosition = -1;
        this.headerLength = -1;
        this.curLimit = -1;
        this.curPosition = -1;
        this.state = 0;
    }

    protected ByteBuffer allocateByteBuffer(boolean useDirectByteBuffer, boolean useByteBufferView) {
        return this.allocateByteBuffer(useDirectByteBuffer, useByteBufferView, Constants.CHANNEL_BYTE_SIZE);
    }

    protected ByteBuffer allocateByteBuffer(boolean useDirectByteBuffer, boolean useByteBufferView, int size) {
        ByteBuffer byteBuffer = useByteBufferView ? ByteBufferFactory.allocateView(size, useDirectByteBuffer) : (useDirectByteBuffer ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size));
        return byteBuffer;
    }

    private ByteBuffer swapBuffer(ByteBuffer byteBuffer, int size) {
        ByteBuffer tmp = this.allocateByteBuffer(this.useDirectByteBuffer, this.useByteBufferView, size);
        byteBuffer.flip();
        tmp.put(byteBuffer);
        if (this.primaryByteBuffer == null) {
            this.primaryByteBuffer = byteBuffer;
        }
        byteBuffer = tmp;
        return byteBuffer;
    }

    protected String dump(ByteBuffer byteBuffer) {
        ByteBuffer dd = byteBuffer.duplicate();
        dd.flip();
        int length = dd.limit();
        byte[] dump = new byte[length];
        dd.get(dump, 0, length);
        return new String(dump) + "\n----------------------------" + dd + "\ncontentLength: " + this.contentLength + "\nheaderLength: " + this.headerLength;
    }

    public void setSocketChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }
}

